/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.expression.language;

import com.wewebu.expression.language.OwExprBooleanValue;
import com.wewebu.expression.language.OwExprConditionalExpressionType;
import com.wewebu.expression.language.OwExprErrorTable;
import com.wewebu.expression.language.OwExprEvaluationException;
import com.wewebu.expression.language.OwExprExpression;
import com.wewebu.expression.language.OwExprExpressionType;
import com.wewebu.expression.language.OwExprScope;
import com.wewebu.expression.language.OwExprSymbolTable;
import com.wewebu.expression.language.OwExprType;
import com.wewebu.expression.language.OwExprTypeMissmatchException;
import com.wewebu.expression.language.OwExprValue;

public class OwExprConditionalExpression
extends OwExprExpression {
    private OwExprExpression m_test;
    private OwExprExpression m_trueExpression;
    private OwExprExpression m_falseExpression;

    public OwExprConditionalExpression(OwExprSymbolTable symbolTable_p, OwExprErrorTable errorTable_p, OwExprExpression test_p, OwExprExpression trueExpression_p, OwExprExpression falseExpression_p) {
        super(symbolTable_p, errorTable_p);
        this.m_test = test_p;
        this.m_trueExpression = trueExpression_p;
        this.m_falseExpression = falseExpression_p;
        this.initType();
    }

    @Override
    public OwExprValue evaluate(OwExprScope scope_p) throws OwExprEvaluationException {
        OwExprValue value = this.m_test.evaluate(scope_p);
        if (OwExprBooleanValue.value(true).equals(value)) {
            return this.m_trueExpression.evaluate(scope_p);
        }
        return this.m_falseExpression.evaluate(scope_p);
    }

    @Override
    public OwExprExpressionType type() throws OwExprTypeMissmatchException {
        OwExprExpressionType testType = null;
        OwExprExpressionType trueType = null;
        OwExprExpressionType falseType = null;
        for (boolean nofFullyRegressed = true; nofFullyRegressed; nofFullyRegressed |= falseType.regressTo(trueType.getInferringTypes())) {
            testType = this.m_test.type();
            trueType = this.m_trueExpression.type();
            falseType = this.m_falseExpression.type();
            nofFullyRegressed = testType.regressTo(OwExprType.BOOLEAN);
            nofFullyRegressed |= trueType.regressTo(falseType.getInferringTypes());
        }
        return new OwExprConditionalExpressionType(testType, trueType, falseType);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_test.toString());
        sb.append("?");
        sb.append(this.m_trueExpression.toString());
        sb.append(":");
        sb.append(this.m_falseExpression.toString());
        return sb.toString();
    }
}

