/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.expression.language;

import com.wewebu.expression.language.OwExprBinaryOperator;
import com.wewebu.expression.language.OwExprEvaluationException;
import com.wewebu.expression.language.OwExprNumericValue;
import com.wewebu.expression.language.OwExprScopedProperty;
import com.wewebu.expression.language.OwExprStringValue;
import com.wewebu.expression.language.OwExprTimeValue;
import com.wewebu.expression.language.OwExprType;
import com.wewebu.expression.language.OwExprValue;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class OwExprDateValue
extends OwExprValue
implements Comparable {
    private Calendar m_calendar;
    private Map m_datePropeties = new HashMap();

    public OwExprDateValue(Calendar calendar_p) {
        this(calendar_p, Calendar.class);
    }

    public OwExprDateValue(Calendar calendar_p, Class<?> javaType_p) {
        super(javaType_p);
        this.m_calendar = calendar_p;
        this.m_datePropeties.put("second", new DateProperty(13));
        this.m_datePropeties.put("minute", new DateProperty(12));
        this.m_datePropeties.put("hour", new DateProperty(11));
        this.m_datePropeties.put("day", new DateProperty(5));
        this.m_datePropeties.put("month", new DateProperty(2, 1));
        this.m_datePropeties.put("year", new DateProperty(1));
    }

    @Override
    public Object toJavaObject(Class javaSuperType_p) throws OwExprEvaluationException {
        if (Date.class.isAssignableFrom(javaSuperType_p)) {
            return this.m_calendar.getTime();
        }
        return this.m_calendar;
    }

    @Override
    protected final Map getValuePropeties() {
        return this.m_datePropeties;
    }

    @Override
    public final OwExprValue accept(OwExprBinaryOperator binaryOperator_p, OwExprValue v2_p) throws OwExprEvaluationException {
        return binaryOperator_p.evaluate(this, v2_p);
    }

    @Override
    public final OwExprValue accept(OwExprBinaryOperator binaryOperator_p, OwExprDateValue v1_p) throws OwExprEvaluationException {
        return binaryOperator_p.evaluate(v1_p, this);
    }

    @Override
    public OwExprValue accept(OwExprBinaryOperator binaryOperator_p, OwExprStringValue v1_p) throws OwExprEvaluationException {
        return binaryOperator_p.evaluate(v1_p, this);
    }

    @Override
    public OwExprValue accept(OwExprBinaryOperator binaryOperator_p, OwExprTimeValue v1_p) throws OwExprEvaluationException {
        return binaryOperator_p.evaluate(v1_p, this);
    }

    public final Calendar getCalendar() {
        return this.m_calendar;
    }

    public int compareTo(Object o_p) {
        if (o_p instanceof OwExprDateValue) {
            OwExprDateValue dateValue = (OwExprDateValue)o_p;
            int[] compareFields = new int[]{1, 2, 5, 10, 12, 13};
            for (int i = 0; i < compareFields.length; ++i) {
                int dif = this.m_calendar.get(compareFields[i]) - dateValue.m_calendar.get(compareFields[i]);
                if (dif == 0) continue;
                return dif;
            }
            return 0;
        }
        return 1;
    }

    public boolean equals(Object obj_p) {
        return this.compareTo(obj_p) == 0;
    }

    public int hashCode() {
        return this.m_calendar.hashCode();
    }

    public String toString() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        format.setTimeZone(this.m_calendar.getTimeZone());
        return format.format(this.m_calendar.getTime());
    }

    private class DateProperty
    extends OwExprScopedProperty {
        private int m_calendarField;
        private int m_addition = 0;

        public DateProperty(int calendarField_p) {
            this(calendarField_p, 0);
        }

        public DateProperty(int calendarField_p, int addition_p) {
            this.m_calendarField = calendarField_p;
            this.m_addition = addition_p;
        }

        @Override
        public OwExprType type() throws OwExprEvaluationException {
            return OwExprType.NUMERIC;
        }

        @Override
        public OwExprValue value() throws OwExprEvaluationException {
            int day = OwExprDateValue.this.m_calendar.get(this.m_calendarField) + this.m_addition;
            return new OwExprNumericValue(day);
        }

        @Override
        public Class<?> javaType() throws OwExprEvaluationException {
            return Integer.class;
        }
    }
}

