/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.expression.language;

import com.wewebu.expression.language.OwExprBinaryConversionTable;
import com.wewebu.expression.language.OwExprBinaryOperator;
import com.wewebu.expression.language.OwExprBooleanValue;
import com.wewebu.expression.language.OwExprDateValue;
import com.wewebu.expression.language.OwExprEvaluationException;
import com.wewebu.expression.language.OwExprNullValue;
import com.wewebu.expression.language.OwExprNumericValue;
import com.wewebu.expression.language.OwExprScopeValue;
import com.wewebu.expression.language.OwExprStringValue;
import com.wewebu.expression.language.OwExprSystem;
import com.wewebu.expression.language.OwExprTimeValue;
import com.wewebu.expression.language.OwExprType;
import com.wewebu.expression.language.OwExprValue;

public class OwExprEqualityOperator
extends OwExprBinaryOperator {
    private boolean m_negate;
    private static final OwExprBinaryConversionTable CONVERSION_TABLE = new OwExprBinaryConversionTable();
    public static final OwExprEqualityOperator EQUAL_INSTANCE;
    public static final OwExprEqualityOperator NOTEQUAL_INSTANCE;

    private OwExprEqualityOperator(String image_p, boolean negate_p, OwExprBinaryConversionTable conversionTable_p) {
        super(image_p, conversionTable_p);
        this.m_negate = negate_p;
    }

    @Override
    public OwExprValue evaluate(OwExprNumericValue v1_p, OwExprNumericValue v2_p) throws OwExprEvaluationException {
        boolean eq = v1_p.equals(v2_p);
        return OwExprBooleanValue.value(this.m_negate ? !eq : eq);
    }

    @Override
    public OwExprValue evaluate(OwExprNumericValue v1_p, OwExprStringValue v2_p) throws OwExprEvaluationException {
        boolean eq = v1_p.toString().equals(v2_p.getString());
        return OwExprBooleanValue.value(this.m_negate ? !eq : eq);
    }

    @Override
    public OwExprValue evaluate(OwExprStringValue v1_p, OwExprNumericValue v2_p) throws OwExprEvaluationException {
        boolean eq = v1_p.getString().equals(v2_p.toString());
        return OwExprBooleanValue.value(this.m_negate ? !eq : eq);
    }

    @Override
    public OwExprValue evaluate(OwExprStringValue v1_p, OwExprStringValue v2_p) throws OwExprEvaluationException {
        boolean eq = v1_p.equals(v2_p);
        return OwExprBooleanValue.value(this.m_negate ? !eq : eq);
    }

    @Override
    public OwExprValue evaluate(OwExprNullValue v1_p, OwExprValue v2_p) throws OwExprEvaluationException {
        return this.nullTest(v2_p, v1_p);
    }

    @Override
    public OwExprValue evaluate(OwExprTimeValue v1_p, OwExprTimeValue v2_p) throws OwExprEvaluationException {
        boolean eq = v1_p.getTime().equals(v2_p.getTime());
        return OwExprBooleanValue.value(this.m_negate ? !eq : eq);
    }

    @Override
    public OwExprValue evaluate(OwExprBooleanValue v1_p, OwExprBooleanValue v2_p) throws OwExprEvaluationException {
        boolean eq = v1_p.equals(v2_p);
        return OwExprBooleanValue.value(this.m_negate ? !eq : eq);
    }

    @Override
    public OwExprValue evaluate(OwExprDateValue v1_p, OwExprDateValue v2_p) throws OwExprEvaluationException {
        boolean eq = v1_p.equals(v2_p);
        return OwExprBooleanValue.value(this.m_negate ? !eq : eq);
    }

    @Override
    public OwExprValue evaluate(OwExprTimeValue v1_p, OwExprStringValue v2_p) throws OwExprEvaluationException {
        boolean eq = v1_p.toString().equals(v2_p.getString());
        return OwExprBooleanValue.value(this.m_negate ? !eq : eq);
    }

    @Override
    public OwExprValue evaluate(OwExprStringValue v1_p, OwExprTimeValue v2_p) throws OwExprEvaluationException {
        boolean eq = v1_p.getString().equals(v2_p.toString());
        return OwExprBooleanValue.value(this.m_negate ? !eq : eq);
    }

    @Override
    public OwExprValue evaluate(OwExprStringValue v1_p, OwExprDateValue v2_p) throws OwExprEvaluationException {
        boolean eq = v1_p.getString().equals(v2_p.toString());
        return OwExprBooleanValue.value(this.m_negate ? !eq : eq);
    }

    @Override
    public OwExprValue evaluate(OwExprDateValue v1_p, OwExprStringValue v2_p) throws OwExprEvaluationException {
        boolean eq = v1_p.toString().equals(v2_p.getString());
        return OwExprBooleanValue.value(this.m_negate ? !eq : eq);
    }

    @Override
    public OwExprValue evaluate(OwExprBooleanValue v1_p, OwExprStringValue v2_p) throws OwExprEvaluationException {
        boolean eq = ("" + v1_p.getBoolean()).equals(v2_p.getString());
        return OwExprBooleanValue.value(this.m_negate ? !eq : eq);
    }

    @Override
    public OwExprValue evaluate(OwExprStringValue v1_p, OwExprBooleanValue v2_p) throws OwExprEvaluationException {
        boolean eq = ("" + v2_p.getBoolean()).equals(v1_p.getString());
        return OwExprBooleanValue.value(this.m_negate ? !eq : eq);
    }

    @Override
    public OwExprValue evaluate(OwExprStringValue v1_p, OwExprNullValue v2_p) throws OwExprEvaluationException {
        return this.nullTest(v1_p, v2_p);
    }

    @Override
    public OwExprValue evaluate(OwExprNumericValue v1_p, OwExprNullValue v2_p) throws OwExprEvaluationException {
        return this.nullTest(v1_p, v2_p);
    }

    @Override
    public OwExprValue evaluate(OwExprDateValue v1_p, OwExprNullValue v2_p) throws OwExprEvaluationException {
        return this.nullTest(v1_p, v2_p);
    }

    @Override
    public OwExprValue evaluate(OwExprBooleanValue v1_p, OwExprNullValue v2_p) throws OwExprEvaluationException {
        return this.nullTest(v1_p, v2_p);
    }

    @Override
    public OwExprValue evaluate(OwExprTimeValue v1_p, OwExprNullValue v2_p) throws OwExprEvaluationException {
        return this.nullTest(v1_p, v2_p);
    }

    @Override
    public OwExprValue evaluate(OwExprScopeValue v1_p, OwExprNullValue v2_p) throws OwExprEvaluationException {
        return this.nullTest(v1_p, v2_p);
    }

    @Override
    public OwExprValue evaluate(OwExprScopeValue v1_p, OwExprScopeValue v2_p) throws OwExprEvaluationException {
        Object[] v1Array = (Object[])v1_p.toJavaObject(Object[].class);
        Object[] v2Array = (Object[])v2_p.toJavaObject(Object[].class);
        boolean eq = OwExprSystem.arrayItemEquals(v1Array, v2Array);
        return OwExprBooleanValue.value(eq);
    }

    private OwExprBooleanValue nullTest(OwExprValue v_p, OwExprNullValue nullValue_p) {
        boolean eq = nullValue_p.equals(v_p);
        return OwExprBooleanValue.value(this.m_negate ? !eq : eq);
    }

    static {
        CONVERSION_TABLE.add(OwExprType.STRING, new OwExprType[]{OwExprType.STRING, OwExprType.NUMERIC, OwExprType.TIME, OwExprType.DATE, OwExprType.BOOLEAN, OwExprType.NULL}, OwExprType.BOOLEAN);
        CONVERSION_TABLE.add(OwExprType.NULL, new OwExprType[]{OwExprType.STRING, OwExprType.NUMERIC, OwExprType.TIME, OwExprType.DATE, OwExprType.BOOLEAN, OwExprType.NULL, OwExprType.SCOPE}, OwExprType.BOOLEAN);
        CONVERSION_TABLE.add(new OwExprType[]{OwExprType.NUMERIC, OwExprType.TIME, OwExprType.DATE, OwExprType.BOOLEAN}, OwExprType.STRING, OwExprType.BOOLEAN);
        CONVERSION_TABLE.add(new OwExprType[]{OwExprType.NUMERIC, OwExprType.TIME, OwExprType.DATE, OwExprType.BOOLEAN, OwExprType.SCOPE}, OwExprType.NULL, OwExprType.BOOLEAN);
        CONVERSION_TABLE.add(OwExprType.NUMERIC, OwExprType.NUMERIC, OwExprType.BOOLEAN);
        CONVERSION_TABLE.add(OwExprType.TIME, OwExprType.TIME, OwExprType.BOOLEAN);
        CONVERSION_TABLE.add(OwExprType.DATE, OwExprType.DATE, OwExprType.BOOLEAN);
        CONVERSION_TABLE.add(OwExprType.BOOLEAN, OwExprType.BOOLEAN, OwExprType.BOOLEAN);
        EQUAL_INSTANCE = new OwExprEqualityOperator("=", false, CONVERSION_TABLE);
        NOTEQUAL_INSTANCE = new OwExprEqualityOperator("!=", true, CONVERSION_TABLE);
    }
}

