/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.expression.language;

import com.wewebu.expression.language.OwExprType;
import com.wewebu.expression.language.OwExprTypeMissmatchException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class OwExprExpressionType {
    public static final OwExprExpressionType NOTYPE = new OwExprExpressionType(OwExprType.NOTYPE);
    protected Set m_inferringTypes = new HashSet();

    public static final String printTypes(OwExprExpressionType[] types_p) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        if (types_p.length > 0) {
            sb.append(types_p[0].toString());
        }
        for (int i = 1; i < types_p.length; ++i) {
            sb.append(",");
            sb.append(types_p[i].toString());
        }
        sb.append(")");
        return sb.toString();
    }

    public OwExprExpressionType(OwExprType type_p) {
        this(new OwExprType[]{type_p});
    }

    public OwExprExpressionType(OwExprType[] inferringTypes_p) {
        this(Arrays.asList(inferringTypes_p));
    }

    public OwExprExpressionType(Collection inferringTypes_p) {
        this.m_inferringTypes.addAll(inferringTypes_p);
    }

    private boolean subsetTypes(Set types_p) throws OwExprTypeMissmatchException {
        if (types_p.isEmpty()) {
            throw new OwExprTypeMissmatchException("Incompatible types for expression " + this.printTypes(this.m_inferringTypes));
        }
        HashSet typesCopy = new HashSet(this.m_inferringTypes);
        boolean regressed = false;
        Iterator i = typesCopy.iterator();
        while (i.hasNext()) {
            OwExprType type = (OwExprType)i.next();
            if (types_p.contains(type)) continue;
            i.remove();
            regressed = true;
        }
        if (typesCopy.isEmpty()) {
            throw new OwExprTypeMissmatchException("Incompatible types " + this.printTypes(this.m_inferringTypes) + " and " + this.printTypes(types_p));
        }
        this.m_inferringTypes = typesCopy;
        return regressed;
    }

    final boolean regressTo(OwExprType type_p) throws OwExprTypeMissmatchException {
        HashSet<OwExprType> typeSet = new HashSet<OwExprType>();
        typeSet.add(type_p);
        return this.regressTo(typeSet);
    }

    final boolean regressTo(OwExprType[] types_p) throws OwExprTypeMissmatchException {
        HashSet<OwExprType> typeSet = new HashSet<OwExprType>();
        typeSet.addAll(Arrays.asList(types_p));
        return this.regressTo(typeSet);
    }

    boolean regressTo(Set regressedTypes_p) throws OwExprTypeMissmatchException {
        return this.subsetTypes(regressedTypes_p);
    }

    public boolean equals(Object obj_p) {
        if (obj_p instanceof OwExprExpressionType) {
            OwExprExpressionType typeObj = (OwExprExpressionType)obj_p;
            if (typeObj.m_inferringTypes.size() != this.m_inferringTypes.size()) {
                return false;
            }
            for (OwExprType type : this.m_inferringTypes) {
                if (typeObj.m_inferringTypes.contains(type)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return new Integer(this.m_inferringTypes.size()).hashCode();
    }

    private String printTypes(Set types_p) {
        Iterator it;
        StringBuffer sb = new StringBuffer();
        if (types_p.size() != 1) {
            sb.append("{");
        }
        if ((it = types_p.iterator()).hasNext()) {
            sb.append(it.next());
        }
        while (it.hasNext()) {
            Object typeObject = it.next();
            sb.append(",");
            sb.append(typeObject);
        }
        if (types_p.size() != 1) {
            sb.append("}");
        }
        return sb.toString();
    }

    public void regressTo(OwExprExpressionType expressionType_p) throws OwExprTypeMissmatchException {
        this.regressTo(expressionType_p.m_inferringTypes);
    }

    public boolean canInfer(OwExprType type_p) {
        return this.m_inferringTypes.contains(type_p) || type_p.equals(OwExprType.SCOPE) || type_p.equals(OwExprType.NULL);
    }

    public String toString() {
        return this.printTypes(this.m_inferringTypes);
    }

    public final Set getInferringTypes() {
        return this.m_inferringTypes;
    }
}

