/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.expression.language;

import com.wewebu.expression.language.OwExprEvaluationException;
import com.wewebu.expression.language.OwExprExpressionType;
import com.wewebu.expression.language.OwExprFunction;
import com.wewebu.expression.language.OwExprScope;
import com.wewebu.expression.language.OwExprSymbol;
import com.wewebu.expression.language.OwExprSymbolScope;
import com.wewebu.expression.language.OwExprType;
import com.wewebu.expression.language.OwExprValue;

public class OwExprFunctionSymbol
extends OwExprSymbol {
    private OwExprExpressionType[] m_argumentTypes;
    private OwExprSymbolScope m_symbolScope;

    public OwExprFunctionSymbol(OwExprSymbol parent_p, String name_p, OwExprType[] types_p) {
        super(parent_p, name_p, types_p);
    }

    public final void setArgumentTypes(OwExprExpressionType[] argumentTypes_p) {
        this.m_argumentTypes = argumentTypes_p;
    }

    public final OwExprValue getValue(OwExprScope scope_p, OwExprValue[] arguments_p) throws OwExprEvaluationException {
        OwExprScope evaluationScope = scope_p;
        if (this.m_symbolScope != null) {
            evaluationScope = this.m_symbolScope.solveScope(scope_p);
        }
        OwExprFunction function = evaluationScope.function(this.getName(), this.m_argumentTypes);
        OwExprType functionType = function.type();
        OwExprExpressionType symbolType = this.getType();
        if (!symbolType.canInfer(functionType)) {
            throw new OwExprEvaluationException("Invalid function return type " + functionType + " for symbol " + this.getSymbolFQN() + " expected " + symbolType);
        }
        return function.value(arguments_p);
    }

    @Override
    protected void toPrettyPrintString(StringBuffer sb_p, StringBuffer tabs_p) {
        sb_p.append("function");
        sb_p.append(OwExprExpressionType.printTypes(this.m_argumentTypes));
        super.toPrettyPrintString(sb_p, tabs_p);
    }

    public final void setSymbolScope(OwExprSymbolScope symbolScope_p) {
        this.m_symbolScope = symbolScope_p;
    }

    @Override
    public boolean matches(OwExprScope scope_p) {
        return true;
    }
}

