/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.expression.language;

import com.wewebu.expression.language.OwExprBinaryConversionTable;
import com.wewebu.expression.language.OwExprBinaryOperator;
import com.wewebu.expression.language.OwExprDateValue;
import com.wewebu.expression.language.OwExprEvaluationException;
import com.wewebu.expression.language.OwExprNumericValue;
import com.wewebu.expression.language.OwExprTime;
import com.wewebu.expression.language.OwExprTimeValue;
import com.wewebu.expression.language.OwExprType;
import com.wewebu.expression.language.OwExprValue;
import java.util.Calendar;

public class OwExprMinusOperator
extends OwExprBinaryOperator {
    private static final OwExprBinaryConversionTable CONVERSION_TABLE = new OwExprBinaryConversionTable();
    public static final OwExprMinusOperator INSTANCE;

    public OwExprMinusOperator(OwExprBinaryConversionTable conversionTable_p) {
        super("-", conversionTable_p);
    }

    @Override
    public final OwExprValue evaluate(OwExprNumericValue v1_p, OwExprNumericValue v2_p) throws OwExprEvaluationException {
        return v1_p.sub(v2_p);
    }

    @Override
    public final OwExprValue evaluate(OwExprDateValue v1_p, OwExprDateValue v2_p) throws OwExprEvaluationException {
        Calendar c1 = v1_p.getCalendar();
        Calendar c2 = v2_p.getCalendar();
        OwExprTime diff = OwExprTime.diff(c1, c2);
        return new OwExprTimeValue(diff);
    }

    @Override
    public final OwExprValue evaluate(OwExprDateValue v1_p, OwExprTimeValue v2_p) throws OwExprEvaluationException {
        Calendar valueC1 = v1_p.getCalendar();
        OwExprTime t2 = v2_p.getTime();
        Calendar value = t2.substractFrom(valueC1);
        OwExprDateValue dateValue = new OwExprDateValue(value);
        return dateValue;
    }

    @Override
    public OwExprValue evaluate(OwExprTimeValue v1_p, OwExprTimeValue v2_p) throws OwExprEvaluationException {
        OwExprTime t1 = v1_p.getTime();
        OwExprTime t2 = v2_p.getTime();
        OwExprTime time = t1.substract(t2);
        return new OwExprTimeValue(time);
    }

    static {
        CONVERSION_TABLE.add(OwExprType.NUMERIC, OwExprType.NUMERIC, OwExprType.NUMERIC);
        CONVERSION_TABLE.add(OwExprType.DATE, OwExprType.DATE, OwExprType.TIME);
        CONVERSION_TABLE.add(OwExprType.DATE, OwExprType.TIME, OwExprType.DATE);
        CONVERSION_TABLE.add(OwExprType.TIME, OwExprType.TIME, OwExprType.TIME);
        INSTANCE = new OwExprMinusOperator(CONVERSION_TABLE);
    }
}

