/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.expression.language;

import com.wewebu.expression.language.OwExprBinaryOperator;
import com.wewebu.expression.language.OwExprEvaluationException;
import com.wewebu.expression.language.OwExprStringValue;
import com.wewebu.expression.language.OwExprUnaryOperator;
import com.wewebu.expression.language.OwExprValue;
import java.math.BigDecimal;
import java.math.BigInteger;

public class OwExprNumericValue
extends OwExprValue
implements Comparable {
    private Number m_number;

    public OwExprNumericValue(Number number_p, Class<?> javaType_p) {
        super(javaType_p);
        this.m_number = number_p;
    }

    public OwExprNumericValue(Number number_p) {
        this(number_p, Number.class);
    }

    public OwExprNumericValue(int number_p) {
        this(new Integer(number_p));
    }

    public OwExprNumericValue(double doubleNo_p) {
        this(new Double(doubleNo_p));
    }

    @Override
    public final OwExprValue accept(OwExprBinaryOperator binaryOperator_p, OwExprValue v2_p) throws OwExprEvaluationException {
        return binaryOperator_p.evaluate(this, v2_p);
    }

    @Override
    public final OwExprValue accept(OwExprBinaryOperator binaryOperator_p, OwExprNumericValue v1_p) throws OwExprEvaluationException {
        return binaryOperator_p.evaluate(v1_p, this);
    }

    @Override
    public final OwExprValue accept(OwExprBinaryOperator binaryOperator_p, OwExprStringValue v1_p) throws OwExprEvaluationException {
        return binaryOperator_p.evaluate(v1_p, this);
    }

    @Override
    public OwExprValue accept(OwExprUnaryOperator unaryOperator_p) throws OwExprEvaluationException {
        return unaryOperator_p.evaluate(this);
    }

    public OwExprNumericValue add(OwExprNumericValue numeric_p) {
        if (this.m_number instanceof Double || numeric_p.m_number instanceof Double) {
            return new OwExprNumericValue(this.m_number.doubleValue() + numeric_p.m_number.doubleValue());
        }
        return new OwExprNumericValue(this.m_number.intValue() + numeric_p.m_number.intValue());
    }

    public OwExprNumericValue negate() {
        if (this.m_number instanceof Double) {
            return new OwExprNumericValue(-this.m_number.doubleValue());
        }
        return new OwExprNumericValue(-this.m_number.intValue());
    }

    public OwExprValue sub(OwExprNumericValue numeric_p) {
        if (this.m_number instanceof Double || numeric_p.m_number instanceof Double) {
            return new OwExprNumericValue(this.m_number.doubleValue() - numeric_p.m_number.doubleValue());
        }
        return new OwExprNumericValue(this.m_number.intValue() - numeric_p.m_number.intValue());
    }

    public OwExprValue mul(OwExprNumericValue numeric_p) {
        if (this.m_number instanceof Double || numeric_p.m_number instanceof Double) {
            return new OwExprNumericValue(this.m_number.doubleValue() * numeric_p.m_number.doubleValue());
        }
        return new OwExprNumericValue(this.m_number.intValue() * numeric_p.m_number.intValue());
    }

    public OwExprValue div(OwExprNumericValue numeric_p) throws ArithmeticException {
        double doubleNumeric = numeric_p.m_number.doubleValue();
        if (doubleNumeric == 0.0) {
            throw new ArithmeticException("Division by zero!");
        }
        return new OwExprNumericValue(this.m_number.doubleValue() / doubleNumeric);
    }

    public OwExprValue reminder(OwExprNumericValue numeric_p) throws ArithmeticException {
        if (this.m_number instanceof Double || numeric_p.m_number instanceof Double) {
            return new OwExprNumericValue(this.m_number.doubleValue() % numeric_p.m_number.doubleValue());
        }
        return new OwExprNumericValue(this.m_number.intValue() % numeric_p.m_number.intValue());
    }

    public boolean equals(Object obj_p) {
        return this.compareTo(obj_p) == 0;
    }

    public int hashCode() {
        return this.m_number.hashCode();
    }

    public int toInt() {
        return this.m_number.intValue();
    }

    public String toString() {
        return this.m_number.toString();
    }

    public int compareTo(Object o_p) {
        if (o_p instanceof OwExprNumericValue) {
            OwExprNumericValue numericObject = (OwExprNumericValue)o_p;
            double dif = this.m_number.doubleValue() - numericObject.m_number.doubleValue();
            return this.m_number.doubleValue() - numericObject.m_number.doubleValue() < 0.0 ? -1 : (dif == 0.0 ? 0 : 1);
        }
        return 1;
    }

    @Override
    public Object toJavaObject(Class javaSuperType_p) throws OwExprEvaluationException {
        if (javaSuperType_p == null || this.m_number == null || javaSuperType_p.isAssignableFrom(this.m_number.getClass())) {
            return this.m_number;
        }
        if (BigInteger.class.isAssignableFrom(javaSuperType_p)) {
            return new BigInteger(this.m_number.toString());
        }
        if (BigDecimal.class.isAssignableFrom(javaSuperType_p)) {
            return new BigDecimal(this.m_number.toString());
        }
        if (Short.class.isAssignableFrom(javaSuperType_p) || javaSuperType_p.isAssignableFrom(Short.TYPE)) {
            return new Short(this.m_number.shortValue());
        }
        if (Double.class.isAssignableFrom(javaSuperType_p) || javaSuperType_p.isAssignableFrom(Double.TYPE)) {
            return new Double(this.m_number.doubleValue());
        }
        if (Float.class.isAssignableFrom(javaSuperType_p) || javaSuperType_p.isAssignableFrom(Float.TYPE)) {
            return new Float(this.m_number.floatValue());
        }
        if (Integer.class.isAssignableFrom(javaSuperType_p) || javaSuperType_p.isAssignableFrom(Integer.TYPE)) {
            return new Integer(this.m_number.intValue());
        }
        return this.m_number;
    }
}

