/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.expression.language;

import com.wewebu.expression.language.OwExprEvaluationException;
import com.wewebu.expression.language.OwExprExpressionType;
import com.wewebu.expression.language.OwExprProperty;
import com.wewebu.expression.language.OwExprScope;
import com.wewebu.expression.language.OwExprSymbol;
import com.wewebu.expression.language.OwExprSymbolScope;
import com.wewebu.expression.language.OwExprSymbolTable;
import com.wewebu.expression.language.OwExprType;
import com.wewebu.expression.language.OwExprValue;

public class OwExprPropertySymbol
extends OwExprSymbol {
    private OwExprSymbolScope m_symbolScope;
    private boolean m_forceMatch = false;

    public OwExprPropertySymbol(OwExprSymbol parent_p, String name_p, OwExprType[] types_p) {
        super(parent_p, name_p, types_p);
    }

    public final OwExprValue getValue(OwExprScope scope_p) throws OwExprEvaluationException {
        OwExprScope evaluationScope = scope_p;
        if (this.m_symbolScope != null) {
            evaluationScope = this.m_symbolScope.solveScope(scope_p);
        }
        OwExprProperty property = evaluationScope.property(this.getName());
        OwExprType type = property.type();
        OwExprExpressionType symbolType = this.getType();
        if (!symbolType.canInfer(type)) {
            throw new OwExprEvaluationException("Invalid property type " + type + " for symbol " + this.getSymbolFQN() + " expected " + symbolType + " but found " + type);
        }
        return property.value();
    }

    @Override
    protected void toPrettyPrintString(StringBuffer sb_p, StringBuffer tabs_p) {
        sb_p.append("property ");
        super.toPrettyPrintString(sb_p, tabs_p);
    }

    public final void setSymbolScope(OwExprSymbolScope symbolScope_p) {
        this.m_symbolScope = symbolScope_p;
    }

    public void forceSymbolMatchInScope() {
        this.m_forceMatch = true;
    }

    @Override
    public boolean matches(OwExprScope scope_p) throws OwExprEvaluationException {
        if (this.m_forceMatch) {
            return true;
        }
        if (scope_p.hasProperty(this.getName())) {
            OwExprProperty property = scope_p.property(this.getName());
            OwExprSymbolTable symbolTable = this.getSymbolTable();
            return symbolTable.matchesScope(property);
        }
        return false;
    }
}

