/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.expression.language;

import com.wewebu.expression.language.OwExprEvaluationException;
import com.wewebu.expression.language.OwExprExpressionType;
import com.wewebu.expression.language.OwExprExternalScope;
import com.wewebu.expression.language.OwExprFunction;
import com.wewebu.expression.language.OwExprProperty;
import com.wewebu.expression.language.OwExprReflectiveFunction;
import com.wewebu.expression.language.OwExprReflectiveProperty;
import com.wewebu.expression.language.OwExprScopedProperty;
import com.wewebu.expression.language.OwExprType;
import com.wewebu.expression.language.OwExprValue;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class OwExprReflectiveScope
extends OwExprExternalScope {
    private static final String GETTER_PREFIX = "get";
    private Object m_scopedObject;

    public OwExprReflectiveScope(String name_p) {
        super(name_p);
        this.m_scopedObject = this;
    }

    public OwExprReflectiveScope(String name_p, Object javaObject_p) {
        super(name_p);
        this.m_scopedObject = javaObject_p;
    }

    @Override
    protected final OwExprProperty prelevateProperty(String propertyName_p) throws OwExprEvaluationException {
        OwExprProperty property = super.prelevateProperty(propertyName_p);
        if (property == null) {
            return this.prelevateReflectiveProperty(propertyName_p);
        }
        return property;
    }

    @Override
    protected final OwExprFunction prelevateFunction(String functionName_p, OwExprExpressionType[] argumentTypes_p) throws OwExprEvaluationException {
        OwExprFunction function = super.prelevateFunction(functionName_p, argumentTypes_p);
        if (function == null) {
            return this.prelevateReflectiveFunction(functionName_p, argumentTypes_p);
        }
        return function;
    }

    private Method prelevateGetter(String propertyName_p) {
        Class<?> scopedClass = this.m_scopedObject.getClass();
        Method[] allMethods = scopedClass.getMethods();
        String capitalizedPropertyName = propertyName_p.substring(0, 1).toUpperCase() + (propertyName_p.length() > 1 ? propertyName_p.substring(1) : "");
        for (int i = 0; i < allMethods.length; ++i) {
            String methodName;
            if (!Modifier.isPublic(allMethods[i].getModifiers()) || !(methodName = allMethods[i].getName()).equals(GETTER_PREFIX + capitalizedPropertyName) || allMethods[i].getParameterTypes().length != 0) continue;
            return allMethods[i];
        }
        return null;
    }

    private OwExprReflectiveProperty prelevateReflectiveProperty(String propertyName_p) throws OwExprEvaluationException {
        Method getter = this.prelevateGetter(propertyName_p);
        if (getter != null) {
            return new OwExprReflectiveProperty(propertyName_p, this.m_scopedObject, getter);
        }
        throw new OwExprEvaluationException("No such reflective property  " + propertyName_p + " in scope " + this.getName() + " aka " + this.m_scopedObject);
    }

    private OwExprReflectiveFunction prelevateReflectiveFunction(String functionName_p, OwExprExpressionType[] argumentTypes_p) throws OwExprEvaluationException {
        Class<?> scopedClass = this.m_scopedObject.getClass();
        Method[] allMethods = scopedClass.getMethods();
        for (int i = 0; i < allMethods.length; ++i) {
            Class<?>[] parameterTypes;
            String methodName;
            if (!Modifier.isPublic(allMethods[i].getModifiers()) || !(methodName = allMethods[i].getName()).equals(functionName_p) || (parameterTypes = allMethods[i].getParameterTypes()).length != argumentTypes_p.length) continue;
            boolean parametersMatch = true;
            for (int j = 0; j < parameterTypes.length; ++j) {
                OwExprType type = OwExprType.fromJavaType(parameterTypes[j]);
                if (argumentTypes_p[j].canInfer(type)) continue;
                parametersMatch = false;
                break;
            }
            if (!parametersMatch) continue;
            return new OwExprReflectiveFunction(this.m_scopedObject, allMethods[i]);
        }
        throw new OwExprEvaluationException("No such reflective function " + functionName_p + OwExprExpressionType.printTypes(argumentTypes_p) + " in scope " + this.getName() + " aka " + this.m_scopedObject);
    }

    @Override
    public OwExprProperty at(int index_p) throws OwExprEvaluationException {
        if (this.m_scopedObject.getClass().isArray()) {
            if (Array.getLength(this.m_scopedObject) <= index_p) {
                throw new OwExprEvaluationException("Index out of bounds : " + index_p + " for scope " + this.getName());
            }
            final Object javaIndexedObject = Array.get(this.m_scopedObject, index_p);
            final Class<?> javaClass = javaIndexedObject == null ? null : javaIndexedObject.getClass();
            final OwExprValue value = OwExprValue.fromJavaValue(javaIndexedObject, javaClass);
            OwExprScopedProperty valueScope = new OwExprScopedProperty(){

                @Override
                public OwExprType type() throws OwExprEvaluationException {
                    return OwExprType.fromJavaType(javaIndexedObject.getClass());
                }

                @Override
                public OwExprValue value() throws OwExprEvaluationException {
                    return value;
                }

                @Override
                public Class<?> javaType() throws OwExprEvaluationException {
                    return javaClass;
                }
            };
            return valueScope;
        }
        throw new OwExprEvaluationException("Array access on non array scope!");
    }

    @Override
    public int length() throws OwExprEvaluationException {
        if (this.m_scopedObject.getClass().isArray()) {
            return Array.getLength(this.m_scopedObject);
        }
        return 0;
    }

    @Override
    public String toString() {
        if (this.m_scopedObject == this) {
            return "R$" + super.toString();
        }
        return "R$" + this.m_scopedObject.toString();
    }

    @Override
    public boolean hasProperty(String propertyName_p) throws OwExprEvaluationException {
        if (super.hasProperty(propertyName_p)) {
            return true;
        }
        Method getter = this.prelevateGetter(propertyName_p);
        return getter != null;
    }
}

