/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.expression.language;

import com.wewebu.expression.language.OwExprErrorTable;
import com.wewebu.expression.language.OwExprEvaluationException;
import com.wewebu.expression.language.OwExprExpression;
import com.wewebu.expression.language.OwExprExpressionType;
import com.wewebu.expression.language.OwExprFunctionSymbol;
import com.wewebu.expression.language.OwExprPrimaryPrefix;
import com.wewebu.expression.language.OwExprPropertySymbol;
import com.wewebu.expression.language.OwExprScope;
import com.wewebu.expression.language.OwExprSymbolScope;
import com.wewebu.expression.language.OwExprSymbolTable;
import com.wewebu.expression.language.OwExprType;
import com.wewebu.expression.language.OwExprTypeMissmatchException;
import com.wewebu.expression.language.OwExprValue;

public class OwExprScopeSelector
extends OwExprExpression
implements OwExprPrimaryPrefix {
    private OwExprPropertySymbol m_propertySymbol;
    private OwExprFunctionSymbol m_functionSymbol;
    private OwExprPrimaryPrefix m_prefix;
    private String m_scopeMemberName;

    private static final String replaceLegacySelectorPlaceHolders(String selector_p) {
        String minus = selector_p.replaceAll("\\$M", "-");
        String dot = minus.replaceAll("\\$D", ".");
        String colon = dot.replaceAll("\\$C", ":");
        String dollar = colon.replaceAll("\\$S", "\\$");
        return dollar;
    }

    private static final String replaceSelectorPlaceHolders(String selector_p) {
        String legacyReplacedSelector = OwExprScopeSelector.replaceLegacySelectorPlaceHolders(selector_p);
        String minus = legacyReplacedSelector.replaceAll("\\\\-", "-");
        String dot = minus.replaceAll("\\\\\\u002E", ".");
        String colon = dot.replaceAll("\\\\:", ":");
        String bs = colon.replaceAll("\\\\\\\\", "\\\\");
        return bs;
    }

    public OwExprScopeSelector(OwExprSymbolTable symTable_p, OwExprErrorTable errorTable_p, String scopeMemberName_p) {
        this(symTable_p, errorTable_p, scopeMemberName_p, null);
    }

    public OwExprScopeSelector(OwExprSymbolTable symTable_p, OwExprErrorTable errorTable_p, String scopeMemberName_p, OwExprPrimaryPrefix prefix_p) {
        super(symTable_p, errorTable_p);
        this.m_prefix = prefix_p;
        this.m_scopeMemberName = OwExprScopeSelector.replaceSelectorPlaceHolders(scopeMemberName_p);
    }

    @Override
    public OwExprValue evaluate(OwExprScope scope_p) throws OwExprEvaluationException {
        if (this.m_propertySymbol != null) {
            return this.m_propertySymbol.getValue(scope_p);
        }
        throw new OwExprEvaluationException("Invalid function call !");
    }

    @Override
    public OwExprExpressionType type() throws OwExprTypeMissmatchException {
        if (!this.m_typeError) {
            if (this.m_propertySymbol != null) {
                return this.m_propertySymbol.getType();
            }
            if (this.m_functionSymbol != null) {
                return this.m_functionSymbol.getType();
            }
            throw new OwExprTypeMissmatchException("Unknonw symbol type : " + this.m_scopeMemberName);
        }
        return OwExprExpressionType.NOTYPE;
    }

    @Override
    public OwExprPropertySymbol regressToPorperty() throws OwExprTypeMissmatchException {
        if (this.m_propertySymbol == null) {
            if (this.m_prefix != null) {
                OwExprSymbolScope symbolScope = this.m_prefix.regressToScope();
                this.m_propertySymbol = symbolScope.getSymbol().addPropertySymbol(this.m_scopeMemberName, OwExprType.ALL_TYPE_TYPES);
                this.m_propertySymbol.setSymbolScope(symbolScope);
            } else {
                this.m_propertySymbol = this.m_symbolTable.addPropertySymbol(null, this.m_scopeMemberName, OwExprType.ALL_TYPE_TYPES);
            }
        }
        return this.m_propertySymbol;
    }

    @Override
    public OwExprSymbolScope regressToScope() throws OwExprTypeMissmatchException {
        this.regressToPorperty();
        return new OwExprSymbolScope(true, this.m_propertySymbol, this.expression());
    }

    @Override
    public OwExprFunctionSymbol regressToFunction() throws OwExprTypeMissmatchException {
        if (this.m_functionSymbol == null) {
            if (this.m_prefix != null) {
                OwExprSymbolScope symbolScope = this.m_prefix.regressToScope();
                this.m_functionSymbol = symbolScope.getSymbol().addFunctionSymbol(this.m_scopeMemberName, OwExprType.ALL_TYPE_TYPES);
                this.m_functionSymbol.setSymbolScope(symbolScope);
            } else {
                this.m_functionSymbol = this.m_symbolTable.addFunctionSymbol(null, this.m_scopeMemberName, OwExprType.ALL_TYPE_TYPES);
            }
        }
        return this.m_functionSymbol;
    }

    @Override
    public OwExprExpression expression() {
        if (!this.m_typeError) {
            try {
                this.regressToPorperty();
                this.initType();
            }
            catch (OwExprTypeMissmatchException e) {
                this.m_errorTable.add(e);
                this.m_typeError = true;
            }
        }
        return this;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.m_prefix != null) {
            sb.append(this.m_prefix.toString());
            sb.append(".");
        }
        sb.append(this.m_scopeMemberName);
        return sb.toString();
    }
}

