/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.expression.language;

import com.wewebu.expression.language.OwExprAnonymousSymbol;
import com.wewebu.expression.language.OwExprConstantSymbol;
import com.wewebu.expression.language.OwExprEvaluationException;
import com.wewebu.expression.language.OwExprExpressionType;
import com.wewebu.expression.language.OwExprFunctionSymbol;
import com.wewebu.expression.language.OwExprLiteral;
import com.wewebu.expression.language.OwExprPropertySymbol;
import com.wewebu.expression.language.OwExprScope;
import com.wewebu.expression.language.OwExprSymbol;
import com.wewebu.expression.language.OwExprType;
import com.wewebu.expression.language.OwExprTypeMissmatchException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class OwExprSymbolTable {
    private Map m_symbols = new HashMap();
    private int m_issuedRuntimeSymbols = 0;

    public final String issueRuntimeSymbolName() {
        ++this.m_issuedRuntimeSymbols;
        return "0$" + this.m_issuedRuntimeSymbols;
    }

    public void addSymbol(OwExprSymbol symbol_p) throws OwExprTypeMissmatchException {
        this.m_symbols.put(symbol_p.getName(), symbol_p);
    }

    public OwExprConstantSymbol addConstantSymbol(OwExprLiteral literal_p, String name_p, OwExprType types_p) throws OwExprTypeMissmatchException {
        try {
            OwExprConstantSymbol symbol = (OwExprConstantSymbol)this.m_symbols.get(name_p);
            if (symbol == null) {
                symbol = new OwExprConstantSymbol(literal_p, name_p, new OwExprType[]{types_p});
                this.addSymbol(symbol);
            }
            return symbol;
        }
        catch (ClassCastException e) {
            throw new OwExprTypeMissmatchException("Symbol " + literal_p + " can should only be used as literal !");
        }
    }

    public OwExprSymbol addAnonymousSymbol(OwExprSymbol parent_p, String name_p, OwExprExpressionType type_p) throws OwExprTypeMissmatchException {
        try {
            OwExprSymbol symbol = (OwExprSymbol)this.m_symbols.get(name_p);
            if (symbol == null) {
                symbol = new OwExprAnonymousSymbol(parent_p, name_p, type_p);
                this.addSymbol(symbol);
            }
            return symbol;
        }
        catch (ClassCastException e) {
            throw new OwExprTypeMissmatchException("Invalid Symbol " + name_p + "  !");
        }
    }

    public OwExprPropertySymbol addPropertySymbol(OwExprSymbol parent_p, String name_p, OwExprType[] types_p) throws OwExprTypeMissmatchException {
        try {
            OwExprPropertySymbol symbol = (OwExprPropertySymbol)this.m_symbols.get(name_p);
            if (symbol == null) {
                symbol = new OwExprPropertySymbol(parent_p, name_p, types_p);
                this.addSymbol(symbol);
            }
            return symbol;
        }
        catch (ClassCastException e) {
            throw new OwExprTypeMissmatchException("Symbol " + parent_p.getSymbolFQN() + "." + name_p + " can be either property or function !");
        }
    }

    public OwExprFunctionSymbol addFunctionSymbol(OwExprSymbol parent_p, String name_p, OwExprType[] types_p) throws OwExprTypeMissmatchException {
        try {
            OwExprFunctionSymbol symbol = (OwExprFunctionSymbol)this.m_symbols.get(name_p);
            if (symbol == null) {
                symbol = new OwExprFunctionSymbol(parent_p, name_p, types_p);
                this.addSymbol(symbol);
            }
            return symbol;
        }
        catch (ClassCastException e) {
            throw new OwExprTypeMissmatchException("Symbol " + parent_p.getSymbolFQN() + "." + name_p + " can be either property or function !");
        }
    }

    public OwExprSymbol getSymbol(String name_p) {
        return (OwExprSymbol)this.m_symbols.get(name_p);
    }

    public Map<String, OwExprSymbol> getSymbols() {
        return this.m_symbols;
    }

    protected void toPrettyPrintString(StringBuffer sb_p, StringBuffer tabs_p) {
        Set entries = this.m_symbols.entrySet();
        for (Map.Entry entry : entries) {
            OwExprSymbol symbol = (OwExprSymbol)entry.getValue();
            sb_p.append(tabs_p);
            symbol.toPrettyPrintString(sb_p, tabs_p);
            sb_p.append("\n");
        }
    }

    public boolean matchesScope(OwExprScope scope_p) throws OwExprEvaluationException {
        Collection symbols = this.m_symbols.values();
        for (OwExprSymbol symbol : symbols) {
            if (symbol.matches(scope_p)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.toPrettyPrintString(sb, new StringBuffer());
        return sb.toString();
    }
}

