/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.expression.language;

import com.wewebu.expression.language.OwExprReflectiveScope;
import com.wewebu.expression.language.OwExprTime;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public class OwExprSystem
extends OwExprReflectiveScope {
    public static final int VERSION_MAJOR = 1;
    public static final int VERSION_MINOR = 3;
    public static final int VERSION_UPDATE = 0;
    public static final String VERSION_STRING = "1.3.0";
    public static final String DATE_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final DecimalFormat NUMBER_FORMAT = new DecimalFormat("##");

    public OwExprSystem() {
        super("system");
    }

    public final int[] version() {
        return new int[]{1, 3, 0};
    }

    public final String getVersionString() {
        return VERSION_STRING;
    }

    public static boolean arrayItemEquals(Object item_p, Object object_p) {
        if (item_p != null && item_p.getClass().isArray()) {
            if (object_p != null && object_p.getClass().isArray()) {
                Object[] itemArray = (Object[])item_p;
                Object[] objectArray = (Object[])object_p;
                if (itemArray.length == objectArray.length) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (OwExprSystem.arrayItemEquals(itemArray[i], objectArray[i])) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        if (item_p != null) {
            return item_p.equals(object_p);
        }
        return object_p == null;
    }

    public final boolean contains(Object[] array_p, Object object_p) {
        for (int i = 0; i < array_p.length; ++i) {
            if (!OwExprSystem.arrayItemEquals(array_p[i], object_p)) continue;
            return true;
        }
        return false;
    }

    public final Calendar today() {
        Calendar today = Calendar.getInstance();
        today.set(11, 0);
        today.set(12, 0);
        today.set(13, 0);
        today.set(14, 0);
        return today;
    }

    public Calendar date(int year_p, int month_p, int day_p) {
        return this.date(year_p, month_p, day_p, 0, 0, 0);
    }

    public Calendar date(int year_p, int month_p, int day_p, String timeZoneID_p) {
        return this.date(year_p, month_p, day_p, 0, 0, 0, timeZoneID_p);
    }

    public Calendar date(int year_p, int month_p, int day_p, int hour_p, int minute_p, int second_p) {
        return this.date(year_p, month_p, day_p, hour_p, minute_p, second_p, TimeZone.getDefault().getID());
    }

    public Calendar date(int year_p, int month_p, int day_p, int hour_p, int minute_p, int second_p, String timeZoneID_p) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone(timeZoneID_p));
        calendar.set(1, year_p);
        calendar.set(2, month_p - 1);
        calendar.set(5, day_p);
        calendar.set(11, hour_p);
        calendar.set(12, minute_p);
        calendar.set(13, second_p);
        calendar.set(14, 0);
        return calendar;
    }

    public Calendar date(String date_p) throws ParseException {
        TimeZone GMT;
        String dateString = date_p;
        if (dateString.length() == 25 && dateString.charAt(22) == ':' && (dateString.charAt(19) == '+' || dateString.charAt(19) == '-')) {
            dateString = dateString.substring(0, 22) + dateString.substring(23, 25);
        }
        String timeZoneString = dateString.substring(19);
        TimeZone timeZone = GMT = TimeZone.getTimeZone("GMT");
        if (!timeZoneString.equals("GMT") && (timeZone = TimeZone.getTimeZone(timeZoneString)).equals(GMT)) {
            if (timeZoneString.length() == 5) {
                int timeSign = timeZoneString.charAt(0) == '-' ? -1 : 1;
                String hourOffsetStr = timeZoneString.substring(1, 3);
                String minuteOffsetStr = timeZoneString.substring(3, 5);
                try {
                    NUMBER_FORMAT.parse("02").intValue();
                    int hourOffset = NUMBER_FORMAT.parse(hourOffsetStr).intValue();
                    int minuteOffset = NUMBER_FORMAT.parse(minuteOffsetStr).intValue();
                    timeZone.setRawOffset(timeSign * (int)((double)hourOffset * 3600000.0 + (double)minuteOffset * 60000.0));
                }
                catch (ParseException e) {
                    throw new ParseException("Invalid time zone offset : " + timeZoneString, 19);
                }
            } else {
                throw new ParseException("Invalid time zone : " + timeZoneString, 19);
            }
        }
        TimeZone gmtRelative = TimeZone.getTimeZone("GMT");
        gmtRelative.setRawOffset(timeZone.getRawOffset());
        timeZone = gmtRelative;
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_STRING);
        Calendar initCalendar = Calendar.getInstance();
        dateFormat.setCalendar(initCalendar);
        dateFormat.setTimeZone(timeZone);
        dateFormat.parse(dateString);
        Calendar calendar = dateFormat.getCalendar();
        Calendar calClone = (Calendar)calendar.clone();
        return calClone;
    }

    public final OwExprTime days(double days_p) {
        return OwExprTime.timeInDays(days_p);
    }

    public final OwExprTime seconds(int seconds_p) {
        return OwExprTime.seconds(seconds_p);
    }

    public final OwExprTime minutes(int minutes_p) {
        return OwExprTime.minutes(minutes_p);
    }

    public final OwExprTime hours(int hours_p) {
        return OwExprTime.hours(hours_p);
    }

    public final OwExprTime time(int hours_p, int minutes_p, int seconds_p) {
        return OwExprTime.time(hours_p, minutes_p, seconds_p);
    }
}

