/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.expression.language;

import com.wewebu.expression.language.OwExprBooleanValue;
import com.wewebu.expression.language.OwExprEvaluationException;
import com.wewebu.expression.language.OwExprExpression;
import com.wewebu.expression.language.OwExprExpressionType;
import com.wewebu.expression.language.OwExprNumericValue;
import com.wewebu.expression.language.OwExprOperator;
import com.wewebu.expression.language.OwExprScope;
import com.wewebu.expression.language.OwExprType;
import com.wewebu.expression.language.OwExprTypeMissmatchException;
import com.wewebu.expression.language.OwExprUnaryConversionTable;
import com.wewebu.expression.language.OwExprUnaryExpressionType;
import com.wewebu.expression.language.OwExprValue;
import java.util.HashSet;
import java.util.Set;

public abstract class OwExprUnaryOperator
extends OwExprOperator {
    private OwExprUnaryConversionTable m_conversionTable;

    public OwExprUnaryOperator(String image_p, OwExprUnaryConversionTable conversionTable_p) {
        super(image_p);
        this.m_conversionTable = conversionTable_p;
    }

    public final OwExprValue evaluate(OwExprScope scope_p, OwExprExpression expression_p) throws OwExprEvaluationException {
        OwExprValue value = expression_p.evaluate(scope_p);
        return value.accept(this);
    }

    public OwExprValue evaluate(OwExprBooleanValue booleanValue_p) throws OwExprEvaluationException {
        throw new OwExprEvaluationException("Unsupported operator " + this + " for operand " + booleanValue_p);
    }

    public OwExprValue evaluate(OwExprNumericValue numericValue_p) throws OwExprEvaluationException {
        throw new OwExprEvaluationException("Unsupported operator " + this + " for operand " + numericValue_p);
    }

    public final OwExprType computeType(OwExprType type_p) throws OwExprTypeMissmatchException {
        return this.m_conversionTable.convert(type_p);
    }

    public final Set getRegressingTypes(Set regressedTypes_p) {
        return this.m_conversionTable.getConversionsType(regressedTypes_p);
    }

    public final OwExprUnaryExpressionType computeExpressionType(OwExprExpression operand_p) throws OwExprTypeMissmatchException {
        boolean notFullyRegressed = true;
        OwExprExpressionType type = null;
        HashSet<OwExprType> computedTypes = null;
        while (notFullyRegressed) {
            type = operand_p.type();
            Set types = type.getInferringTypes();
            HashSet<OwExprType> typesConvertible = new HashSet<OwExprType>();
            computedTypes = new HashSet<OwExprType>();
            for (OwExprType theType : types) {
                OwExprType computedType = this.computeType(theType);
                if (computedType.equals(OwExprType.NOTYPE)) continue;
                computedTypes.add(computedType);
                typesConvertible.add(theType);
            }
            if (typesConvertible.isEmpty()) {
                throw new OwExprTypeMissmatchException("Incompatible operand type " + type + " for operator " + this.toString());
            }
            notFullyRegressed = type.regressTo(typesConvertible);
        }
        return new OwExprUnaryExpressionType(this, type, computedTypes);
    }
}

