/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.expression.language;

import com.wewebu.expression.language.OwExprBinaryOperator;
import com.wewebu.expression.language.OwExprBooleanValue;
import com.wewebu.expression.language.OwExprDateValue;
import com.wewebu.expression.language.OwExprEvaluationException;
import com.wewebu.expression.language.OwExprExpressionType;
import com.wewebu.expression.language.OwExprFunction;
import com.wewebu.expression.language.OwExprNullValue;
import com.wewebu.expression.language.OwExprNumericValue;
import com.wewebu.expression.language.OwExprProperty;
import com.wewebu.expression.language.OwExprReflectiveScope;
import com.wewebu.expression.language.OwExprScope;
import com.wewebu.expression.language.OwExprScopeValue;
import com.wewebu.expression.language.OwExprStringValue;
import com.wewebu.expression.language.OwExprTime;
import com.wewebu.expression.language.OwExprTimeValue;
import com.wewebu.expression.language.OwExprUnaryOperator;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public abstract class OwExprValue
implements OwExprScope {
    private static final Map NOPROPERTIES = new HashMap();
    private OwExprReflectiveScope reflectiveScope;
    private Class<?> javaType;

    public static final OwExprValue fromJavaValue(Object javaValue_p) throws OwExprEvaluationException {
        return OwExprValue.fromJavaValue(javaValue_p, javaValue_p == null ? null : javaValue_p.getClass());
    }

    public static final OwExprValue fromJavaValue(Object javaValue_p, Class<?> javaType_p) throws OwExprEvaluationException {
        if (javaValue_p == null) {
            return OwExprNullValue.INSTANCE;
        }
        if (javaValue_p instanceof Number) {
            return new OwExprNumericValue((Number)javaValue_p, javaType_p);
        }
        if (javaValue_p instanceof String) {
            return new OwExprStringValue((String)javaValue_p, javaType_p);
        }
        if (javaValue_p instanceof Character) {
            return new OwExprStringValue(javaValue_p.toString(), javaType_p);
        }
        if (javaValue_p instanceof Calendar) {
            return new OwExprDateValue((Calendar)javaValue_p, javaType_p);
        }
        if (javaValue_p instanceof OwExprTime) {
            return new OwExprTimeValue((OwExprTime)javaValue_p, javaType_p);
        }
        if (javaValue_p instanceof Date) {
            Date date = (Date)javaValue_p;
            Calendar c = Calendar.getInstance();
            c.setTime(date);
            return new OwExprDateValue(c, javaType_p);
        }
        if (javaValue_p instanceof Boolean) {
            return OwExprBooleanValue.value((Boolean)javaValue_p);
        }
        if (javaValue_p instanceof OwExprScope) {
            return new OwExprScopeValue((OwExprScope)javaValue_p);
        }
        return new OwExprScopeValue(new OwExprReflectiveScope("V$", javaValue_p));
    }

    public OwExprValue(Class javaType_p) {
        this.javaType = javaType_p;
    }

    private OwExprReflectiveScope getReflectiveScope() {
        if (this.reflectiveScope == null) {
            this.reflectiveScope = new OwExprReflectiveScope(this.toString(), this);
        }
        return this.reflectiveScope;
    }

    public abstract Object toJavaObject(Class var1) throws OwExprEvaluationException;

    public OwExprValue accept(OwExprBinaryOperator binaryOperator_p, OwExprValue v2_p) throws OwExprEvaluationException {
        throw new OwExprEvaluationException("Invalid operation " + binaryOperator_p + " for values " + this + " and " + v2_p);
    }

    public OwExprValue accept(OwExprBinaryOperator binaryOperator_p, OwExprBooleanValue v1_p) throws OwExprEvaluationException {
        throw new OwExprEvaluationException("Invalid operation " + binaryOperator_p + " for values " + v1_p + " and " + this);
    }

    public OwExprValue accept(OwExprBinaryOperator binaryOperator_p, OwExprNumericValue v1_p) throws OwExprEvaluationException {
        throw new OwExprEvaluationException("Invalid operation " + binaryOperator_p + " for values " + v1_p + " and " + this);
    }

    public OwExprValue accept(OwExprBinaryOperator binaryOperator_p, OwExprStringValue v1_p) throws OwExprEvaluationException {
        throw new OwExprEvaluationException("Invalid operation " + binaryOperator_p + " for values " + v1_p + " and " + this);
    }

    public OwExprValue accept(OwExprBinaryOperator binaryOperator_p, OwExprDateValue v1_p) throws OwExprEvaluationException {
        throw new OwExprEvaluationException("Invalid operation " + binaryOperator_p + " for values " + v1_p + " and " + this);
    }

    public OwExprValue accept(OwExprBinaryOperator binaryOperator_p, OwExprTimeValue v1_p) throws OwExprEvaluationException {
        throw new OwExprEvaluationException("Invalid operation " + binaryOperator_p + " for values " + v1_p + " and " + this);
    }

    public OwExprValue accept(OwExprBinaryOperator binaryOperator_p, OwExprScopeValue v1_p) throws OwExprEvaluationException {
        throw new OwExprEvaluationException("Invalid operation " + binaryOperator_p + " for values " + v1_p + " and " + this);
    }

    public OwExprValue accept(OwExprUnaryOperator unaryOperator_p) throws OwExprEvaluationException {
        throw new OwExprEvaluationException("Invalid operation " + unaryOperator_p + " for values " + this);
    }

    @Override
    public OwExprFunction function(String functionName_p, OwExprExpressionType[] argunmentTypes_p) throws OwExprEvaluationException {
        OwExprReflectiveScope myReflectiveScope = this.getReflectiveScope();
        return myReflectiveScope.function(functionName_p, argunmentTypes_p);
    }

    @Override
    public OwExprProperty at(int index_p) throws OwExprEvaluationException {
        throw new OwExprEvaluationException("Array access on non array value : " + this);
    }

    @Override
    public int length() throws OwExprEvaluationException {
        return 0;
    }

    protected Map getValuePropeties() {
        return NOPROPERTIES;
    }

    @Override
    public OwExprProperty property(String propertyName_p) throws OwExprEvaluationException {
        OwExprProperty property = (OwExprProperty)this.getValuePropeties().get(propertyName_p);
        if (property != null) {
            return property;
        }
        throw new OwExprEvaluationException("No such property <" + propertyName_p + "> for dynamic scope " + this);
    }

    @Override
    public boolean hasProperty(String propertyName_p) throws OwExprEvaluationException {
        return this.getValuePropeties().containsKey(propertyName_p);
    }

    public final Class<?> getJavaType() {
        return this.javaType;
    }
}

