/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis;

import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwPermissionCollection;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwStandardPropertyClass;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.ecm.OwVersion;
import com.wewebu.ow.server.ecm.OwVersionSeries;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISResource;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISRepositoryObject;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwSearchTemplate;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwString1;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public abstract class OwCMISAbstractDomainFolder
implements OwObject {
    private static final Logger LOG = OwLog.getLogger(OwCMISAbstractDomainFolder.class);
    private OwPropertyCollection m_properties;
    private String m_dmsid;
    protected OwCMISNetwork m_network;
    private Object m_uniqueObject = new Object();

    public OwCMISAbstractDomainFolder(OwCMISNetwork network_p) {
        this.m_network = network_p;
        this.m_properties = new OwStandardPropertyCollection();
    }

    public String getDMSID() {
        if (this.m_dmsid == null) {
            this.m_dmsid = "cmis," + this.getName() + "," + Integer.toString(this.getID().hashCode());
        }
        return this.m_dmsid;
    }

    public final String getID() {
        return this.getName() + this.m_uniqueObject.hashCode();
    }

    public OwPropertyCollection getProperties(Collection propertyNames_p) throws OwException {
        return this.m_properties;
    }

    public OwProperty getProperty(String strPropertyName_p) throws OwException {
        OwProperty ret = (OwProperty)this.m_properties.get((Object)strPropertyName_p);
        if (ret == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("OwCMISAbstractDomainFolder.getProperty: no such property " + strPropertyName_p + " found !"));
            }
            throw new OwObjectNotFoundException((OwString)new OwString1("ecmimpl.cmis.OwCMISAbstractDomainFolder.property.value.found.error", "No value found for the %1 property!", strPropertyName_p));
        }
        return ret;
    }

    public OwField getField(String strFieldClassName_p) throws OwException {
        return this.getProperty(strFieldClassName_p);
    }

    public Collection getFields() throws OwException {
        return this.getProperties(null).values();
    }

    public void setProperties(OwPropertyCollection properties_p, Object mode_p) throws OwException {
        this.setProperties(properties_p);
    }

    public void setProperties(OwPropertyCollection properties_p) throws OwException {
    }

    public void add(OwObject oObject_p) throws OwException {
        LOG.error((Object)"OwCMISAbstractDomainFolder.add: adding of objects to CMIS domain folder objects is not supported!");
        throw new OwNotSupportedException(OwString.localize((Locale)this.m_network.getLocale(), (String)"ecmimpl.cmis.unsupported.object.operation", (String)"Unsupported CMIS adapter object operation!"));
    }

    public boolean canAdd(OwObject oObject_p, int iContext_p) throws OwException {
        return false;
    }

    public void move(OwObject oObject_p, OwObject oldParent_p) throws OwException {
    }

    public boolean canMove(OwObject oObject_p, OwObject oldParent_p, int iContext_p) throws OwException {
        return false;
    }

    public boolean canDelete(int iContext_p) throws OwException {
        return false;
    }

    public boolean canGetProperties(int iContext_p) throws OwException {
        return false;
    }

    public boolean canLock() throws OwException {
        return false;
    }

    public boolean canRemoveReference(OwObject oObject_p, int iContext_p) throws OwException {
        return false;
    }

    public boolean canGetContent(int iContentType_p, int iContext_p) throws OwException {
        return false;
    }

    public boolean canSetContent(int iContentType_p, int iContext_p) throws OwException {
        return false;
    }

    public boolean canSetProperties(int iContext_p) throws OwException {
        return false;
    }

    public void delete() throws OwException {
    }

    public boolean canFilterChilds() throws OwException {
        return false;
    }

    public Collection getFilterProperties(Collection propertynames_p) throws OwException {
        return null;
    }

    public OwPropertyCollection getClonedProperties(Collection strPropertyNames_p) throws OwException {
        try {
            return OwStandardPropertyClass.getClonedProperties((OwObject)this, (Collection)strPropertyNames_p);
        }
        catch (OwException owdException) {
            throw owdException;
        }
        catch (Exception e) {
            String msg = "OwCMISAbstractDomainFolder.getClonedProperties: Error during cloning of properties collection.";
            LOG.warn((Object)msg, (Throwable)e);
            throw new OwServerException(msg, (Throwable)e);
        }
    }

    public Collection getColumnInfoList() throws OwException {
        return null;
    }

    public boolean getLock(int iContext_p) throws OwException {
        return false;
    }

    public boolean getMyLock(int iContext_p) throws OwException {
        return false;
    }

    public String getLockUserID(int iContext_p) throws OwException {
        return null;
    }

    public OwPermissionCollection getPermissions() throws OwException {
        return null;
    }

    public OwPermissionCollection getClonedPermissions() throws OwException {
        LOG.warn((Object)"OwCMISAbstractDomainFolder.getClonedPermissions: permissions of CMIS domain folder objects are not supported!");
        throw new OwNotSupportedException(OwString.localize((Locale)this.m_network.getLocale(), (String)"ecmimpl.cmis.unsupported.object.operation", (String)"Unsupported CMIS adapter object operation!"));
    }

    public boolean canGetPermissions() throws OwException {
        return false;
    }

    public boolean canSetPermissions() throws OwException {
        return false;
    }

    public void setPermissions(OwPermissionCollection permissions_p) throws OwException {
        LOG.error((Object)"OwCMISAbstractDomainFolder.setPermissions: permissions of CMIS domain folder objects are not supported!");
        throw new OwNotSupportedException(OwString.localize((Locale)this.m_network.getLocale(), (String)"ecmimpl.cmis.unsupported.object.operation", (String)"Unsupported CMIS adapter object operation!"));
    }

    public void refreshProperties() throws OwException {
    }

    public void refreshProperties(Collection props_p) throws OwException {
        this.refreshProperties();
    }

    public void setContentCollection(OwContentCollection content_p) throws OwException {
    }

    public OwContentCollection getContentCollection() throws OwException {
        LOG.error((Object)"OwCMISAbstractDomainFolder.getContentCollection: content of CMIS domain folder objects is not supported!");
        throw new OwNotSupportedException(OwString.localize((Locale)this.m_network.getLocale(), (String)"ecmimpl.cmis.unsupported.object.operation", (String)"Unsupported CMIS adapter object operation!"));
    }

    public Object getNativeObject() throws OwException {
        LOG.error((Object)"OwCMISAbstractDomainFolder.getNativeObject: native objects of CMIS domain folder objects are not supported!");
        throw new OwNotSupportedException(OwString.localize((Locale)this.m_network.getLocale(), (String)"ecmimpl.cmis.unsupported.object.operation", (String)"Unsupported CMIS adapter object operation!"));
    }

    public OwObjectCollection getParents() throws OwException {
        return null;
    }

    public Object getSafeFieldValue(String sName_p, Object defaultvalue_p) {
        try {
            return this.getProperty(sName_p).getValue();
        }
        catch (Exception e) {
            LOG.debug((Object)("OwCMISAbstractDomainFolder.getSafeFieldValue: could not retrieve property named = " + sName_p), (Throwable)e);
            return defaultvalue_p;
        }
    }

    protected OwCMISNetwork getNetwork() {
        return this.m_network;
    }

    public OwObject getInstance() throws OwException {
        return this;
    }

    public OwSearchTemplate getSearchTemplate() throws OwException {
        return null;
    }

    public OwVersionSeries getVersionSeries() throws OwException {
        return null;
    }

    public boolean hasVersionSeries() throws OwException {
        return false;
    }

    public OwVersion getVersion() throws OwException {
        return null;
    }

    public boolean hasContent(int iContext_p) throws OwException {
        return false;
    }

    public String getFieldProviderName() {
        return this.getName();
    }

    public void setField(String sName_p, Object value_p) throws OwException {
        throw new OwInvalidOperationException("cmis.OwCMISAbstractDomainFolder.setField: Invalid operation on virtual root.");
    }

    public void changeClass(String strNewClassName_p, OwPropertyCollection properties_p, OwPermissionCollection permissions_p) throws OwException {
        LOG.error((Object)"OwCMISAbstractDomainFolder.changeClass: class changing of CMIS domain folder objects is not supported!");
        throw new OwNotSupportedException(OwString.localize((Locale)this.getNetwork().getLocale(), (String)"ecmimpl.cmis.unsupported.object.operation", (String)"Unsupported CMIS adapter object operation!"));
    }

    public boolean canChangeClass() throws OwException {
        return false;
    }

    public boolean setLock(boolean fLock_p) throws OwException {
        return false;
    }

    public Object getFieldProviderSource() {
        return this;
    }

    public int getFieldProviderType() {
        return 1;
    }

    public void removeReference(OwObject oObject_p) throws OwException {
    }

    public int getType() {
        return 0;
    }

    public String getPath() throws Exception {
        LOG.error((Object)"OwCMISAbstractDomainFolder.getPath: path information of CMIS domain folder objects is not supported!");
        throw new OwNotSupportedException(OwString.localize((Locale)this.getNetwork().getLocale(), (String)"ecmimpl.cmis.unsupported.object.operation", (String)"Unsupported CMIS adapter object operation!"));
    }

    protected List<OwCMISRepositoryObject> createRepositoryFolders() throws OwException {
        LinkedList<OwCMISRepositoryObject> folders = new LinkedList<OwCMISRepositoryObject>();
        Iterator<String> it = this.getNetwork().getResourceIDs();
        while (it.hasNext()) {
            OwCMISResource resource = this.getNetwork().getResource(it.next());
            folders.add(new OwCMISRepositoryObject(this.getNetwork(), resource));
        }
        return folders;
    }
}

