/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis;

import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecmimpl.OwAbstractCredentials;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISSimpleUserInfo;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISUserInfo;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.wshandler.OwCMISContentHandler;
import com.wewebu.ow.server.ecmimpl.cmis.wshandler.OwCMISSecurityHandlerInterface;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.mandator.OwMandator;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import javax.xml.ws.soap.MTOMFeature;
import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.ws._200908.ACLService;
import org.oasis_open.docs.ns.cmis.ws._200908.ACLServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.DiscoveryService;
import org.oasis_open.docs.ns.cmis.ws._200908.DiscoveryServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.MultiFilingService;
import org.oasis_open.docs.ns.cmis.ws._200908.MultiFilingServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.NavigationService;
import org.oasis_open.docs.ns.cmis.ws._200908.NavigationServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.ObjectService;
import org.oasis_open.docs.ns.cmis.ws._200908.ObjectServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.PolicyService;
import org.oasis_open.docs.ns.cmis.ws._200908.PolicyServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.RelationshipService;
import org.oasis_open.docs.ns.cmis.ws._200908.RelationshipServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.RepositoryService;
import org.oasis_open.docs.ns.cmis.ws._200908.RepositoryServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.VersioningService;
import org.oasis_open.docs.ns.cmis.ws._200908.VersioningServicePort;

public class OwCMISCredentials
extends OwAbstractCredentials {
    private static final Logger LOG = OwLog.getLogger(OwCMISCredentials.class);
    public static final String CONF_NODE_WSDL_REPOSITORY = "WSDLRepository";
    public static final String CONF_NODE_WSDL_NAVIGATION = "WSDLNavigation";
    public static final String CONF_NODE_WSDL_OBJECT = "WSDLObject";
    public static final String CONF_NODE_WSDL_MULTIFILING = "WSDLMultifiling";
    public static final String CONF_NODE_WSDL_DISCOVERY = "WSDLDiscovery";
    public static final String CONF_NODE_WSDL_VERSIONING = "WSDLVersioning";
    public static final String CONF_NODE_WSDL_RELATIONSHIP = "WSDLRelationship";
    public static final String CONF_NODE_WSDL_POLICY = "WSDLPolicy";
    public static final String CONF_NODE_WSDL_ACL = "WSDLACL";
    public static final String AUTH_NONE = "NONE";
    public static final String AUTH_LDAP = "LDAP";
    private OwCMISUserInfo m_userinfo;
    private RepositoryServicePort m_repositoryServicePort;
    private ObjectServicePort m_objectServicesPort;
    private NavigationServicePort m_navigationServicePort;
    private DiscoveryServicePort m_discoveryServicePort;
    private MultiFilingServicePort m_multiFilingServicePort;
    private PolicyServicePort m_policyServicePort;
    private ACLServicePort m_aclServicePort;
    private RelationshipServicePort m_relationshipServicePort;
    private VersioningServicePort m_versioningServicePort;
    private OwCMISSecurityHandlerInterface m_securityHandler;
    private SOAPHandler<SOAPMessageContext> m_contentHandler;
    private OwMandator m_mandator;
    private OwXMLUtil configuration;
    private HashMap<String, URL> m_serviceURLs;

    public OwCMISCredentials(OwXMLUtil configuration_p, String username_p, String password_p, OwCMISSecurityHandlerInterface securityhandler_p, OwMandator mandator_p) throws OwException {
        super(username_p, password_p);
        this.m_securityHandler = securityhandler_p;
        this.m_mandator = mandator_p;
        this.m_contentHandler = this.createContentHandler();
        this.configuration = configuration_p;
        this.m_serviceURLs = new HashMap();
    }

    public OwMandator getMandator() {
        return this.m_mandator;
    }

    public void setMandator(OwMandator madator_p) {
        this.m_mandator = madator_p;
    }

    public ObjectServicePort getObjectServicePort() throws OwException {
        return this.getObjectServicePort(this.getServiceURL(CONF_NODE_WSDL_OBJECT));
    }

    public ObjectServicePort getObjectServicePort(URL wsdlLocation_p) {
        if (this.m_objectServicesPort == null) {
            ObjectService s = new ObjectService(wsdlLocation_p);
            this.m_objectServicesPort = s.getObjectServicePort(new WebServiceFeature[]{new MTOMFeature()});
            this.setSecurity((BindingProvider)this.m_objectServicesPort);
        }
        return this.m_objectServicesPort;
    }

    protected URL getServiceURL(String confNode_p) throws OwException {
        if (this.m_serviceURLs.containsKey(confNode_p)) {
            return this.m_serviceURLs.get(confNode_p);
        }
        URL url = null;
        try {
            url = this.configuration.getURLFromNode(confNode_p);
        }
        catch (MalformedURLException e) {
            LOG.error((Object)("OwCMISNetwork.getURLFromNode(): Invalid CMIS configuration! The request node " + confNode_p + " does not contain a valid URL."), (Throwable)e);
            throw new OwConfigurationException(new OwString("ecmimpl.cmis.OwCMISNetwork.invalid.configuration.error", "Invalid CMIS configuration!"), (Throwable)e);
        }
        if (url != null) {
            this.m_serviceURLs.put(confNode_p, url);
        }
        return url;
    }

    public RepositoryServicePort getRepositoryServicePort() throws OwConfigurationException {
        RepositoryServicePort result = null;
        try {
            result = this.getRepositoryServicePort(this.getServiceURL(CONF_NODE_WSDL_REPOSITORY));
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot obtain repository service port", (Throwable)e);
            throw new OwConfigurationException("Cannot obtain repository service port", (Throwable)e);
        }
        return result;
    }

    public RepositoryServicePort getRepositoryServicePort(URL wsdlLocation_p) {
        if (null == this.m_repositoryServicePort) {
            RepositoryService s = new RepositoryService(wsdlLocation_p);
            this.m_repositoryServicePort = s.getRepositoryServicePort();
            this.setSecurity((BindingProvider)this.m_repositoryServicePort);
        }
        return this.m_repositoryServicePort;
    }

    public NavigationServicePort getNavigationServicePort() throws OwException {
        return this.getNavigationServicePort(this.getServiceURL(CONF_NODE_WSDL_NAVIGATION));
    }

    public NavigationServicePort getNavigationServicePort(URL wsdlLocation_p) {
        if (null == this.m_navigationServicePort) {
            NavigationService s = new NavigationService(wsdlLocation_p);
            this.m_navigationServicePort = s.getNavigationServicePort();
            this.setSecurity((BindingProvider)this.m_navigationServicePort);
        }
        return this.m_navigationServicePort;
    }

    public DiscoveryServicePort getDiscoveryServicePort() throws OwException {
        return this.getDiscoveryServicePort(this.getServiceURL(CONF_NODE_WSDL_DISCOVERY));
    }

    public DiscoveryServicePort getDiscoveryServicePort(URL url_p) {
        if (this.m_discoveryServicePort == null) {
            DiscoveryService s = new DiscoveryService(url_p);
            this.m_discoveryServicePort = s.getDiscoveryServicePort();
            this.setSecurity((BindingProvider)this.m_discoveryServicePort);
        }
        return this.m_discoveryServicePort;
    }

    public MultiFilingServicePort getMultiFilingservicePort() throws OwException {
        return this.getMultiFilingservicePort(this.getServiceURL(CONF_NODE_WSDL_MULTIFILING));
    }

    public MultiFilingServicePort getMultiFilingservicePort(URL wsdlLocation_p) {
        if (this.m_multiFilingServicePort == null) {
            MultiFilingService s = new MultiFilingService(wsdlLocation_p);
            this.m_multiFilingServicePort = s.getMultiFilingServicePort();
            this.setSecurity((BindingProvider)this.m_multiFilingServicePort);
        }
        return this.m_multiFilingServicePort;
    }

    public VersioningServicePort getVersionServicePort() throws OwException {
        return this.getVersionServicePort(this.getServiceURL(CONF_NODE_WSDL_VERSIONING));
    }

    public VersioningServicePort getVersionServicePort(URL wsdlLocation_p) {
        if (this.m_versioningServicePort == null) {
            VersioningService s = new VersioningService(wsdlLocation_p);
            this.m_versioningServicePort = s.getVersioningServicePort(new WebServiceFeature[]{new MTOMFeature()});
            this.setSecurity((BindingProvider)this.m_versioningServicePort);
        }
        return this.m_versioningServicePort;
    }

    public RelationshipServicePort getRelationshipServicePort() throws OwException {
        return this.getRelationshipServicePort(this.getServiceURL(CONF_NODE_WSDL_RELATIONSHIP));
    }

    public RelationshipServicePort getRelationshipServicePort(URL wsdlLocation_p) {
        if (this.m_relationshipServicePort == null) {
            RelationshipService s = new RelationshipService(wsdlLocation_p);
            this.m_relationshipServicePort = s.getRelationshipServicePort();
            this.setSecurity((BindingProvider)this.m_relationshipServicePort);
        }
        return this.m_relationshipServicePort;
    }

    public PolicyServicePort getPolicyServicePort() throws OwException {
        return this.getPolicyServicePort(this.getServiceURL(CONF_NODE_WSDL_POLICY));
    }

    public PolicyServicePort getPolicyServicePort(URL wsdlLocation_p) {
        if (this.m_policyServicePort == null) {
            PolicyService s = new PolicyService(wsdlLocation_p);
            this.m_policyServicePort = s.getPolicyServicePort();
            this.setSecurity((BindingProvider)this.m_policyServicePort);
        }
        return this.m_policyServicePort;
    }

    public ACLServicePort getACLServicePort() throws OwException {
        return this.getACLServicePort(this.getServiceURL(CONF_NODE_WSDL_ACL));
    }

    public ACLServicePort getACLServicePort(URL wsdlLocation_p) {
        if (this.m_aclServicePort == null) {
            ACLService s = new ACLService(wsdlLocation_p);
            this.m_aclServicePort = s.getACLServicePort();
            this.setSecurity((BindingProvider)this.m_aclServicePort);
        }
        return this.m_aclServicePort;
    }

    private void setSecurity(BindingProvider bp_p) {
        Binding binding = bp_p.getBinding();
        bp_p.getRequestContext().put("javax.xml.ws.security.auth.password", this.getAuthInfo("Password"));
        bp_p.getRequestContext().put("javax.xml.ws.security.auth.username", this.getAuthInfo("USER"));
        List handlerChain = binding.getHandlerChain();
        handlerChain.add(this.getContentHandler());
        handlerChain.add(this.getSecurityHandler());
        binding.setHandlerChain(handlerChain);
    }

    public OwCMISSecurityHandlerInterface getSecurityHandler() {
        return this.m_securityHandler;
    }

    public String getSecurityToken(OwResource resource_p) {
        return null;
    }

    protected synchronized OwCMISUserInfo createUserInfo(String userName_p) {
        return new OwCMISSimpleUserInfo(userName_p, this.m_mandator);
    }

    public OwCMISUserInfo getUserInfo() throws OwException {
        if (this.m_userinfo == null) {
            this.m_userinfo = this.createUserInfo(this.getAuthInfo("USER"));
        }
        return this.m_userinfo;
    }

    public void invalidate() throws OwException {
        if (this.m_relationshipServicePort != null) {
            this.removeHandler((BindingProvider)this.m_relationshipServicePort);
            this.m_relationshipServicePort = null;
        }
        if (this.m_versioningServicePort != null) {
            this.removeHandler((BindingProvider)this.m_versioningServicePort);
            this.m_versioningServicePort = null;
        }
        if (this.m_policyServicePort != null) {
            this.removeHandler((BindingProvider)this.m_policyServicePort);
            this.m_policyServicePort = null;
        }
        if (this.m_multiFilingServicePort != null) {
            this.removeHandler((BindingProvider)this.m_multiFilingServicePort);
            this.m_multiFilingServicePort = null;
        }
        if (this.m_aclServicePort != null) {
            this.removeHandler((BindingProvider)this.m_aclServicePort);
            this.m_aclServicePort = null;
        }
        if (this.m_discoveryServicePort != null) {
            this.removeHandler((BindingProvider)this.m_discoveryServicePort);
            this.m_discoveryServicePort = null;
        }
        if (this.m_objectServicesPort != null) {
            this.removeHandler((BindingProvider)this.m_objectServicesPort);
            this.m_objectServicesPort = null;
        }
        if (this.m_repositoryServicePort != null) {
            this.removeHandler((BindingProvider)this.m_repositoryServicePort);
            this.m_repositoryServicePort = null;
        }
        this.m_securityHandler = null;
        this.m_contentHandler = null;
        this.m_userinfo = null;
    }

    public boolean isContainerBasedAuthenticated() throws OwException {
        return false;
    }

    protected void removeHandler(BindingProvider bp_p) {
        bp_p.getBinding().getHandlerChain().remove(this.getContentHandler());
        bp_p.getBinding().getHandlerChain().remove(this.getSecurityHandler());
    }

    protected SOAPHandler<SOAPMessageContext> getContentHandler() {
        return this.m_contentHandler;
    }

    protected SOAPHandler<SOAPMessageContext> createContentHandler() {
        return new OwCMISContentHandler();
    }

    public String getLoginName() {
        return this.getAuthInfo("USER");
    }

    public String getLoginPassword() {
        return this.getAuthInfo("Password");
    }
}

