/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis;

import com.wewebu.ow.csqlc.ast.OwExternal;
import com.wewebu.ow.csqlc.ast.OwQueryStatement;
import com.wewebu.ow.server.ao.OwAOSupport;
import com.wewebu.ow.server.ao.OwFileAOSupport;
import com.wewebu.ow.server.ao.OwVirtualFolderFactory;
import com.wewebu.ow.server.ao.OwVirtualFoldersManager;
import com.wewebu.ow.server.ecm.OwBatch;
import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwCredentials;
import com.wewebu.ow.server.ecm.OwCrossMappings;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwObjectSkeleton;
import com.wewebu.ow.server.ecm.OwPermissionCollection;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwRepository;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecm.OwStandardCrossMappings;
import com.wewebu.ow.server.ecm.OwStandardObjectCollection;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.ecm.OwVirtualFolderObjectFactory;
import com.wewebu.ow.server.ecm.ui.OwUIAccessRightsModul;
import com.wewebu.ow.server.ecm.ui.OwUILoginModul;
import com.wewebu.ow.server.ecm.ui.OwUIUserSelectModul;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISCrossDomainFolder;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISDMSID;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISDMSIDDecoder;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISExternalEntitiesResolver;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISLoginInfoNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetworkConfiguration;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISResource;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISSearchResult;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISVirtualFolderFactory;
import com.wewebu.ow.server.ecmimpl.cmis.cross.OwCMISCrossInvocationHandler;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObject;
import com.wewebu.ow.server.ecmimpl.cmis.ui.OwCMISLoginSubModul;
import com.wewebu.ow.server.event.OwEventManager;
import com.wewebu.ow.server.exceptions.OwAuthenticationException;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.role.OwRoleManager;
import com.wewebu.ow.server.util.OwNetworkConfiguration;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwString1;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class OwCMISCrossNetwork
implements OwNetwork,
OwCMISLoginInfoNetwork,
OwCMISExternalEntitiesResolver,
OwVirtualFolderFactory {
    private static final Logger LOG = OwLog.getLogger(OwCMISCrossNetwork.class);
    private OwCMISNetwork internalNetwork;
    private OwNetwork externalNetwork;
    private List<String> internalResourceIDs = new LinkedList<String>();
    private List<String> externalResourceIDs = new LinkedList<String>();
    private List<String> crossResourceIDs = new LinkedList<String>();
    private OwXMLUtil externalConfiguration;
    private OwCMISNetworkConfiguration crossConfigurtaion;
    private OwRoleManager roleManager;
    private OwStandardCrossMappings xMapping;
    private OwNetworkContext context;
    private OwObject domainFolder;
    private OwVirtualFoldersManager vfManager;

    public OwNetwork getNetwork(OwResource resource_p) throws Exception {
        if (resource_p == null) {
            return this.internalNetwork;
        }
        String rID = resource_p.getID();
        return this.getNetwork(rID);
    }

    private String removeResourcePrefix(OwNetwork network_p, String id_p) {
        if (id_p == null) {
            return null;
        }
        String prefix = network_p.getDMSPrefix() + "/";
        if (id_p.startsWith(prefix)) {
            id_p = id_p.substring(prefix.length());
        }
        return id_p;
    }

    public OwNetwork getNetwork(String resourceID_p) throws OwException {
        if (resourceID_p == null) {
            return this.internalNetwork;
        }
        if (this.internalResourceIDs.contains(resourceID_p)) {
            return this.internalNetwork;
        }
        if (this.externalNetwork != null && this.externalResourceIDs.contains(resourceID_p)) {
            return this.externalNetwork;
        }
        OwCMISResource resource = null;
        try {
            resource = this.internalNetwork.getResource(resourceID_p);
            if (resource != null) {
                return this.internalNetwork;
            }
        }
        catch (OwObjectNotFoundException internalException) {
            try {
                resourceID_p = this.removeResourcePrefix(this.externalNetwork, resourceID_p);
                resource = this.externalNetwork.getResource(resourceID_p);
                if (resource != null) {
                    return this.externalNetwork;
                }
            }
            catch (Exception externalException) {
                LOG.error((Object)("Unknown internal resource " + resourceID_p), (Throwable)internalException);
                LOG.error((Object)("Unknown external resource " + resourceID_p), (Throwable)externalException);
                throw new OwObjectNotFoundException("Unknown resource " + resourceID_p, (Throwable)internalException);
            }
        }
        LOG.error((Object)("OwCMISCrossNetwork.getNetwork(): Unknown resource " + resourceID_p));
        throw new OwObjectNotFoundException("Unknown resource " + resourceID_p);
    }

    public boolean canCreateNewObject(OwResource resource_p, OwObject parent_p, int context_p) throws Exception {
        return this.getNetwork(resource_p).canCreateNewObject(resource_p, parent_p, context_p);
    }

    public boolean canCreateObjectCopy(OwObject parent_p, int[] childTypes_p, int context_p) throws Exception {
        if (parent_p.getResource() == null) {
            return true;
        }
        String rID = parent_p.getResourceID();
        return this.getNetwork(rID).canCreateObjectCopy(parent_p, childTypes_p, context_p);
    }

    public boolean canDo(OwObject obj_p, int functionCode_p, int context_p) throws Exception {
        String rID = obj_p.getResourceID();
        return this.getNetwork(rID).canDo(obj_p, functionCode_p, context_p);
    }

    public boolean canEditAccessRights(OwObject object_p) throws Exception {
        String rID = object_p.getResourceID();
        return this.getNetwork(rID).canEditAccessRights(object_p);
    }

    public String createNewObject(final OwResource resource_p, final String strObjectClassName_p, final OwPropertyCollection properties_p, final OwPermissionCollection permissions_p, final OwContentCollection content_p, final OwObject parent_p, final String strMimeType_p, final String strMimeParameter_p) throws Exception {
        OwNetwork network = this.getNetwork(resource_p);
        OwResource defaultResource = this.getResource(null);
        if (resource_p.getID().equals(defaultResource.getID())) {
            return network.createNewObject(resource_p, strObjectClassName_p, properties_p, permissions_p, content_p, parent_p, strMimeType_p, strMimeParameter_p);
        }
        final OwNetwork fnetwork = OwCMISCrossInvocationHandler.createCrossNetworkObject(this, this.getXMapping(), network, resource_p.getID());
        return (String)OwCMISCrossInvocationHandler.call(new OwCMISCrossInvocationHandler.CrossCall(){

            @Override
            public Object call() throws Exception {
                return fnetwork.createNewObject(resource_p, strObjectClassName_p, properties_p, permissions_p, content_p, parent_p, strMimeType_p, strMimeParameter_p);
            }
        }, defaultResource.getID());
    }

    public String createNewObject(final boolean fPromote_p, final Object mode_p, final OwResource resource_p, final String strObjectClassName_p, final OwPropertyCollection properties_p, final OwPermissionCollection permissions_p, final OwContentCollection content_p, final OwObject parent_p, final String strMimeType_p, final String strMimeParameter_p) throws Exception {
        OwNetwork network = this.getNetwork(resource_p);
        OwResource defaultResource = this.getResource(null);
        if (resource_p.getID().equals(defaultResource.getID())) {
            return network.createNewObject(fPromote_p, mode_p, resource_p, strObjectClassName_p, properties_p, permissions_p, content_p, parent_p, strMimeType_p, strMimeParameter_p);
        }
        final OwNetwork fnetwork = OwCMISCrossInvocationHandler.createCrossNetworkObject(this, this.getXMapping(), network, resource_p.getID());
        return (String)OwCMISCrossInvocationHandler.call(new OwCMISCrossInvocationHandler.CrossCall(){

            @Override
            public Object call() throws Exception {
                return fnetwork.createNewObject(fPromote_p, mode_p, resource_p, strObjectClassName_p, properties_p, permissions_p, content_p, parent_p, strMimeType_p, strMimeParameter_p);
            }
        }, defaultResource.getID());
    }

    public String createNewObject(boolean promote_p, Object mode_p, OwResource resource_p, String strObjectClassName_p, OwPropertyCollection properties_p, OwPermissionCollection permissions_p, OwContentCollection content_p, OwObject parent_p, String strMimeType_p, String strMimeParameter_p, boolean keepCheckedOut_p) throws Exception {
        OwNetwork network = this.getNetwork(resource_p);
        return network.createNewObject(promote_p, mode_p, resource_p, strObjectClassName_p, properties_p, permissions_p, content_p, parent_p, strMimeType_p, strMimeParameter_p, keepCheckedOut_p);
    }

    public String createObjectCopy(OwObject obj_p, final OwPropertyCollection properties_p, final OwPermissionCollection permissions_p, final OwObject parent_p, final int[] childTypes_p) throws Exception {
        OwNetwork network = this.getNetwork(parent_p.getResourceID());
        if (!obj_p.getResourceID().equals(parent_p.getResourceID())) {
            final OwObject fobj = OwCMISCrossInvocationHandler.createCrossNetworkObject(this, this.getXMapping(), obj_p, obj_p.getResourceID());
            final OwNetwork fnetwork = OwCMISCrossInvocationHandler.createCrossNetworkObject(this, this.getXMapping(), network, parent_p.getResourceID());
            return (String)OwCMISCrossInvocationHandler.call(new OwCMISCrossInvocationHandler.CrossCall(){

                @Override
                public Object call() throws Exception {
                    return fnetwork.createObjectCopy(fobj, properties_p, permissions_p, parent_p, childTypes_p);
                }
            }, obj_p.getResourceID());
        }
        return network.createObjectCopy(obj_p, properties_p, permissions_p, parent_p, childTypes_p);
    }

    public OwObjectSkeleton createObjectSkeleton(OwObjectClass objectclass_p, OwResource resource_p) throws Exception {
        OwNetwork network = this.getNetwork(resource_p);
        return network.createObjectSkeleton(objectclass_p, resource_p);
    }

    public Object getApplicationObject(int typ_p, String strName_p, Object param_p, boolean forceUserSpecificObject_p, boolean createIfNotExist_p) throws Exception {
        if (typ_p == 1) {
            return this.getVFManager().getApplicationObject(strName_p, param_p, forceUserSpecificObject_p, createIfNotExist_p);
        }
        return this.internalNetwork.getApplicationObject(typ_p, strName_p, param_p, forceUserSpecificObject_p, createIfNotExist_p);
    }

    public Object getApplicationObject(int typ_p, String strName_p, boolean forceUserSpecificObject_p, boolean createIfNotExist_p) throws Exception {
        if (typ_p == 1) {
            return this.getVFManager().getApplicationObject(strName_p, forceUserSpecificObject_p, createIfNotExist_p);
        }
        return this.internalNetwork.getApplicationObject(typ_p, strName_p, forceUserSpecificObject_p, createIfNotExist_p);
    }

    public Collection getApplicationObjects(int typ_p, String strName_p, boolean forceUserSpecificObject_p) throws Exception {
        return this.internalNetwork.getApplicationObjects(typ_p, strName_p, forceUserSpecificObject_p);
    }

    public OwUIAccessRightsModul getEditAccessRightsSubModul(OwObject object_p) throws Exception {
        String rID = object_p.getResourceID();
        return this.getNetwork(rID).getEditAccessRightsSubModul(object_p);
    }

    public Object getInterface(String strInterfaceName_p, Object object_p) throws Exception {
        return this.internalNetwork.getInterface(strInterfaceName_p, object_p);
    }

    public OwCMISNetwork getInternalNetwork() {
        return this.internalNetwork;
    }

    public OwNetwork getExternalNetwork() {
        return this.externalNetwork;
    }

    public Locale getLocale() {
        return this.internalNetwork.getLocale();
    }

    public boolean hasInterface(String strInterfaceName_p) {
        return this.internalNetwork.hasInterface(strInterfaceName_p);
    }

    public void init(OwNetworkContext context_p, OwXMLUtil networkSettings_p) throws Exception {
        this.crossConfigurtaion = new OwCMISNetworkConfiguration(networkSettings_p);
        this.context = context_p;
        this.internalNetwork = new OwCMISNetwork(this, new OwCMISVirtualFolderFactory(this, this.crossConfigurtaion.getDMSIDDecoder()));
        this.internalNetwork.init(context_p, networkSettings_p);
        OwXMLUtil externalConfiguration = networkSettings_p.getSubUtil("ExternalCrossAdapter");
        if (externalConfiguration != null) {
            this.externalInit(context_p, externalConfiguration);
        }
    }

    protected void externalInit(OwNetworkContext context_p, OwXMLUtil networkSettings_p) throws OwException {
        this.externalConfiguration = networkSettings_p;
        OwXMLUtil adapterConfiguration = null;
        try {
            adapterConfiguration = networkSettings_p.getSubUtil("XEcmAdapter");
            if (adapterConfiguration == null) {
                LOG.error((Object)"OwCMISCrossNetwork.externalInit(): The external ECM Adapter configuration could not be read .");
                throw new OwConfigurationException(new OwString("ecmimpl.cmis.OwCMISNetwork.invalid.configuration.error", "Invalid CMIS configuration!"));
            }
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)"OwCMISCrossNetwork.externalInit(): The external ECM Adapter could not be loaded.", (Throwable)e);
            throw new OwConfigurationException(new OwString("ecmimpl.cmis.OwCMISNetwork.invalid.configuration.error", "Invalid CMIS configuration!"), (Throwable)e);
        }
        String strNetworkClassName = "";
        try {
            strNetworkClassName = adapterConfiguration.getSafeTextValue("ClassName", null);
            Class<?> NetworkClass = Class.forName(strNetworkClassName);
            this.externalNetwork = (OwNetwork)NetworkClass.newInstance();
            this.externalNetwork.init(context_p, adapterConfiguration);
            this.externalNetwork.setEventManager(this.getEventManager());
            this.externalNetwork.setRoleManager(this.roleManager);
        }
        catch (Exception e) {
            LOG.error((Object)("OwCMISCrossNetwork.externalInit(): The external ECM Adapter could not be loaded: " + strNetworkClassName), (Throwable)e);
            throw new OwConfigurationException(new OwString("ecmimpl.cmis.OwCMISNetwork.invalid.configuration.error", "Invalid CMIS configuration!"), (Throwable)e);
        }
    }

    public void setEventManager(OwEventManager eventManager_p) {
        this.internalNetwork.setEventManager(eventManager_p);
        if (this.externalNetwork != null) {
            this.externalNetwork.setEventManager(eventManager_p);
        }
    }

    public void setRoleManager(OwRoleManager roleManager_p) {
        this.roleManager = roleManager_p;
        this.internalNetwork.setRoleManager(roleManager_p);
        if (this.externalNetwork != null) {
            this.externalNetwork.setRoleManager(roleManager_p);
        }
    }

    public boolean canBatch() {
        return this.internalNetwork.canBatch();
    }

    public boolean canRefreshStaticClassdescriptions() throws Exception {
        return this.internalNetwork.canRefreshStaticClassdescriptions();
    }

    public void closeBatch(OwBatch batch_p) throws OwException {
        this.internalNetwork.closeBatch(batch_p);
    }

    public OwObjectCollection doSearch(OwSearchNode searchCriteria_p, OwSort sortCriteria_p, Collection propertyNames_p, int maxSize_p, int versionSelection_p) throws Exception {
        OwCMISSearchResult result = this.internalNetwork.doCMISSearch(searchCriteria_p, sortCriteria_p, propertyNames_p, maxSize_p, versionSelection_p);
        OwExternal<List<OwQueryStatement>> exStatements = result.getExternalStatements();
        if (exStatements.hasExternalObjectStores()) {
            OwStandardObjectCollection crossCollection = new OwStandardObjectCollection();
            List externalObjectStores = exStatements.getExternalObjectStores();
            for (String[] xStore : externalObjectStores) {
                OwObjectCollection externalResults = this.doExternalRepositorySearch(xStore[0], searchCriteria_p, sortCriteria_p, propertyNames_p, maxSize_p, versionSelection_p);
                crossCollection.addAll((Collection)result.getCmisSearchResult());
                crossCollection.addAll((Collection)externalResults);
            }
            return crossCollection;
        }
        return result.getCmisSearchResult();
    }

    protected OwObjectCollection doExternalRepositorySearch(String xStore_p, OwSearchNode searchNode_p, OwSort sort_p, Collection propertyNames_p, int maxSize_p, int versionSelection_p) throws Exception {
        OwCrossMappings xMapping = this.getXMapping();
        OwSearchNode xSearchNode = xMapping.getXSearch(searchNode_p, xStore_p, this.externalNetwork);
        OwSort xSort = xMapping.getXSort(sort_p);
        Collection xProperties = xMapping.getXProperties(propertyNames_p);
        OwObjectCollection result = this.externalNetwork.doSearch(xSearchNode, xSort, xProperties, maxSize_p, versionSelection_p);
        for (int i = 0; i < result.size(); ++i) {
            OwObject obj = (OwObject)result.get(i);
            OwObject crossObject = OwCMISCrossInvocationHandler.createCrossNetworkObject(this, xMapping, obj, obj.getResourceID());
            result.set(i, (Object)crossObject);
        }
        return result;
    }

    public synchronized OwCrossMappings getXMapping() throws OwException {
        if (null == this.xMapping) {
            OwXMLUtil xconfig = null;
            try {
                xconfig = this.externalConfiguration.getSubUtil("XMapping");
            }
            catch (OwException e) {
                throw e;
            }
            catch (Exception e) {
                throw new OwConfigurationException(this.getContext().localize("ecmimpl.cmis.OwCMISCrossNetwork.xmappingloaderror", "The external ECM adapter could not be loaded, please define XMapping."), (Throwable)e);
            }
            if (xconfig == null) {
                LOG.error((Object)"OwCMISCrossNetwork.getXMapping: The external ECM Adapter could not be loaded (is null), please define XMapping.");
                throw new OwConfigurationException(this.getContext().localize("ecmimpl.cmis.OwCMISCrossNetwork.xmappingloaderror", "The external ECM adapter could not be loaded, please define XMapping."));
            }
            this.xMapping = new OwStandardCrossMappings(xconfig);
        }
        return this.xMapping;
    }

    public String getDMSPrefix() {
        return this.internalNetwork.getDMSPrefix();
    }

    public OwEventManager getEventManager() {
        return this.internalNetwork.getEventManager();
    }

    public OwObjectClass getObjectClass(String strClassName_p, OwResource resource_p) throws Exception {
        OwNetwork network = this.getNetwork(resource_p);
        OwObjectClass clazz = network.getObjectClass(strClassName_p, resource_p);
        return OwCMISCrossInvocationHandler.createCrossNetworkObject(this, this.getXMapping(), clazz, resource_p.getID());
    }

    public Map getObjectClassNames(int[] types_p, boolean excludeHiddenAndNonInstantiable_p, boolean rootOnly_p, OwResource resource_p) throws Exception {
        return this.getNetwork(resource_p).getObjectClassNames(types_p, excludeHiddenAndNonInstantiable_p, rootOnly_p, resource_p);
    }

    public OwObject getObjectFromDMSID(String strDMSID_p, boolean refresh_p) throws Exception {
        OwCMISDMSIDDecoder decoder = this.internalNetwork.getDMSIDDecoder();
        OwException cmisDecodeException = null;
        OwCMISDMSID dmsid = null;
        try {
            dmsid = decoder.createDMSID(strDMSID_p);
            String rID = dmsid.getResourceID();
            if (this.internalResourceIDs.contains(rID)) {
                OwCMISObject iObject = this.internalNetwork.getObjectFromDMSID(strDMSID_p, refresh_p);
                return OwCMISCrossInvocationHandler.createCrossNetworkObject(this, this.getXMapping(), iObject, rID);
            }
        }
        catch (OwException e) {
            if (dmsid != null) {
                throw e;
            }
            cmisDecodeException = e;
        }
        if (this.externalNetwork != null) {
            OwObject exObject = this.externalNetwork.getObjectFromDMSID(strDMSID_p, refresh_p);
            return OwCMISCrossInvocationHandler.createCrossNetworkObject(this, this.getXMapping(), exObject, exObject.getResourceID());
        }
        if (cmisDecodeException != null) {
            throw cmisDecodeException;
        }
        LOG.error((Object)("OwCMISCrossNetwork.getObjectFromDMSID() : Invalid DMSID " + strDMSID_p));
        throw new OwInvalidOperationException((OwString)new OwString1("ecmimpl.cmis.OwCMISStandardDMSIDDecoder.invalid.dmsid.error", "Invalid DMSID %1 !", strDMSID_p));
    }

    public OwObject getObjectFromPath(String strPath_p, boolean refresh_p) throws Exception {
        if (strPath_p.equals("/")) {
            return this.domainFolder;
        }
        OwObject iObject = this.internalNetwork.getObjectFromPath(strPath_p, refresh_p);
        return OwCMISCrossInvocationHandler.createCrossNetworkObject(this, this.getXMapping(), iObject, iObject.getResourceID());
    }

    public OwResource getResource(String strID_p) throws Exception {
        OwNetwork network = this.getNetwork(strID_p);
        return network.getResource(this.removeResourcePrefix(network, strID_p));
    }

    public Iterator getResourceIDs() throws Exception {
        return this.crossResourceIDs.iterator();
    }

    public OwBatch openBatch() throws OwException {
        return this.internalNetwork.openBatch();
    }

    public void refreshStaticClassdescriptions() throws Exception {
        this.internalNetwork.refreshStaticClassdescriptions();
    }

    public void releaseResources() throws Exception {
        this.internalNetwork.releaseResources();
    }

    private String toExternalField(String strFieldDefinitionName_p) throws OwException {
        OwCrossMappings mapping = this.getXMapping();
        return mapping.getXProperty(strFieldDefinitionName_p);
    }

    public OwFieldDefinition getFieldDefinition(String strFieldDefinitionName_p, String strResourceName_p) throws Exception, OwObjectNotFoundException {
        OwNetwork network = this.getNetwork(strResourceName_p);
        OwFieldDefinition definition = network.getFieldDefinition(strFieldDefinitionName_p, this.removeResourcePrefix(network, strResourceName_p));
        return definition;
    }

    public Collection getWildCardDefinitions(String strFieldDefinitionName_p, String strResourceName_p, int op_p) throws Exception {
        OwNetwork network = this.getNetwork(strResourceName_p);
        if (network == this.externalNetwork) {
            strFieldDefinitionName_p = this.toExternalField(strFieldDefinitionName_p);
        }
        return network.getWildCardDefinitions(strFieldDefinitionName_p, this.removeResourcePrefix(network, strResourceName_p), op_p);
    }

    public boolean canUserSelect() throws Exception {
        return this.internalNetwork.canUserSelect();
    }

    public OwCredentials getCredentials() throws Exception {
        return this.internalNetwork.getCredentials();
    }

    public OwUILoginModul getLoginSubModul() throws Exception {
        OwCMISLoginSubModul loginSubModul = new OwCMISLoginSubModul();
        loginSubModul.init(this);
        return loginSubModul;
    }

    public String getRoleDisplayName(String strRoleName_p) throws Exception {
        return this.internalNetwork.getRoleDisplayName(strRoleName_p);
    }

    public OwUserInfo getUserFromID(String strID_p) throws Exception {
        return this.internalNetwork.getUserFromID(strID_p);
    }

    public OwUIUserSelectModul getUserSelectSubModul(String strID_p, int[] types_p) throws Exception {
        return this.internalNetwork.getUserSelectSubModul(strID_p, types_p);
    }

    public void loginDefault(String user_p, String password_p) throws Exception {
        this.internalNetwork.loginDefault(user_p, password_p);
        if (this.externalNetwork != null) {
            try {
                this.getXMapping().doXLogin(this.externalNetwork, (OwNetwork)this, user_p, password_p);
            }
            catch (Exception e) {
                String msg = "Your X Login information is invalid or the X Server is not available. Please make sure that name and password are correct and the X Server is running.";
                LOG.debug((Object)msg, (Throwable)e);
                throw new OwAuthenticationException(msg, (Throwable)e);
            }
            Iterator xResources = this.externalNetwork.getResourceIDs();
            while (xResources.hasNext()) {
                String xResourceID = (String)xResources.next();
                this.externalResourceIDs.add(xResourceID);
                OwResource xResource = this.externalNetwork.getResource(xResourceID);
            }
        }
        Iterator<String> iResources = this.internalNetwork.getResourceIDs();
        while (iResources.hasNext()) {
            String iResource = iResources.next();
            this.internalResourceIDs.add(iResource);
        }
        this.crossResourceIDs.addAll(this.internalResourceIDs);
        this.crossResourceIDs.addAll(this.externalResourceIDs);
        this.domainFolder = this.createDomainFolder();
    }

    protected OwObject createDomainFolder() throws OwException {
        if (this.externalNetwork != null) {
            this.domainFolder = new OwCMISCrossDomainFolder(this);
            return this.domainFolder;
        }
        return this.internalNetwork.getObjectFromPath("/", true);
    }

    public void logout() throws Exception {
        this.internalNetwork.logout();
        if (this.externalNetwork != null) {
            this.externalNetwork.logout();
        }
    }

    @Override
    public String resolveRepositoryID(String repositoryName_p) throws OwException {
        OwNetwork network = this.getNetwork(repositoryName_p);
        try {
            OwResource resource = network.getResource(this.removeResourcePrefix(network, repositoryName_p));
            return resource.getID();
        }
        catch (Exception e) {
            LOG.error((Object)"OwCMISCrossNetwork.resolveRepositoryID():");
            throw new OwObjectNotFoundException(this.getContext().localize1("ecmimpl.cmis.OwCMISSQLStandardEntitiesResolver.resolveRepositoryID.cmis.error", "Could not find resource %1 !", repositoryName_p), (Throwable)e);
        }
    }

    public OwNetworkContext getContext() {
        return this.context;
    }

    public OwObject createVirtualFolder(Node xmlVirtualFolderDescriptionNode_p, String strName_p, String strDmsIDPart_p) throws OwException {
        try {
            OwStandardXMLUtil description = new OwStandardXMLUtil(xmlVirtualFolderDescriptionNode_p);
            String strVirtualFolderClassName = description.getSafeTextValue("ClassName", "com.wewebu.ow.server.ecmimpl.cmis.OwCMISVirtualFolderObjectFactory");
            Class<?> virtualFolderClass = Class.forName(strVirtualFolderClassName);
            OwVirtualFolderObjectFactory retObject = (OwVirtualFolderObjectFactory)virtualFolderClass.newInstance();
            Node rootNode = description.getSubNode("root");
            String virtualFolderPrefix = "vf";
            retObject.init(this.getContext(), (OwRepository)this, this.getInternalNetwork().getDMSPrefix() + "," + "vf" + "," + strName_p, strName_p, rootNode);
            return retObject.getInstance(strDmsIDPart_p);
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)("OwCMISCrossNetwork.createVirtualFolder():Could not create virtual folder named " + strName_p + " and dmisd part " + strDmsIDPart_p));
            throw new OwInvalidOperationException(this.getContext().localize("ecmimpl.cmis.OwCMISCrossNetwork.create.virtual.folder.error", "Could not create virtual folder!"), (Throwable)e);
        }
    }

    protected OwVirtualFoldersManager getVFManager() throws OwException {
        if (this.vfManager == null) {
            OwCMISNetwork internalNetowrk = this.getInternalNetwork();
            OwCMISNetworkConfiguration configuration = internalNetowrk.getNetworkConfiguration();
            OwFileAOSupport fileAOSupport = new OwFileAOSupport((OwNetwork)this, (OwNetworkConfiguration)configuration, "WEB-INF/cmis");
            this.vfManager = new OwVirtualFoldersManager((OwAOSupport)fileAOSupport, (OwVirtualFolderFactory)this, this.roleManager, configuration.getVirtualFoldersContainer(null));
        }
        return this.vfManager;
    }

    @Override
    public void initLoginMap(HashMap<String, String> loginMap_p) throws OwException {
    }
}

