/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis;

import com.wewebu.ow.server.exceptions.OwAccessDeniedException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.util.OwString;
import java.util.Locale;
import org.oasis_open.docs.ns.cmis.messaging._200908.CmisFaultType;
import org.oasis_open.docs.ns.cmis.ws._200908.CmisException;

public class OwCMISExceptionCatcher {
    private CmisException cmisException;
    private Locale locale;
    private String cmisFaultTypeLogMessage;
    private String cmisFaultTypeLocalMessage;

    public OwCMISExceptionCatcher(CmisException cmisException_p) {
        this(cmisException_p, null);
    }

    public OwCMISExceptionCatcher(CmisException cmisException_p, Locale locale_p) {
        this.cmisException = cmisException_p;
        this.locale = locale_p;
        this.createCMISFaultTypeMessage();
    }

    private void createCMISFaultTypeMessage() {
        CmisFaultType fault = this.cmisException.getFaultInfo();
        switch (fault.getType()) {
            case CONSTRAINT: {
                this.cmisFaultTypeLogMessage = "CMIS constraint fault!";
                this.cmisFaultTypeLocalMessage = this.localize("ecmimpl.cmis.OwCMISException.fault.message.constraint", this.cmisFaultTypeLogMessage);
                break;
            }
            case NAME_CONSTRAINT_VIOLATION: {
                this.cmisFaultTypeLogMessage = "CMIS name contstraint fault!";
                this.cmisFaultTypeLocalMessage = this.localize("ecmimpl.cmis.OwCMISException.fault.message.name.constraint.violation", this.cmisFaultTypeLogMessage);
                break;
            }
            case CONTENT_ALREADY_EXISTS: {
                this.cmisFaultTypeLogMessage = "Content already exists!";
                this.cmisFaultTypeLocalMessage = this.localize("ecmimpl.cmis.OwCMISException.fault.message.content.alreay.exists", this.cmisFaultTypeLogMessage);
                break;
            }
            case FILTER_NOT_VALID: {
                this.cmisFaultTypeLogMessage = "Invalid filter!";
                this.cmisFaultTypeLocalMessage = this.localize("ecmimpl.cmis.OwCMISException.fault.message.filter.not.valid", this.cmisFaultTypeLogMessage);
                break;
            }
            case INVALID_ARGUMENT: {
                this.cmisFaultTypeLogMessage = "Invalid argument!";
                this.cmisFaultTypeLocalMessage = this.localize("ecmimpl.cmis.OwCMISException.fault.message.invalid.argument", this.cmisFaultTypeLogMessage);
                break;
            }
            case NOT_SUPPORTED: {
                this.cmisFaultTypeLogMessage = "Not supported!";
                this.cmisFaultTypeLocalMessage = this.localize("ecmimpl.cmis.OwCMISException.fault.message.not.supported", this.cmisFaultTypeLogMessage);
                break;
            }
            case OBJECT_NOT_FOUND: {
                this.cmisFaultTypeLogMessage = "Object not found!";
                this.cmisFaultTypeLocalMessage = this.localize("ecmimpl.cmis.OwCMISException.fault.message.object.not.found", this.cmisFaultTypeLogMessage);
                break;
            }
            case PERMISSION_DENIED: {
                this.cmisFaultTypeLogMessage = "Permission denied!";
                this.cmisFaultTypeLocalMessage = this.localize("ecmimpl.cmis.OwCMISException.fault.message.permission.denied", this.cmisFaultTypeLogMessage);
                break;
            }
            case RUNTIME: {
                this.cmisFaultTypeLogMessage = "Runtime error!";
                this.cmisFaultTypeLocalMessage = this.localize("ecmimpl.cmis.OwCMISException.fault.message.runtime", this.cmisFaultTypeLogMessage);
                break;
            }
            case STORAGE: {
                this.cmisFaultTypeLogMessage = "CMIS storage problems!";
                this.cmisFaultTypeLocalMessage = this.localize("ecmimpl.cmis.OwCMISException.fault.message.storage", this.cmisFaultTypeLogMessage);
                break;
            }
            case STREAM_NOT_SUPPORTED: {
                this.cmisFaultTypeLogMessage = "ContentStream is not supported in this context (type/class)!";
                this.cmisFaultTypeLocalMessage = this.localize("ecmimpl.cmis.OwCMISException.fault.message.not.supported", this.cmisFaultTypeLogMessage);
                break;
            }
            case UPDATE_CONFLICT: {
                this.cmisFaultTypeLogMessage = "Update conflict!";
                this.cmisFaultTypeLocalMessage = this.localize("ecmimpl.cmis.OwCMISException.fault.message.update.conflict", this.cmisFaultTypeLogMessage);
                break;
            }
            case VERSIONING: {
                this.cmisFaultTypeLogMessage = "Versioning error!";
                this.cmisFaultTypeLocalMessage = this.localize("ecmimpl.cmis.OwCMISException.fault.message.versioning", this.cmisFaultTypeLogMessage);
                break;
            }
            default: {
                this.cmisFaultTypeLogMessage = "Unspecified CMIS fault info type!";
                this.cmisFaultTypeLocalMessage = this.localize("ecmimpl.cmis.OwCMISException.fault.message.unspecified", "Unspecified CMIS fault info type!");
            }
        }
    }

    private String localize(String key_p, String defaultText_p) {
        if (this.locale != null) {
            return OwString.localize((Locale)this.locale, (String)key_p, (String)defaultText_p);
        }
        return defaultText_p;
    }

    public String getLogMessage() {
        CmisFaultType fault = this.cmisException.getFaultInfo();
        return this.cmisFaultTypeLogMessage + " CMIS fault message is : " + fault.getMessage();
    }

    public String getLocalizedFaultTypeMessage() {
        return this.cmisFaultTypeLocalMessage;
    }

    public OwException toOwException() {
        return this.toOwException(this.getLocalizedFaultTypeMessage());
    }

    public OwException toOwException(String message_p) {
        return this.toOwException(message_p, false);
    }

    public OwException toOwException(String message_p, boolean addCMISFaultTypeMessage_p) {
        CmisFaultType fault = this.cmisException.getFaultInfo();
        String message = message_p;
        if (addCMISFaultTypeMessage_p) {
            String faultLink = this.localize("ecmimpl.cmis.OwCMISException.cmis.fault.link", "CMIS fault is :");
            message = message + " " + faultLink + " " + this.getLocalizedFaultTypeMessage();
            if (fault != null && fault.getMessage() != null && !fault.getMessage().equals("")) {
                message = message + " [" + fault.getMessage() + "]";
            }
        }
        if (fault != null) {
            switch (fault.getType()) {
                case CONSTRAINT: {
                    return new OwInvalidOperationException(message, (Throwable)this.cmisException);
                }
                case NAME_CONSTRAINT_VIOLATION: {
                    return new OwInvalidOperationException(message, (Throwable)this.cmisException);
                }
                case CONTENT_ALREADY_EXISTS: {
                    return new OwInvalidOperationException(message, (Throwable)this.cmisException);
                }
                case FILTER_NOT_VALID: {
                    return new OwInvalidOperationException(message, (Throwable)this.cmisException);
                }
                case INVALID_ARGUMENT: {
                    return new OwInvalidOperationException(message, (Throwable)this.cmisException);
                }
                case NOT_SUPPORTED: {
                    return new OwNotSupportedException(message, (Throwable)this.cmisException);
                }
                case OBJECT_NOT_FOUND: {
                    return new OwObjectNotFoundException(message, (Throwable)this.cmisException);
                }
                case PERMISSION_DENIED: {
                    return new OwAccessDeniedException(message, (Throwable)this.cmisException);
                }
                case RUNTIME: {
                    return new OwServerException(message, (Throwable)this.cmisException);
                }
                case STORAGE: {
                    return new OwServerException(message, (Throwable)this.cmisException);
                }
                case STREAM_NOT_SUPPORTED: {
                    return new OwNotSupportedException(message, (Throwable)this.cmisException);
                }
                case UPDATE_CONFLICT: {
                    return new OwInvalidOperationException(message, (Throwable)this.cmisException);
                }
                case VERSIONING: {
                    return new OwInvalidOperationException(message, (Throwable)this.cmisException);
                }
            }
            return new OwServerException(message, (Throwable)this.cmisException);
        }
        return new OwServerException(message, (Throwable)this.cmisException);
    }

    public OwException toOwException(OwString message_p) {
        CmisFaultType fault = this.cmisException.getFaultInfo();
        switch (fault.getType()) {
            case CONSTRAINT: {
                return new OwInvalidOperationException(message_p, (Throwable)this.cmisException);
            }
            case NAME_CONSTRAINT_VIOLATION: {
                return new OwInvalidOperationException(message_p, (Throwable)this.cmisException);
            }
            case CONTENT_ALREADY_EXISTS: {
                return new OwInvalidOperationException(message_p, (Throwable)this.cmisException);
            }
            case FILTER_NOT_VALID: {
                return new OwInvalidOperationException(message_p, (Throwable)this.cmisException);
            }
            case INVALID_ARGUMENT: {
                return new OwInvalidOperationException(message_p, (Throwable)this.cmisException);
            }
            case NOT_SUPPORTED: {
                return new OwNotSupportedException(message_p, (Throwable)this.cmisException);
            }
            case OBJECT_NOT_FOUND: {
                return new OwObjectNotFoundException(message_p, (Throwable)this.cmisException);
            }
            case PERMISSION_DENIED: {
                return new OwAccessDeniedException(message_p, (Throwable)this.cmisException);
            }
            case RUNTIME: {
                return new OwServerException(message_p, (Throwable)this.cmisException);
            }
            case STORAGE: {
                return new OwServerException(message_p, (Throwable)this.cmisException);
            }
            case STREAM_NOT_SUPPORTED: {
                return new OwNotSupportedException(message_p, (Throwable)this.cmisException);
            }
            case UPDATE_CONFLICT: {
                return new OwInvalidOperationException(message_p, (Throwable)this.cmisException);
            }
            case VERSIONING: {
                return new OwInvalidOperationException(message_p, (Throwable)this.cmisException);
            }
        }
        return new OwServerException(message_p, (Throwable)this.cmisException);
    }
}

