/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis;

import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISLDAPGroupInfo;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISSimpleUserInfo;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.mandator.OwMandator;
import com.wewebu.ow.server.util.ldap.OwLdapConnector;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class OwCMISLDAPUserInfo
extends OwCMISSimpleUserInfo {
    private OwLdapConnector ldapConnector;
    private Collection<OwUserInfo> groups;
    private Collection<String> roles;
    private boolean adminGroupInterogation;

    public OwCMISLDAPUserInfo(String userName_p, OwLdapConnector ldapConnector_p) {
        this(userName_p, null, ldapConnector_p);
    }

    public OwCMISLDAPUserInfo(String userName_p, OwMandator mandator_p, OwLdapConnector ldapConnector_p) {
        this(userName_p, mandator_p, ldapConnector_p, false);
    }

    public OwCMISLDAPUserInfo(String userName_p, OwMandator mandator_p, OwLdapConnector ldapConnector_p, boolean adminGroupInterogation_p) {
        super(userName_p, mandator_p);
        this.ldapConnector = ldapConnector_p;
        this.adminGroupInterogation = adminGroupInterogation_p;
    }

    @Override
    public synchronized Collection<OwUserInfo> getGroups() throws OwException {
        if (this.groups == null) {
            Collection<OwUserInfo> superGroups = super.getGroups();
            this.groups = new HashSet<OwUserInfo>(superGroups);
            if (this.ldapConnector != null) {
                Collection ldapShortGroupNames = this.ldapConnector.getShortGroupNames(this.adminGroupInterogation);
                for (Object object : ldapShortGroupNames) {
                    String groupName = object.toString();
                    OwCMISLDAPGroupInfo groupInfo = this.createGroupInfo(groupName);
                    this.groups.add(groupInfo);
                }
            }
            this.groups.addAll(this.getDefaulfGroups());
        }
        return this.groups;
    }

    @Override
    public synchronized Collection<String> getRoleNames() throws OwException {
        if (this.roles == null) {
            this.roles = new HashSet<String>();
            List<String> superRoles = this.getDefaultRoleNames();
            Collection ldapShortGroupNames = this.ldapConnector.getShortGroupNames(this.adminGroupInterogation);
            if (this.getMandator() == null) {
                this.roles.addAll(superRoles);
                this.roles.addAll(ldapShortGroupNames);
            } else {
                for (String superRole : superRoles) {
                    this.roles.add(this.getMandator().filterRoleName(superRole));
                }
                for (Object ldapRole : ldapShortGroupNames) {
                    this.roles.add(this.getMandator().filterRoleName(ldapRole.toString()));
                }
            }
            this.roles.addAll(this.getDefaultRoleNames());
        }
        return this.roles;
    }

    protected OwCMISLDAPGroupInfo createGroupInfo(String groupName_p) {
        return new OwCMISLDAPGroupInfo(groupName_p);
    }

    @Override
    public String getUserLongName() throws OwException {
        return this.ldapConnector.getUserLongName();
    }

    @Override
    public String getUserShortName() throws Exception {
        return this.ldapConnector.getUserShortName();
    }

    @Override
    public String getUserDisplayName() throws Exception {
        return this.ldapConnector.getUserDisplayName();
    }

    @Override
    public String getUserID() {
        try {
            String userId = this.ldapConnector.getUserId();
            if (userId != null) {
                return this.ldapConnector.getUserId();
            }
            return super.getUserID();
        }
        catch (OwException e) {
            throw new RuntimeException("Could not get userId from LDAP.", e);
        }
    }
}

