/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis;

import com.wewebu.ow.csqlc.OwCSQLCProcessor;
import com.wewebu.ow.csqlc.OwSQLEntitiesResolver;
import com.wewebu.ow.csqlc.ast.OwExternal;
import com.wewebu.ow.csqlc.ast.OwQueryStatement;
import com.wewebu.ow.server.ao.OwAOManager;
import com.wewebu.ow.server.ao.OwAOManagerRegistry;
import com.wewebu.ow.server.ao.OwAOSupport;
import com.wewebu.ow.server.ao.OwAttributeBagsManager;
import com.wewebu.ow.server.ao.OwDBAttributeBagsSupport;
import com.wewebu.ow.server.ao.OwDefaultAOManager;
import com.wewebu.ow.server.ao.OwDefaultRegistry;
import com.wewebu.ow.server.ao.OwFileAOSupport;
import com.wewebu.ow.server.ao.OwSearchTemplateFactory;
import com.wewebu.ow.server.ao.OwSearchTemplatesManager;
import com.wewebu.ow.server.ao.OwVirtualFolderFactory;
import com.wewebu.ow.server.ao.OwVirtualFoldersManager;
import com.wewebu.ow.server.ao.OwXMLAOManager;
import com.wewebu.ow.server.auth.OwAuthentication;
import com.wewebu.ow.server.auth.OwAuthenticationContext;
import com.wewebu.ow.server.auth.OwCredentialsAuthentication;
import com.wewebu.ow.server.auth.OwLocalAuthenticationContext;
import com.wewebu.ow.server.conf.OwBaseUserInfo;
import com.wewebu.ow.server.ecm.OwAttributeBagsSupport;
import com.wewebu.ow.server.ecm.OwBatch;
import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwManagedSemiVirtualRecordConfiguration;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwObjectSkeleton;
import com.wewebu.ow.server.ecm.OwPermissionCollection;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwRepositoryContext;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecm.OwSearchPath;
import com.wewebu.ow.server.ecm.OwSemiVirtualRecordClass;
import com.wewebu.ow.server.ecm.OwStandardObjectCollection;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.ecm.OwStandardSearchSpecialNodeOperator;
import com.wewebu.ow.server.ecm.OwStandardSearchTemplate;
import com.wewebu.ow.server.ecm.OwTransientBagsSupport;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.ecm.bpm.OwWorkitemRepository;
import com.wewebu.ow.server.ecm.eaop.OwBooleanCollector;
import com.wewebu.ow.server.ecm.eaop.OwJoinPoint;
import com.wewebu.ow.server.ecm.eaop.OwJoinPointResultCollector;
import com.wewebu.ow.server.ecm.eaop.OwNativeSearchAdvice;
import com.wewebu.ow.server.ecm.ui.OwUIAccessRightsModul;
import com.wewebu.ow.server.ecm.ui.OwUILoginModul;
import com.wewebu.ow.server.ecm.ui.OwUIUserSelectModul;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISConnection;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISCredentials;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISDMSID;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISDMSIDDecoder;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISDomainFolder;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISExceptionCatcher;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISExternalEntitiesResolver;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISLDAPCredentials;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISLoginInfoNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetworkConfiguration;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISObjectModel;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISQueryResult;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISResource;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISSQLStandardEntitiesResolver;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISSearchResult;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISSemiVirtualFolderObject;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISVirtualFolderFactory;
import com.wewebu.ow.server.ecmimpl.cmis.auth.OwCMISCredentialsAuthenticator;
import com.wewebu.ow.server.ecmimpl.cmis.broker.OwCMISObjectBroker;
import com.wewebu.ow.server.ecmimpl.cmis.extension.OwCMISNetworkExtension;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISDocumentObject;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISObjectSkeleton;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObject;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClassFactory;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISStandardObjectClassFactory;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISPropertyNames;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISStandardPropertyClassFactory;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClass;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClassFactory;
import com.wewebu.ow.server.ecmimpl.cmis.search.OwCMISCSQLCProcessor;
import com.wewebu.ow.server.ecmimpl.cmis.search.OwCMISLikeWildcardDefinitions;
import com.wewebu.ow.server.ecmimpl.cmis.ui.OwCMISAccessRightsModule;
import com.wewebu.ow.server.ecmimpl.cmis.ui.OwCMISLoginSubModul;
import com.wewebu.ow.server.ecmimpl.cmis.ui.OwCMISUIUserSelectionModul;
import com.wewebu.ow.server.ecmimpl.cmis.util.OwCMISPropertiesFilter;
import com.wewebu.ow.server.ecmimpl.cmis.viewer.info.OwCMISInfoProvider;
import com.wewebu.ow.server.ecmimpl.cmis.wshandler.OwCMISSecurityHandlerInterface;
import com.wewebu.ow.server.event.OwEventManager;
import com.wewebu.ow.server.exceptions.OwAuthenticationException;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwSearchCriteria;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSearchTemplate;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.field.OwWildCardDefinition;
import com.wewebu.ow.server.mandator.OwMandator;
import com.wewebu.ow.server.role.OwRoleManager;
import com.wewebu.ow.server.ui.viewer.OwInfoProvider;
import com.wewebu.ow.server.util.OwNetworkConfiguration;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import com.wewebu.ow.server.util.ldap.OwLdapConnector;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisObjectType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisRepositoryCapabilitiesType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisRepositoryInfoType;
import org.oasis_open.docs.ns.cmis.core._200908.EnumCapabilityACL;
import org.oasis_open.docs.ns.cmis.core._200908.EnumIncludeRelationships;
import org.oasis_open.docs.ns.cmis.messaging._200908.CmisObjectListType;
import org.oasis_open.docs.ns.cmis.messaging._200908.CmisRepositoryEntryType;
import org.oasis_open.docs.ns.cmis.ws._200908.ACLServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.CmisException;
import org.oasis_open.docs.ns.cmis.ws._200908.DiscoveryServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.MultiFilingServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.NavigationServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.ObjectServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.PolicyServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.RelationshipServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.RepositoryServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.VersioningServicePort;
import org.perf4j.log4j.Log4JStopWatch;
import org.w3c.dom.Node;

public class OwCMISNetwork
implements OwNetwork,
OwCMISConnection,
OwSearchTemplateFactory,
OwVirtualFolderFactory,
OwCMISLoginInfoNetwork {
    private static final Logger LOG = OwLog.getLogger(OwCMISNetwork.class);
    public static final String CONF_NODE_WSDL_REPOSITORY = "WSDLRepository";
    public static final String CONF_NODE_WSDL_NAVIGATION = "WSDLNavigation";
    public static final String CONF_NODE_WSDL_OBJECT = "WSDLObject";
    public static final String CONF_NODE_WSDL_MULTIFILING = "WSDLMultifiling";
    public static final String CONF_NODE_WSDL_DISCOVERY = "WSDLDiscovery";
    public static final String CONF_NODE_WSDL_VERSIONING = "WSDLVersioning";
    public static final String CONF_NODE_WSDL_RELATIONSHIP = "WSDLRelationship";
    public static final String CONF_NODE_WSDL_POLICY = "WSDLPolicy";
    public static final String CONF_NODE_WSDL_ACL = "WSDLACL";
    public static final String CONF_NODE_SECURITY_HANDLER = "SecurityHandler";
    public static final String CONF_NODE_CSQLCPROCESSOR = "CSQLCProcessorClass";
    private OwCMISPropertyClassFactory m_propFactory;
    private OwNetworkContext m_context;
    private OwCMISNetworkConfiguration m_networkConfigurtaion;
    private OwEventManager m_eventmanager;
    private OwRoleManager m_rolemanager;
    private OwCMISResource m_defaultresource;
    private List<String> m_repositoryIDs;
    private HashMap<String, OwCMISResource> m_resourcesIDs;
    private HashMap<String, OwCMISResource> m_resourcesNames;
    private OwCMISDomainFolder m_domainroot;
    private OwCMISLikeWildcardDefinitions wildcardsDef;
    private OwCMISObjectClassFactory m_objectClassFactory;
    private OwManagedSemiVirtualRecordConfiguration managedVirtualConfiguration;
    private OwAOManagerRegistry m_aoManagerRegistry;
    private OwCMISObjectBroker m_objectBroker = new OwCMISObjectBroker();
    private OwCMISExternalEntitiesResolver externalEntitiesResolver;
    private OwWorkitemRepository m_WorkitemRepository;
    private OwAuthenticationContext localAuthenticationContext = new OwLocalAuthenticationContext();
    private OwVirtualFolderFactory virtualFolderFactory;

    public OwCMISNetwork() {
        this(null, null);
    }

    public OwCMISNetwork(OwCMISExternalEntitiesResolver externalEntitiesResolver_p) {
        this(externalEntitiesResolver_p, null);
    }

    public OwCMISNetwork(OwCMISExternalEntitiesResolver externalEntitiesResolver_p, OwVirtualFolderFactory virtualFolderFactory_p) {
        this.externalEntitiesResolver = externalEntitiesResolver_p;
        this.virtualFolderFactory = virtualFolderFactory_p;
    }

    public OwCMISObjectBroker getObjectBroker() {
        return this.m_objectBroker;
    }

    public boolean canCreateNewObject(OwResource resource_p, OwObject parent_p, int context_p) throws OwException {
        if (parent_p != null) {
            return parent_p.getType() == 8193 || parent_p.getType() == 8207 || parent_p.getType() == 8206 || parent_p.getType() == 8194;
        }
        return Boolean.TRUE;
    }

    public boolean canCreateObjectCopy(OwObject parent_p, int[] childTypes_p, int context_p) throws OwException {
        return parent_p instanceof OwCMISObject;
    }

    public boolean canDo(OwObject obj_p, int functionCode_p, int context_p) throws OwException {
        switch (functionCode_p) {
            case 2: 
            case 3: 
            case 4: {
                return false;
            }
            case 1: {
                return false;
            }
            case 5: {
                return false;
            }
        }
        return false;
    }

    public boolean canEditAccessRights(OwObject object_p) throws OwException {
        OwCMISResource resource = null;
        try {
            resource = this.m_resourcesIDs.get(object_p.getResourceID());
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception ex) {
            LOG.error((Object)"OwCMISNetwork.canEditAccessRights():Error while checking access rights enablement!Problem retrieving resource ID from object", (Throwable)ex);
            throw new OwServerException(new OwString("ecmimpl.cmis.OwCMISNetwork.access.rights.error", "Access rights error!"), (Throwable)ex);
        }
        EnumCapabilityACL acl = resource.getCMISCapabilities().getCapabilityACL();
        if (acl != null) {
            try {
                return acl == EnumCapabilityACL.MANAGE && this.getCredentials().getACLServicePort() != null;
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"WARNING: Verify that ACL WSDL is configured!", (Throwable)e);
                } else {
                    LOG.warn((Object)"OwCMISNetwork.canEditAccessRights(): Verify that ACL WSDL is configured.");
                }
                return false;
            }
        }
        return false;
    }

    public String createNewObject(OwResource resource_p, String strObjectClassName_p, OwPropertyCollection properties_p, OwPermissionCollection permissions_p, OwContentCollection content_p, OwObject parent_p, String strMimeType_p, String strMimeParameter_p) throws OwException {
        return this.createNewObject(true, null, resource_p, strObjectClassName_p, properties_p, permissions_p, content_p, parent_p, strMimeType_p, strMimeParameter_p, false);
    }

    public String createNewObject(boolean promote_p, Object mode_p, OwResource resource_p, String strObjectClassName_p, OwPropertyCollection properties_p, OwPermissionCollection permissions_p, OwContentCollection content_p, OwObject parent_p, String strMimeType_p, String strMimeParameter_p) throws OwException {
        return this.createNewObject(promote_p, mode_p, resource_p, strObjectClassName_p, properties_p, permissions_p, content_p, parent_p, strMimeType_p, strMimeParameter_p, Boolean.FALSE);
    }

    public String createNewObject(boolean promote_p, Object mode_p, OwResource resource_p, String strObjectClassName_p, OwPropertyCollection properties_p, OwPermissionCollection permissions_p, OwContentCollection content_p, OwObject parent_p, String strMimeType_p, String strMimeParameter_p, boolean keepCheckedOut_p) throws OwException {
        OwObject parent;
        OwCMISResource res = null;
        try {
            parent = this.prepareParentObject(parent_p, resource_p, strObjectClassName_p, properties_p);
            if (parent != null) {
                res = (OwCMISResource)parent.getResource();
            } else {
                if (res == null) {
                    OwCMISResource owCMISResource = res = resource_p == null ? this.getDefaultResource() : this.getResource(resource_p.getID());
                }
                if (!res.getRepositoryInfo().getCapabilities().isCapabilityUnfiling()) {
                    parent = this.getObjectFromPath("/" + res.getID() + "/", Boolean.FALSE);
                }
            }
        }
        catch (OwException owEx) {
            throw owEx;
        }
        catch (Exception ex) {
            LOG.error((Object)"OwCMISNetwork.createNewObject():Problem retrieving resource while creating object!", (Throwable)ex);
            throw new OwServerException(new OwString("ecmimpl.cmis.OwCMISNetwork.create.object.error", "An error occurred while creating object!"), (Throwable)ex);
        }
        OwCMISObjectClass clazz = this.getObjectClass(strObjectClassName_p, res);
        OwCMISNetworkExtension ext = res.getExtension("cmis.network.prepare.object.creation", OwCMISNetworkExtension.class, clazz);
        clazz = ext.prepareForCreation(clazz, this);
        return clazz.createNewObject(this, promote_p, mode_p, res, properties_p, permissions_p, content_p, parent, strMimeType_p, strMimeParameter_p, keepCheckedOut_p);
    }

    protected OwObject prepareParentObject(OwObject parent_p, OwResource resource_p, String objectClass_p, OwPropertyCollection properties_p) throws OwException {
        OwObject parent = null;
        if (parent_p != null && parent_p.getType() == 8207) {
            OwSearchNode specialNode = null;
            try {
                specialNode = parent_p.getSearchTemplate().getSearch(false).findSearchNode(2);
            }
            catch (OwException ex) {
                throw ex;
            }
            catch (Exception e) {
                LOG.error((Object)"Could not get/find special node for path identification", (Throwable)e);
                throw new OwServerException(new OwString("ecmimpl.cmis.OwCMISNetwork.prepareParent.error", "Could not get/find special node for path identification."), (Throwable)e);
            }
            if (specialNode != null) {
                Iterator it = specialNode.getChilds().iterator();
                OwSearchNode vfolderPathNode = null;
                while (it.hasNext()) {
                    OwSearchNode specialChild = (OwSearchNode)it.next();
                    OwSearchCriteria specialCriteria = specialChild.getCriteria();
                    String criteriaUName = specialCriteria.getUniqueName();
                    String criteriaClassName = specialCriteria.getClassName();
                    if (!"VirtualFolderSearchPathProperty".equals(criteriaUName) || !"OwSearchPath".equals(criteriaClassName)) continue;
                    vfolderPathNode = specialChild;
                    break;
                }
                if (vfolderPathNode != null) {
                    OwSearchCriteria virtualFolderPathCriteria = vfolderPathNode.getCriteria();
                    OwSearchPath virtualFolderPath = (OwSearchPath)virtualFolderPathCriteria.getValue();
                    String path = virtualFolderPath.getPathName();
                    parent = this.getObjectFromPath(path, true);
                }
            }
        } else if (parent_p != null) {
            parent = parent_p;
        }
        return parent;
    }

    public String createObjectCopy(OwObject obj_p, OwPropertyCollection properties_p, OwPermissionCollection permissions_p, OwObject parent_p, int[] childTypes_p) throws OwException {
        boolean sameRepository = false;
        try {
            String objectResourceId = obj_p.getResourceID();
            String parendResourceId = parent_p.getResourceID();
            sameRepository = objectResourceId.equals(parendResourceId);
        }
        catch (Exception e) {
            throw new OwInvalidOperationException(this.getContext().localize("ecmimpl.cmis.OwCMISNetwork.copy.error", "Could not copy object !"), (Throwable)e);
        }
        if (sameRepository && obj_p instanceof OwCMISObject && parent_p instanceof OwCMISObject) {
            OwCMISObject cmisObject = (OwCMISObject)obj_p;
            OwCMISObject cmisParent = (OwCMISObject)parent_p;
            OwCMISObject copy = cmisObject.createCopy(cmisParent, properties_p, permissions_p, childTypes_p);
            try {
                return copy.getDMSID();
            }
            catch (Exception e) {
                LOG.error((Object)"OwCMISNetwork.createObjectCopy():Could not retrieve object copy DMSID!", (Throwable)e);
                throw new OwInvalidOperationException(this.getContext().localize("ecmimpl.cmis.OwCMISNetwork.copy.error", "Could not copy object !"), (Throwable)e);
            }
        }
        if (parent_p instanceof OwCMISObject) {
            try {
                String className = obj_p.getClassName();
                OwPropertyCollection copiedPorperties = obj_p.getProperties(null);
                OwStandardPropertyCollection properties = new OwStandardPropertyCollection();
                properties.putAll((Map)copiedPorperties);
                if (properties_p != null) {
                    properties.putAll((Map)properties_p);
                }
                return this.createNewObject(true, null, parent_p.getResource(), className, (OwPropertyCollection)properties, permissions_p, obj_p.getContentCollection(), parent_p, obj_p.getMIMEType(), obj_p.getMIMEParameter());
            }
            catch (Exception e) {
                LOG.error((Object)"Could not perform non-CMIS object copy!", (Throwable)e);
                throw new OwInvalidOperationException(this.getContext().localize("ecmimpl.cmis.OwCMISNetwork.copy.error", "Could not copy object !"), (Throwable)e);
            }
        }
        LOG.error((Object)"OwCMISNetwork.createObjectCopy(): paset can be performed only when the destination is a CMIS object!");
        throw new OwInvalidOperationException(this.getContext().localize("ecmimpl.cmis.OwCMISNetwork.copy.error", "Could not copy object !"));
    }

    public OwObjectSkeleton createObjectSkeleton(OwObjectClass objectClass_p, OwResource resource_p) throws OwException {
        try {
            OwCMISResource res = resource_p == null ? this.getDefaultResource() : this.getResource(resource_p.getID());
            OwCMISNetworkExtension ext = res.getExtension("cmis.network.prepare.object.creation", OwCMISNetworkExtension.class, objectClass_p);
            OwCMISObjectClass clazz = ext.prepareForCreation((OwCMISObjectClass)objectClass_p, this);
            OwXMLUtil initValues = this.getNetworkConfiguration().getCreationInitialValuesConfig(clazz.getClassName());
            OwCMISObjectSkeleton skeleton = null;
            skeleton = initValues == null ? new OwCMISObjectSkeleton(this, clazz) : new OwCMISObjectSkeleton(this, clazz, initValues);
            skeleton.setField(objectClass_p.getPropertyClass(OwCMISPropertyNames.OBJECT_TYPE_ID.getId()).getClassName(), objectClass_p.getClassName());
            return skeleton;
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception ex) {
            LOG.error((Object)"OwCMISNetwork.createObjectSkeleton():Problem instantiation of Skeleton object!", (Throwable)ex);
            throw new OwServerException(this.getContext().localize("ecmimpl.cmis.OwCMISNetwork.skeleton.object.error", "An error occurred while creating object!"), (Throwable)ex);
        }
    }

    public Object getApplicationObject(int type_p, String strName_p, Object param_p, boolean forceUserSpecificObject_p, boolean createIfNotExist_p) throws OwException {
        OwAOManager typedManager = this.getAOManagerForType(type_p);
        Object appObject = typedManager.getApplicationObject(strName_p, param_p, forceUserSpecificObject_p, createIfNotExist_p);
        return appObject;
    }

    public Object getApplicationObject(int type_p, String strName_p, boolean forceUserSpecificObject_p, boolean createIfNotExist_p) throws OwException {
        OwAOManager typedManager = this.getAOManagerForType(type_p);
        Object appObject = typedManager.getApplicationObject(strName_p, forceUserSpecificObject_p, createIfNotExist_p);
        return appObject;
    }

    public Collection<?> getApplicationObjects(int type_p, String strName_p, boolean forceUserSpecificObject_p) throws OwException {
        OwAOManager typedManager = this.getAOManagerForType(type_p);
        Collection appObjects = typedManager.getApplicationObjects(strName_p, forceUserSpecificObject_p);
        return appObjects;
    }

    protected synchronized OwAOManager getAOManagerForType(int type_p) throws OwException {
        if (this.m_aoManagerRegistry == null) {
            this.m_aoManagerRegistry = this.createAOManagerRegistry();
        }
        OwAOManager typedManager = this.m_aoManagerRegistry.getManager(type_p);
        return typedManager;
    }

    protected OwAOManagerRegistry createAOManagerRegistry() throws OwException {
        OwCMISNetworkConfiguration configuration = this.getNetworkConfiguration();
        OwFileAOSupport fileAOSupport = new OwFileAOSupport((OwNetwork)this, (OwNetworkConfiguration)configuration, "WEB-INF/cmis");
        String defaultPreferencesFolder = "owpreferences";
        String preferencesFolder = configuration.getConfigNode().getSafeTextValue("UserDefinedPreferencesFolder", "owpreferences");
        OwDefaultRegistry stdRegistry = new OwDefaultRegistry();
        OwDBAttributeBagsSupport bagsSupport = null;
        try {
            bagsSupport = OwDBAttributeBagsSupport.createAndCheckDBSupport((OwNetworkContext)this.getContext());
        }
        catch (OwNotSupportedException e) {
            LOG.warn((Object)"OwCMISNetwork.createAOManagerRegistry: DB bags are not supported - transient attribute bags will be used!");
            bagsSupport = new OwTransientBagsSupport();
        }
        stdRegistry.registerManager((OwAOManager)new OwAttributeBagsManager(this.getContext(), 7, false, (OwAttributeBagsSupport)bagsSupport));
        stdRegistry.registerManager((OwAOManager)new OwAttributeBagsManager(this.getContext(), 9, true, (OwAttributeBagsSupport)bagsSupport));
        stdRegistry.registerManager((OwAOManager)new OwSearchTemplatesManager((OwAOSupport)fileAOSupport, "", (OwSearchTemplateFactory)this, "owsearchtemplates", ""));
        stdRegistry.registerManager((OwAOManager)new OwVirtualFoldersManager((OwAOSupport)fileAOSupport, this.virtualFolderFactory, this.m_rolemanager, configuration.getVirtualFoldersContainer(null)));
        stdRegistry.registerManager((OwAOManager)new OwDefaultAOManager(2, (OwAOSupport)fileAOSupport, preferencesFolder));
        stdRegistry.registerManager((OwAOManager)new OwXMLAOManager((OwAOSupport)fileAOSupport));
        return stdRegistry;
    }

    public OwUIAccessRightsModul getEditAccessRightsSubModul(OwObject object_p) throws OwException {
        if (this.canEditAccessRights(object_p)) {
            HashMap<String, String> privilegeDisplayNames = new HashMap<String, String>();
            OwCMISAccessRightsModule accessRightsModul = new OwCMISAccessRightsModule(this, object_p, null, null, privilegeDisplayNames, 2);
            return accessRightsModul;
        }
        return null;
    }

    public Object getInterface(String strInterfaceName_p, Object object_p) throws OwException {
        try {
            Class<?> interfaceClass = Class.forName(strInterfaceName_p);
            if (OwWorkitemRepository.class == interfaceClass) {
                if (null == this.m_WorkitemRepository) {
                    this.m_WorkitemRepository = this.createWorkItemRepository();
                }
                return this.m_WorkitemRepository;
            }
            if (OwCSQLCProcessor.class.isAssignableFrom(interfaceClass)) {
                return this.factorySearchNodeSQLProcessor();
            }
            if (OwInfoProvider.class.isAssignableFrom(interfaceClass)) {
                return new OwCMISInfoProvider(this);
            }
        }
        catch (ClassNotFoundException e) {
            String message = "The requested interface was not found on classpath: " + strInterfaceName_p;
            LOG.error((Object)message, (Throwable)e);
            throw new OwInvalidOperationException(message, (Throwable)e);
        }
        String message = "Requested interface is not supported by this network, interface = " + strInterfaceName_p;
        LOG.error((Object)message);
        throw new OwNotSupportedException(message);
    }

    private OwWorkitemRepository createWorkItemRepository() throws OwConfigurationException {
        OwXMLUtil bpmConfigNode = this.getNetworkConfiguration().getBpmNode();
        String implementationClassName = bpmConfigNode.getSafeTextValue("ClassName", "");
        if (0 == implementationClassName.length()) {
            String message = "No BPM configured for this instance!";
            LOG.error((Object)message);
            throw new OwConfigurationException(message);
        }
        try {
            Class<?> implementationClass = Class.forName(implementationClassName);
            Constructor<?> constructor = implementationClass.getConstructor(OwNetwork.class, OwXMLUtil.class);
            OwWorkitemRepository instance = (OwWorkitemRepository)constructor.newInstance(this, bpmConfigNode);
            return instance;
        }
        catch (ClassNotFoundException e) {
            String message = "Could not create instance.";
            LOG.error((Object)message, (Throwable)e);
            throw new OwConfigurationException(message, (Throwable)e);
        }
        catch (SecurityException e) {
            String message = "Could not create instance.";
            LOG.error((Object)message, (Throwable)e);
            throw new OwConfigurationException(message, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            String message = "Could not create instance.";
            LOG.error((Object)message, (Throwable)e);
            throw new OwConfigurationException(message, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            String message = "Could not create instance.";
            LOG.error((Object)message, (Throwable)e);
            throw new OwConfigurationException(message, (Throwable)e);
        }
        catch (InstantiationException e) {
            String message = "Could not create instance.";
            LOG.error((Object)message, (Throwable)e);
            throw new OwConfigurationException(message, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            String message = "Could not create instance.";
            LOG.error((Object)message, (Throwable)e);
            throw new OwConfigurationException(message, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            String message = "Could not create instance.";
            LOG.error((Object)message, (Throwable)e);
            throw new OwConfigurationException(message, (Throwable)e);
        }
    }

    public Locale getLocale() {
        return this.m_context.getLocale();
    }

    public boolean hasInterface(String strInterfaceName_p) {
        if ("com.wewebu.ow.server.ecm.bpm.OwWorkitemRepository".equals(strInterfaceName_p)) {
            try {
                return this.getNetworkConfiguration() != null && this.getNetworkConfiguration().getBpmNode() != null;
            }
            catch (OwConfigurationException ex) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Support for Workflow not available, caused by missing configuration");
                }
                return false;
            }
        }
        if (OwCSQLCProcessor.class.getCanonicalName().equals(strInterfaceName_p)) {
            return true;
        }
        return OwInfoProvider.class.getCanonicalName().equals(strInterfaceName_p);
    }

    public void init(OwNetworkContext context_p, OwXMLUtil networkSettings_p) throws OwException {
        this.m_context = context_p;
        this.m_networkConfigurtaion = new OwCMISNetworkConfiguration(networkSettings_p);
        if (this.virtualFolderFactory == null) {
            this.virtualFolderFactory = new OwCMISVirtualFolderFactory(this, this.getDMSIDDecoder());
        }
    }

    protected void initResourceCache() {
        if (this.m_resourcesIDs != null) {
            this.m_resourcesIDs.clear();
            this.m_resourcesIDs = null;
        }
        if (this.m_resourcesNames != null) {
            this.m_resourcesNames.clear();
            this.m_resourcesNames = null;
        }
        if (this.m_repositoryIDs != null) {
            this.m_repositoryIDs.clear();
            this.m_repositoryIDs = null;
        }
        this.m_repositoryIDs = new LinkedList<String>();
        this.m_resourcesIDs = new HashMap();
        this.m_resourcesNames = new HashMap();
    }

    public void setEventManager(OwEventManager eventManager_p) {
        this.m_eventmanager = eventManager_p;
    }

    public void setRoleManager(OwRoleManager roleManager_p) {
        this.m_rolemanager = roleManager_p;
    }

    public boolean canBatch() {
        return false;
    }

    public boolean canRefreshStaticClassdescriptions() throws OwException {
        return false;
    }

    public void closeBatch(OwBatch batch_p) throws OwException {
    }

    public final OwObjectCollection doSearch(OwSearchNode searchCriteria_p, OwSort sortCriteria_p, Collection propertyNames_p, int maxSize_p, int versionSelection_p) throws Exception {
        OwCMISSearchResult result = this.doCMISSearch(searchCriteria_p, sortCriteria_p, propertyNames_p, maxSize_p, versionSelection_p);
        return result.getCmisSearchResult();
    }

    public OwCMISSearchResult doCMISSearch(OwSearchNode searchCriteria_p, OwSort sortCriteria_p, Collection propertyNames_p, int maxSize_p, int versionSelection_p) throws OwException {
        BigInteger max = new BigInteger(Integer.toString(2 * maxSize_p));
        HashMap<String, List<OwCMISQueryResult>> searchResults = new HashMap<String, List<OwCMISQueryResult>>();
        OwCMISCSQLCProcessor processor = this.factorySearchNodeSQLProcessor();
        try {
            OwExternal statementsEx = processor.createSQLStatements(searchCriteria_p, propertyNames_p, sortCriteria_p);
            List statements = (List)statementsEx.getInternal();
            for (OwQueryStatement statement : statements) {
                boolean searchVersionAll;
                OwBooleanCollector adviceResut = OwBooleanCollector.newAND((boolean)true);
                OwNativeSearchAdvice sqlSearchAdvice = (OwNativeSearchAdvice)OwJoinPoint.joinPoint(OwNativeSearchAdvice.class, (OwJoinPointResultCollector)adviceResut);
                sqlSearchAdvice.adviceNativeSearch((Object)statement);
                if (!adviceResut.getResult().booleanValue()) continue;
                String searchOp = statement.createSQLString().toString();
                Log4JStopWatch stopWatch = new Log4JStopWatch("OwCMISNetwork.doSearch", "OwCMISNetwork.doSearch: Search service");
                LOG.debug((Object)("OwCMISNetwork.doSearch: " + searchOp));
                String repositoryID = statement.getTargetRepositoryID();
                OwCMISResource resource = this.getResource(repositoryID);
                CmisRepositoryCapabilitiesType capabilities = resource.getCMISCapabilities();
                boolean bl = searchVersionAll = versionSelection_p == 3;
                if (searchVersionAll && !(searchVersionAll = capabilities.isCapabilityAllVersionsSearchable())) {
                    LOG.warn((Object)"OwCMISNetwork.doSearch: The repository does not support search in all versions! Search will be excuted for current versions only!");
                }
                LOG.debug((Object)("OwCMISNetwork.doSearch: searchVersionAll = " + searchVersionAll));
                CmisObjectListType searchResultLst = this.getDiscoveryServicePort().query(repositoryID, searchOp, Boolean.valueOf(searchVersionAll), Boolean.valueOf(true), EnumIncludeRelationships.NONE, "", max, BigInteger.ZERO, null);
                stopWatch.stop();
                LinkedList<OwCMISQueryResult> repositoryResults = (LinkedList<OwCMISQueryResult>)searchResults.get(repositoryID);
                if (repositoryResults == null) {
                    repositoryResults = new LinkedList<OwCMISQueryResult>();
                    searchResults.put(repositoryID, repositoryResults);
                }
                repositoryResults.add(new OwCMISQueryResult(statement, searchResultLst));
            }
            OwObjectCollection cmisSearchResult = this.createSearchResult(searchResults, versionSelection_p, maxSize_p);
            return new OwCMISSearchResult((OwExternal<List<OwQueryStatement>>)statementsEx, cmisSearchResult);
        }
        catch (CmisException e) {
            OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e, this.getContext().getLocale());
            LOG.error((Object)("OwCMISNetwork.doSearch: Search could not be executed because of a CMIS error : " + catcher.getLogMessage()), (Throwable)e);
            throw catcher.toOwException(this.getContext().localize("ecmimpl.cmis.OwCMISNetwork.backend.search.error", "Error executing search on backend! "), false);
        }
        catch (OwException e) {
            LOG.error((Object)"OwCMISNetwork.doSearch: Search could not be executed!", (Throwable)e);
            throw new OwServerException(this.getContext().localize("ecmimpl.cmis.OwCMISNetwork.search.error", "Error executing search !"), (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"OwCMISNetwork.doSearch: Search could not be executed!", (Throwable)e);
            throw new OwServerException(this.getContext().localize("ecmimpl.cmis.OwCMISNetwork.search.error", "Error executing search !"), (Throwable)e);
        }
    }

    private OwObjectCollection createSearchResult(Map<String, List<OwCMISQueryResult>> searchResults_p, int versionSelection_p, int maxSize_p) throws OwException {
        try {
            OwStandardObjectCollection result = new OwStandardObjectCollection();
            result.setAttribute("ow_complete", (Object)Boolean.TRUE);
            for (Map.Entry<String, List<OwCMISQueryResult>> repositoryResult : searchResults_p.entrySet()) {
                boolean searchVersionAll;
                boolean searchCheckedOut;
                List<OwCMISQueryResult> resultObjects = repositoryResult.getValue();
                String repositoryID = repositoryResult.getKey();
                OwCMISResource resource = this.getResource(repositoryID);
                CmisRepositoryCapabilitiesType capabilities = resource.getCMISCapabilities();
                boolean pwcSearchable = capabilities.isCapabilityPWCSearchable();
                boolean bl = searchCheckedOut = versionSelection_p == 8;
                if (searchCheckedOut && !pwcSearchable) {
                    LOG.warn((Object)"OwCMISNetwork.createSearchResult: The repository does not support search for checked-out documents! ");
                }
                boolean bl2 = searchVersionAll = versionSelection_p == 3;
                if (searchVersionAll && !(searchVersionAll = capabilities.isCapabilityAllVersionsSearchable())) {
                    LOG.warn((Object)"OwCMISNetwork.createSearchResult: The repository does not support search in all versions! Search will be excuted for current versions only!");
                }
                block4: for (OwCMISQueryResult qResult : resultObjects) {
                    CmisObjectListType searchResult = qResult.getObjectList();
                    List objects = searchResult.getObjects();
                    if (result.size() > maxSize_p && searchResult.getNumItems().intValue() > 0) {
                        result.setAttribute("ow_complete", (Object)Boolean.FALSE);
                        break;
                    }
                    if (objects == null) continue;
                    HashMap<String, OwCMISObject> candidates = new HashMap<String, OwCMISObject>();
                    Iterator i = objects.iterator();
                    while (i.hasNext()) {
                        CmisObjectType nativeCmisObject = (CmisObjectType)i.next();
                        OwCMISNetworkExtension networkExtension = resource.getExtension("cmis.network.tweak.object", OwCMISNetworkExtension.class, nativeCmisObject);
                        nativeCmisObject = networkExtension.tweakSearchResult(nativeCmisObject, qResult.getStatement(), this);
                        OwCMISObject cmisObject = this.createCMISObject(nativeCmisObject, resource);
                        result.add((Object)cmisObject);
                        if (cmisObject instanceof OwCMISDocumentObject && pwcSearchable && !searchVersionAll) {
                            OwCMISObject candidate;
                            Boolean latestVersion;
                            Boolean seriesCheckedOut;
                            String versionSeriesID = OwCMISPropertyNames.VERSION_SERIES_ID.getIdValue(nativeCmisObject);
                            if (!searchCheckedOut) {
                                seriesCheckedOut = OwCMISPropertyNames.IS_VERSION_SERIES_CHECKED_OUT.getBooleanValue(nativeCmisObject);
                                latestVersion = OwCMISPropertyNames.IS_LATEST_VERSION.getBooleanValue(nativeCmisObject);
                                if (!(seriesCheckedOut == null || latestVersion == null || seriesCheckedOut.booleanValue() && latestVersion.booleanValue())) {
                                    candidate = (OwCMISObject)candidates.get(versionSeriesID);
                                    if (candidate != null) {
                                        result.remove((Object)candidate);
                                    }
                                    candidates.put(versionSeriesID, cmisObject);
                                } else if (!candidates.containsKey(versionSeriesID)) {
                                    candidates.put(versionSeriesID, cmisObject);
                                } else {
                                    result.remove((Object)cmisObject);
                                }
                            } else {
                                seriesCheckedOut = OwCMISPropertyNames.IS_VERSION_SERIES_CHECKED_OUT.getBooleanValue(nativeCmisObject);
                                latestVersion = OwCMISPropertyNames.IS_LATEST_VERSION.getBooleanValue(nativeCmisObject);
                                if (seriesCheckedOut != null && latestVersion != null && seriesCheckedOut.booleanValue() && latestVersion.booleanValue()) {
                                    candidate = (OwCMISObject)candidates.get(versionSeriesID);
                                    if (candidate != null) {
                                        result.remove((Object)candidate);
                                    }
                                    candidates.put(versionSeriesID, cmisObject);
                                } else if (!candidates.containsKey(versionSeriesID)) {
                                    candidates.put(versionSeriesID, cmisObject);
                                } else {
                                    result.remove((Object)cmisObject);
                                }
                            }
                        }
                        if (result.size() < maxSize_p || !i.hasNext()) continue;
                        result.setAttribute("ow_complete", (Object)Boolean.FALSE);
                        continue block4;
                    }
                }
                if (result.size() < maxSize_p) continue;
                break;
            }
            result.setAttribute("ow_size", (Object)result.size());
            return result;
        }
        catch (OwException e) {
            LOG.error((Object)"OwCMISNetwork.createSearchResult: Search resoult cold not be created!", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)"OwCMISNetwork.createSearchResult: Search resoult cold not be created!", (Throwable)e);
            throw new OwServerException(this.getContext().localize("ecmimpl.cmis.OwCMISNetwork.search.error", "Error executing search !"), (Throwable)e);
        }
    }

    public String getDMSPrefix() {
        return this.getDMSIDDecoder().getDMSIDPrefix();
    }

    public OwEventManager getEventManager() {
        return this.m_eventmanager;
    }

    public OwNetworkContext getContext() {
        return this.m_context;
    }

    public OwCMISObjectClass getObjectClass(String strClassName_p, OwResource resource_p) throws OwException {
        OwCMISResource cmisResource = (OwCMISResource)resource_p;
        if (null == resource_p) {
            cmisResource = this.getDefaultResource();
        }
        OwCMISObjectModel objectModel = cmisResource.getObjectModel();
        OwCMISObjectClass clazz = objectModel.getObjectClass(strClassName_p);
        OwCMISNetworkExtension ext = cmisResource.getExtension("cmis.network.prepare.objectClass", OwCMISNetworkExtension.class, clazz);
        return ext.prepareObjectClass(clazz, this);
    }

    public Map<String, String> getObjectClassNames(int[] types_p, boolean excludeHiddenAndNonInstantiable_p, boolean rootOnly_p, OwResource resource_p) throws OwException {
        OwCMISResource cmisResource = (OwCMISResource)resource_p;
        if (null == cmisResource) {
            cmisResource = this.getDefaultResource();
        }
        OwCMISObjectModel objectModel = cmisResource.getObjectModel();
        return objectModel.getObjectClassNames(types_p, excludeHiddenAndNonInstantiable_p, rootOnly_p, this.getLocale());
    }

    public OwCMISObject getObjectFromDMSID(String strDMSID_p, boolean refresh_p) throws OwException {
        OwCMISDMSIDDecoder dmsidCodec = this.getDMSIDDecoder();
        OwCMISDMSID dmsid = dmsidCodec.createDMSID(strDMSID_p);
        return dmsid.getObject(this);
    }

    public OwObject getObjectFromPath(String strPath_p, boolean refresh_p) throws OwException {
        if (strPath_p.equals("/")) {
            return this.m_domainroot;
        }
        int end = strPath_p.indexOf("/", 1);
        String strRepoName = null;
        strRepoName = strPath_p.startsWith("/") ? strPath_p.substring(1, end) : strPath_p.substring(0, end);
        OwCMISResource res = this.getResource(strRepoName);
        if (res == null) {
            for (OwCMISResource entry : this.m_resourcesIDs.values()) {
                if (!entry.getDisplayName(this.getLocale()).equals(strRepoName)) continue;
                res = entry;
                break;
            }
        }
        if (res == null) {
            LOG.debug((Object)"repository could not be found by the given path, using default repository!");
            res = this.getDefaultResource();
        }
        try {
            OwCMISPropertiesFilter filter = new OwCMISPropertiesFilter();
            filter.add(OwCMISPropertyNames.OBJECT_ID.getId());
            filter.add(OwCMISPropertyNames.OBJECT_TYPE_ID.getId());
            CmisObjectType obj = this.getObjectServicePort().getObjectByPath(res.getID(), strPath_p.substring(end), filter.getFilterString(), Boolean.TRUE, EnumIncludeRelationships.NONE, null, Boolean.FALSE, Boolean.FALSE, null);
            return this.createCMISObject(obj, res);
        }
        catch (CmisException e) {
            OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e, this.getContext().getLocale());
            LOG.error((Object)("OwCMISNetwork.getObjectFromPath(): Can not find object by path " + strPath_p + ". A CMIS error occurred :  " + catcher.getLogMessage()), (Throwable)e);
            throw catcher.toOwException(this.getContext().localize1("ecmimpl.cmis.OwCMISNetwork.objectbypath.error", "Could not find object by path (%1)", strPath_p), true);
        }
    }

    public OwCMISResource getResource(String strIdOrName_p) throws OwException {
        if (strIdOrName_p == null) {
            return this.getDefaultResource();
        }
        OwCMISResource resource = this.m_resourcesIDs.get(strIdOrName_p);
        if (resource == null) {
            resource = this.m_resourcesNames.get(strIdOrName_p);
        }
        if (null == resource) {
            try {
                List lst = this.getRepositoryServicePort().getRepositories(null);
                for (CmisRepositoryEntryType repositoryEntry : lst) {
                    if (!repositoryEntry.getRepositoryId().equals(strIdOrName_p) && !repositoryEntry.getRepositoryName().equals(strIdOrName_p)) continue;
                    RepositoryServicePort repositoryServicePort = this.getRepositoryServicePort();
                    CmisRepositoryInfoType repositoryInfo = repositoryServicePort.getRepositoryInfo(repositoryEntry.getRepositoryId(), null);
                    resource = new OwCMISResource(repositoryEntry, repositoryInfo, this, this.getObjectClassFactory());
                    this.m_resourcesIDs.put(strIdOrName_p, resource);
                    this.m_resourcesNames.put(repositoryEntry.getRepositoryName(), resource);
                    break;
                }
            }
            catch (CmisException e) {
                OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e);
                LOG.error((Object)("OwCMISNetwork.getResource(): Could not retrieve CMIS repository information for resource ID " + strIdOrName_p + ". A CMIS error occurred :  " + catcher.getLogMessage()), (Throwable)e);
                throw catcher.toOwException(this.getContext().localize1("ecmimpl.cmis.OwCMISNetwork.resource.info.error", "An error occurred while retrieving repository information  for resource with ID %1", strIdOrName_p));
            }
        }
        if (resource == null) {
            LOG.warn((Object)("OwCMISNetwork.getResource(Id): Could not retrive resource by Id = " + strIdOrName_p));
            throw new OwObjectNotFoundException(this.getContext().localize1("ecmimpl.cmis.OwCMISNetwork.resourceNotFoundById", "Could not find resource by Id = %1", strIdOrName_p));
        }
        return resource;
    }

    public Iterator<String> getResourceIDs() throws OwException {
        return this.m_repositoryIDs.iterator();
    }

    public OwBatch openBatch() throws OwException {
        return null;
    }

    public void refreshStaticClassdescriptions() throws OwException {
    }

    public void releaseResources() throws OwException {
    }

    public OwFieldDefinition getFieldDefinition(String strFieldDefinitionName_p, String strResourceName_p) throws OwException {
        OwCMISResource cmisResource;
        OwCMISResource owCMISResource = cmisResource = strResourceName_p == null ? this.getDefaultResource() : this.getResource(strResourceName_p);
        if (cmisResource == null && (cmisResource = this.getResource(strResourceName_p)) == null) {
            LOG.error((Object)("OwCMISNetwork.getFieldDefinition():Could not find a requested field definition!Resource could not be found, or incorrect resource ID/name (" + strResourceName_p + ")"));
            throw new OwObjectNotFoundException(this.getContext().localize("ecmimpl.cmis.OwCMISNetwork.field.definition.not.found.error", "Could not find a requested field definition!"));
        }
        OwCMISObjectModel objectModel = cmisResource.getObjectModel();
        return objectModel.getPropertyClass(strFieldDefinitionName_p);
    }

    public Collection<OwWildCardDefinition> getWildCardDefinitions(String strFieldDefinitionName_p, String strResourceName_p, int op_p) throws OwException {
        switch (op_p) {
            case 6: 
            case 7: {
                if (this.wildcardsDef == null) {
                    this.wildcardsDef = new OwCMISLikeWildcardDefinitions((OwRepositoryContext)this.getContext());
                }
                return this.wildcardsDef.getWildCardDefinitions();
            }
        }
        return null;
    }

    public boolean canUserSelect() throws OwException {
        try {
            Node authenticationNode = this.getNetworkConfiguration().getConfigNode().getSubNode("Authentication");
            return "LDAP".equals(OwXMLDOMUtil.getSafeStringAttributeValue((Node)authenticationNode, (String)"mode", (String)""));
        }
        catch (Exception e) {
            String msg = "Invalid Credentials - maybe there are problems on reading the network config node/subnode \"(Authentication)\"...";
            LOG.error((Object)("OwCMISNetwork.createCredentials():" + msg), (Throwable)e);
            throw new OwServerException(this.getContext().localize("ecmimpl.cmis.OwCMISNetwork.invalid.authentication.configuration.error", "Invalid CMIS authentication configuration!"), (Throwable)e);
        }
    }

    public OwUILoginModul<OwCMISNetwork> getLoginSubModul() throws OwException {
        OwCMISLoginSubModul loginSubModul = new OwCMISLoginSubModul();
        loginSubModul.init(this);
        return loginSubModul;
    }

    public String getRoleDisplayName(String strRoleName_p) throws OwException {
        return strRoleName_p;
    }

    public OwUserInfo getUserFromID(String strID_p) throws OwException {
        OwCMISCredentials objCred = this.getCredentials();
        if (!OwCMISLDAPCredentials.class.isAssignableFrom(((Object)((Object)objCred)).getClass())) {
            throw new OwServerException("This method only works for LDAP.");
        }
        OwCMISLDAPCredentials cred = (OwCMISLDAPCredentials)objCred;
        OwLdapConnector con = cred.getLdapConnector();
        try {
            OwUserInfo userInfo = con.findUserByDNAnonymously(strID_p);
            return userInfo;
        }
        catch (OwObjectNotFoundException e) {
            OwUserInfo userInfo = con.findUserByIdAnonymously(strID_p);
            return userInfo;
        }
    }

    public OwUIUserSelectModul getUserSelectSubModul(String strID_p, int[] types_p) throws OwException {
        OwCMISUIUserSelectionModul modul = null;
        if (this.canUserSelect()) {
            modul = new OwCMISUIUserSelectionModul();
            modul.setFilter(types_p);
            modul.setCurrentUserID(strID_p);
            try {
                modul.init(this);
            }
            catch (Exception e) {
                String msg = "Cannot initialize the User selection module";
                LOG.error((Object)msg, (Throwable)e);
                throw new OwServerException(this.getContext().localize("ecmimpl.cmis.OwCMISNetwork.initUserSelectEx", "Cannot initialize the User Selection dialog."), (Throwable)e);
            }
        }
        return modul;
    }

    public void loginDefault(String strUser_p, String strPassword_p) throws OwException {
        if (strUser_p == null && strPassword_p == null) {
            this.getCredentials();
        } else {
            try {
                this.authenticate(strUser_p, strPassword_p);
            }
            catch (OwException e) {
                this.logout();
                throw e;
            }
        }
        this.postLogin();
    }

    private OwAuthenticationContext getAuthenticationContext() {
        OwNetworkContext context = this.getContext();
        if (context instanceof OwAuthenticationContext) {
            return (OwAuthenticationContext)context;
        }
        return this.localAuthenticationContext;
    }

    public OwCMISCredentials getCredentials() throws OwAuthenticationException {
        OwAuthenticationContext authenticationContext = this.getAuthenticationContext();
        OwAuthentication authentication = authenticationContext.getAuthentication();
        if (authentication == null || !authentication.isAuthenticated()) {
            LOG.trace((Object)"OwCMISNetwork.getCredentials : No authenticated credentials found.");
            return null;
        }
        OwCMISCredentials cmisCredentials = (OwCMISCredentials)authentication.getOWDCredentials();
        return cmisCredentials;
    }

    public void authenticate(String strUser_p, String strPassword_p) throws OwAuthenticationException, OwConfigurationException, OwServerException {
        OwCMISCredentialsAuthenticator authenticator = new OwCMISCredentialsAuthenticator(this.getNetworkConfiguration().getConfigNode());
        OwCredentialsAuthentication authentication = new OwCredentialsAuthentication(null, strUser_p, strPassword_p);
        if ((authentication = authenticator.authenticate((OwAuthentication)authentication)).isAuthenticated()) {
            OwCMISCredentials credentials = (OwCMISCredentials)authentication.getOWDCredentials();
            TimeZone clientTimeZone = this.getContext().getClientTimeZone();
            OwMandator mandator = this.getContext().getMandator();
            credentials.setMandator(mandator);
            OwCMISSecurityHandlerInterface securityHandler = credentials.getSecurityHandler();
            securityHandler.setWsi18nTimeZone(clientTimeZone);
            securityHandler.setLocale(this.getLocale());
            OwAuthenticationContext authenticationContext = this.getAuthenticationContext();
            authenticationContext.setAuthentication((OwAuthentication)authentication);
        }
    }

    protected void postLogin() throws OwException {
        try {
            RepositoryServicePort repositoryServicePort = this.getRepositoryServicePort();
            List rlist = repositoryServicePort.getRepositories(null);
            this.initResourceCache();
            for (CmisRepositoryEntryType repositoryEntry : rlist) {
                if (this.getDefaultResource() == null) {
                    CmisRepositoryInfoType repositoryInfo = repositoryServicePort.getRepositoryInfo(repositoryEntry.getRepositoryId(), null);
                    this.m_defaultresource = new OwCMISResource(repositoryEntry, repositoryInfo, this, this.getObjectClassFactory());
                    this.m_resourcesIDs.put(repositoryEntry.getRepositoryId(), this.m_defaultresource);
                    this.m_resourcesNames.put(repositoryEntry.getRepositoryName(), this.m_defaultresource);
                }
                this.m_repositoryIDs.add(repositoryEntry.getRepositoryId());
            }
            this.m_domainroot = new OwCMISDomainFolder(this);
            this.getContext().onLogin((OwBaseUserInfo)this.getCredentials().getUserInfo());
        }
        catch (CmisException cmisEx) {
            OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(cmisEx, this.getContext().getLocale());
            LOG.error((Object)("OwCMISNetwork.loginDefault(): Could not login. A CMIS error occurred :  " + catcher.getLogMessage()), (Throwable)cmisEx);
            this.logout();
            throw catcher.toOwException(this.getContext().localize("ecmimpl.cmis.OwCMISNetwork.login.cmis.error", "An error occurred during login!"), true);
        }
        catch (SOAPFaultException ex) {
            this.logout();
            LOG.debug((Object)"OwCMISNetwork.loginDefault(): Login failed: Wrong username or password!", (Throwable)ex);
            throw new OwAuthenticationException(this.getContext().localize("ecmimpl.cmis.OwCMISNetwork.login.failed", "Login failed: Wrong username or password!"), (Throwable)ex);
        }
        catch (WebServiceException serviceEx) {
            this.logout();
            LOG.fatal((Object)"OwCMISNetwork.loginDefault(): Can not create communication to the Webservices!", (Throwable)serviceEx);
            throw new OwServerException(this.getContext().localize("ecmimpl.cmis.OwCMISNetwork.login.communication.error", "Cannot create communication to the Webservices!"), (Throwable)serviceEx);
        }
        catch (OwConfigurationException conEx) {
            this.logout();
            throw conEx;
        }
        catch (Error err) {
            this.logout();
            throw err;
        }
        catch (Exception e) {
            this.logout();
            throw new OwServerException(this.getContext().localize("ecmimpl.cmis.OwCMISNetwork.login.cmis.error", "An error occurred during login!"), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout() throws OwException {
        try {
            OwCMISCredentials credentials = this.getCredentials();
            if (credentials != null) {
                credentials.invalidate();
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"OwCMISNetwork.logout(): Invalidate credentials errors...", (Throwable)e);
        }
        finally {
            OwAuthenticationContext authenticationContext = this.getAuthenticationContext();
            authenticationContext.setAuthentication(null);
            if (this.m_repositoryIDs != null) {
                this.m_repositoryIDs.clear();
                this.m_repositoryIDs = null;
            }
            if (this.m_resourcesIDs != null) {
                this.m_resourcesIDs.clear();
                this.m_resourcesIDs = null;
            }
            if (this.m_resourcesNames != null) {
                this.m_resourcesNames.clear();
                this.m_resourcesNames = null;
            }
        }
    }

    @Override
    public RepositoryServicePort getRepositoryServicePort() throws OwException {
        return this.getCredentials().getRepositoryServicePort();
    }

    @Override
    public NavigationServicePort getNavigationServicePort() throws OwException {
        return this.getCredentials().getNavigationServicePort();
    }

    @Override
    public ObjectServicePort getObjectServicePort() throws OwException {
        return this.getCredentials().getObjectServicePort();
    }

    @Override
    public DiscoveryServicePort getDiscoveryServicePort() throws OwException {
        return this.getCredentials().getDiscoveryServicePort();
    }

    @Override
    public MultiFilingServicePort getMultiFilingServicePort() throws OwException {
        return this.getCredentials().getMultiFilingservicePort();
    }

    @Override
    public PolicyServicePort getPolicyServicePort() throws OwException {
        return this.getCredentials().getPolicyServicePort();
    }

    @Override
    public RelationshipServicePort getRelationshipServicePort() throws OwException {
        return this.getCredentials().getRelationshipServicePort();
    }

    @Override
    public VersioningServicePort getVersionServicePort() throws OwException {
        return this.getCredentials().getVersionServicePort();
    }

    @Override
    public ACLServicePort getACLServicePort() throws OwException {
        return this.getCredentials().getACLServicePort();
    }

    protected OwCMISResource getDefaultResource() {
        return this.m_defaultresource;
    }

    public OwCMISPropertyClassFactory getPropertyClassFactory() throws OwException {
        if (this.m_propFactory == null) {
            this.m_propFactory = new OwCMISStandardPropertyClassFactory(this.getContext().getClientTimeZone(), this.getNetworkConfiguration());
        }
        return this.m_propFactory;
    }

    public OwCMISObjectClassFactory getObjectClassFactory() throws OwException {
        if (this.m_objectClassFactory == null) {
            OwCMISPropertyClassFactory propertyClassFactory = this.getPropertyClassFactory();
            this.m_objectClassFactory = this.createObjectClassFactory(propertyClassFactory);
            this.m_objectClassFactory.setPreferredPropertyOrder(this.getNetworkConfiguration().getPreferedPropertyOrder());
        }
        return this.m_objectClassFactory;
    }

    public OwSearchTemplate createSearchTemplate(OwObject obj_p) throws OwException {
        try {
            return new OwStandardSearchTemplate(this.getContext(), obj_p);
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)("OwCMISNetwork.createSearchTemplate():Could not instantiate search template: " + e.getMessage()), (Throwable)e);
            throw new OwServerException(this.getContext().localize("ecmimpl.cmis.OwCMISNetwork.search.template.error", "Search template error!"), (Throwable)e);
        }
    }

    protected OwCMISCSQLCProcessor factorySearchNodeSQLProcessor() throws OwException {
        OwSQLEntitiesResolver resolver = this.createSQLEntitiesResolver();
        String pClass = this.getNetworkConfiguration().getConfigNode().getSafeTextValue(CONF_NODE_CSQLCPROCESSOR, null);
        if (pClass != null && !"".equals(pClass)) {
            try {
                Class<?> clazz = Class.forName(pClass);
                Constructor<?> constructor = clazz.getConstructor(OwSQLEntitiesResolver.class);
                return (OwCMISCSQLCProcessor)((Object)constructor.newInstance(resolver));
            }
            catch (SecurityException e) {
                LOG.error((Object)("SecurityManager restrict the instantiation of type " + pClass + "!"), (Throwable)e);
                throw new OwServerException(this.getContext().localize1("ecmimpl.cmis.OwCMISNetwork.factorySQLProc.securityEx", "Instantiation of type %1 is restricted by security.", pClass), (Throwable)e);
            }
            catch (InstantiationException e) {
                LOG.error((Object)("Cannot Instantiate the defined class " + pClass), (Throwable)e);
                throw new OwConfigurationException(this.getContext().localize1("ecmimpl.cmis.OwCMISNetwork.factorySQLProc.instanceEx", "The defined class %1 is not allowed to be instantiated.", pClass), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.fatal((Object)("Cannot Instantiate defined class " + pClass + " because it is not accessible."), (Throwable)e);
                throw new OwServerException(this.getContext().localize1("ecmimpl.cmis.OwCMISNetwork.factorySQLProc.illegalAccessEx", "The default constructor of class %1 is not accessible or does not exist.", pClass), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)("The class " + pClass + " could not be found by current ClassLoader."), (Throwable)e);
                throw new OwConfigurationException(this.getContext().localize1("ecmimpl.cmis.OwCMISNetwork.factorySQLProc.classNotFoundEx", "The defined class %1 could not be found.", pClass), (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                LOG.error((Object)("The class " + pClass + " does not contain a Constructor(OwSQLEntitiesResolver.class)."), (Throwable)e);
                throw new OwConfigurationException(this.getContext().localize1("ecmimpl.cmis.OwCMISNetwork.factorySQLProc.missingConstructor", "The defined class %1 miss a Constructor(OwSQLEntitiesResolver.class).", pClass), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                LOG.fatal((Object)"Provided entieties resolver is not implementing com.wewebu.ow.csqlc.OwSQLEntitiesResolver", (Throwable)e);
                throw new OwServerException(this.getContext().localize("ecmimpl.cmis.OwCMISNetwork.factorySQLProc.invalidResolver", "The defined the provided resolver does not implement OwSQLEntitiesResolver.class)."), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.error((Object)("Creation of CSQLCProcessor (" + pClass + ") failed."), (Throwable)e);
                throw new OwConfigurationException(this.getContext().localize1("ecmimpl.cmis.OwCMISNetwork.factorySQLProc.instanceFailed", "The defined SQLProcessor %1 could not be instantiated.", pClass), (Throwable)e);
            }
        }
        return new OwCMISCSQLCProcessor(resolver);
    }

    protected OwSQLEntitiesResolver createSQLEntitiesResolver() throws OwException {
        return new OwCMISSQLStandardEntitiesResolver(this, this.externalEntitiesResolver);
    }

    public OwCMISPropertyClass getPropertyClass(String cmisPropertyName_p, String resourceID_p) throws OwException {
        OwCMISResource resource = this.getResource(resourceID_p);
        OwCMISObjectModel objectModel = resource.getObjectModel();
        return objectModel.getPropertyClass(cmisPropertyName_p);
    }

    public OwCMISObject createCMISObject(CmisObjectType object_p, OwCMISResource resource_p) throws OwException {
        return this.createCMISObject(object_p, resource_p, this.getNetworkConfiguration().isPreservedVersion());
    }

    public OwCMISObject createCMISObject(CmisObjectType object_p, OwCMISResource resource_p, boolean preserveVersion_p) throws OwException {
        String objectTypeId = OwCMISPropertyNames.OBJECT_TYPE_ID.getIdValue(object_p);
        if (objectTypeId != null) {
            OwCMISObjectClass objectClass = this.getObjectClass(objectTypeId, resource_p);
            if (objectClass.getType() == 4097) {
                return objectClass.createCMISObject(this, object_p, preserveVersion_p);
            }
            if (objectClass.getType() == 8193) {
                String className = objectClass.getClassName();
                OwSemiVirtualRecordClass virtualFolderEntry = this.semivirtualFolderForObjectClass(className);
                if (null != virtualFolderEntry) {
                    return new OwCMISSemiVirtualFolderObject(this, resource_p.getObjectModel(), object_p, virtualFolderEntry);
                }
                return objectClass.createCMISObject(this, object_p, preserveVersion_p);
            }
            LOG.error((Object)("OwCMISNetwork.createOwCMISObject():Could not create object!Creation of other types than folder and document currently not supported! Got object type " + objectClass.getType()));
            throw new OwNotSupportedException(this.getContext().localize("ecmimpl.cmis.OwCMISNetwork.create.object.error", "Could not create object!"));
        }
        String msg = "Could not create OwCMISObject : both base type ID and object type ID are missing from the given CMIS object!";
        LOG.error((Object)("OwCMISNetwork.createOwCMISObject()" + msg));
        throw new OwInvalidOperationException(this.getContext().localize("ecmimpl.cmis.OwCMISNetwork.create.object.error", "Could not create object! Missing property: " + OwCMISPropertyNames.OBJECT_TYPE_ID.getId()));
    }

    protected OwSemiVirtualRecordClass semivirtualFolderForObjectClass(String className_p) throws OwConfigurationException, OwException {
        OwManagedSemiVirtualRecordConfiguration virtualConfiguration = this.getManagedVirtualConfiguration();
        OwSemiVirtualRecordClass virtualFolderEntry = virtualConfiguration.semiVirtualFolderForObjectClass(className_p, this.m_rolemanager);
        return virtualFolderEntry;
    }

    protected OwManagedSemiVirtualRecordConfiguration getManagedVirtualConfiguration() throws OwConfigurationException {
        if (null == this.managedVirtualConfiguration) {
            OwXMLUtil ecmAdapterConfig = this.getNetworkConfiguration().getConfigNode();
            this.managedVirtualConfiguration = new OwManagedSemiVirtualRecordConfiguration(ecmAdapterConfig);
        }
        return this.managedVirtualConfiguration;
    }

    public OwCMISDMSIDDecoder getDMSIDDecoder() {
        OwCMISNetworkConfiguration configuration = this.getNetworkConfiguration();
        return configuration.getDMSIDDecoder();
    }

    public OwObject createVirtualFolder(Node xmlVirtualFolderDescriptionNode_p, String strName_p, String strDmsIDPart_p) throws OwException {
        return this.virtualFolderFactory.createVirtualFolder(xmlVirtualFolderDescriptionNode_p, strName_p, strDmsIDPart_p);
    }

    protected OwStandardSearchSpecialNodeOperator getSpecialNodeOperator() {
        return new OwStandardSearchSpecialNodeOperator();
    }

    public OwCMISNetworkConfiguration getNetworkConfiguration() {
        return this.m_networkConfigurtaion;
    }

    protected OwCMISObjectClassFactory createObjectClassFactory(OwCMISPropertyClassFactory propFactory_p) {
        return new OwCMISStandardObjectClassFactory(propFactory_p);
    }

    @Override
    public void initLoginMap(HashMap<String, String> loginMap_p) throws OwException {
    }
}

