/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis;

import com.wewebu.ow.server.ecmimpl.cmis.OwCMISDMSIDDecoder;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISPreferredPropertyTypeCfg;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISStandardDMSIDDecoder;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.util.OwCMISIDDMSIDConverter;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.util.OwNetworkConfiguration;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class OwCMISNetworkConfiguration
extends OwNetworkConfiguration {
    private static final Logger LOG = OwLog.getLogger(OwCMISNetworkConfiguration.class);
    public static final String EL_DEFAULTVERSIONHANDLING = "DefaultVersionHandling";
    public static final String EL_PROPERTY_ORDER = "PreferedPropertyOrder";
    public static final String EL_ID_DMSID_CONVERTER_CLASS = "IDDMSIDConverterClass";
    private Map<String, String> versionHandling;
    private static final String FOLDERCHILDREN_CONTEXT = "FolderChildren";
    private static final String NORMALIZE_VERSION = "normalize";
    private static final String PRESERVE_VERSION = "preserve";
    private Boolean preservVersion;
    private OwCMISPreferredPropertyTypeCfg preferredPropertyTypeCfg;
    private Map<String, OwCMISIDDMSIDConverter> idDMSIDConverters = new HashMap<String, OwCMISIDDMSIDConverter>();
    private OwCMISDMSIDDecoder dmsidDecoder;

    public OwCMISNetworkConfiguration(OwXMLUtil config_p) {
        super(config_p);
    }

    public synchronized Map<String, String> getDefaultVersionHandling() {
        if (this.versionHandling == null) {
            OwXMLUtil configNode = this.getConfigNode();
            this.versionHandling = new HashMap<String, String>();
            List contexts = configNode.getSafeNodeList(EL_DEFAULTVERSIONHANDLING);
            for (Node context : contexts) {
                this.versionHandling.put(context.getNodeName(), context.getTextContent());
            }
        }
        return this.versionHandling;
    }

    public String getDefaultVersionHandling(String context_p) {
        Map<String, String> versionHandligMap = this.getDefaultVersionHandling();
        return versionHandligMap.get(context_p);
    }

    public boolean isPreservedVersion() {
        if (this.preservVersion == null) {
            String folderChildrenVersionHandling = this.getDefaultVersionHandling(FOLDERCHILDREN_CONTEXT);
            if (LOG.isDebugEnabled()) {
                if (folderChildrenVersionHandling == null) {
                    LOG.debug((Object)"No default version hanling configured for FolderChildren");
                } else if (!NORMALIZE_VERSION.equalsIgnoreCase(folderChildrenVersionHandling) && !PRESERVE_VERSION.equals(folderChildrenVersionHandling)) {
                    LOG.debug((Object)("Invalid version hanling configured for FolderChildren : " + folderChildrenVersionHandling));
                }
            }
            this.preservVersion = NORMALIZE_VERSION.equalsIgnoreCase(folderChildrenVersionHandling) ? Boolean.FALSE : Boolean.TRUE;
        }
        return this.preservVersion;
    }

    public OwXMLUtil getBpmNode() throws OwConfigurationException {
        OwXMLUtil result = null;
        try {
            result = this.getConfigNode().getSubUtil("BPM");
        }
        catch (Exception e) {
            throw new OwConfigurationException("Could not get the BPM configuration!", (Throwable)e);
        }
        if (null == result) {
            throw new OwConfigurationException("Could not get the BPM configuration!");
        }
        return result;
    }

    public OwCMISPreferredPropertyTypeCfg getPreferredPropertyTypeCfg() {
        if (null == this.preferredPropertyTypeCfg) {
            this.preferredPropertyTypeCfg = new OwCMISPreferredPropertyTypeCfg(this.getConfigNode());
        }
        return this.preferredPropertyTypeCfg;
    }

    public List<String> getPreferedPropertyOrder() throws OwException {
        Node preferedOrderNode = null;
        try {
            preferedOrderNode = this.getConfigNode().getSubNode(EL_PROPERTY_ORDER);
        }
        catch (Exception e) {
            LOG.warn((Object)"OwCMISNetworkConfig.getPerferedPropertyOrder: Configuration \"PreferedPropertyOrder\" could not be read.");
        }
        if (preferedOrderNode == null) {
            return new LinkedList<String>();
        }
        try {
            return new OwStandardXMLUtil(preferedOrderNode).getSafeStringList();
        }
        catch (Exception e) {
            LOG.error((Object)"Parsing of PreferedPropertyOrder node failed", (Throwable)e);
            throw new OwServerException("Could not parse configuration of PreferedPropertyOrder", (Throwable)e);
        }
    }

    public synchronized OwCMISDMSIDDecoder getDMSIDDecoder() {
        if (this.dmsidDecoder == null) {
            this.dmsidDecoder = new OwCMISStandardDMSIDDecoder();
        }
        return this.dmsidDecoder;
    }

    public synchronized OwCMISIDDMSIDConverter getIdDMSIDConverter(String resourceID_p) throws OwException {
        OwCMISIDDMSIDConverter idDMSIDConverter = this.idDMSIDConverters.get(resourceID_p);
        if (idDMSIDConverter == null) {
            try {
                String javaClassName = this.getConfigNode().getSafeTextValue(EL_ID_DMSID_CONVERTER_CLASS, OwCMISIDDMSIDConverter.class.getName());
                Class<?> javaClass = Class.forName(javaClassName);
                Constructor<?> constructor = javaClass.getConstructor(OwCMISDMSIDDecoder.class, String.class);
                idDMSIDConverter = (OwCMISIDDMSIDConverter)constructor.newInstance(this.getDMSIDDecoder(), resourceID_p);
                this.idDMSIDConverters.put(resourceID_p, idDMSIDConverter);
            }
            catch (Exception e) {
                throw new OwConfigurationException("Error accessing the ID to DMSID converter configuration!", (Throwable)e);
            }
        }
        return idDMSIDConverter;
    }
}

