/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis;

import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClass;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OwCMISPreferredPropertyTypeCfg {
    private static final Logger LOG = OwLog.getLogger(OwCMISPreferredPropertyTypeCfg.class);
    private static final String ATT_TYPE = "type";
    private static final String PROPERTY_TYPE_USER = "user";
    private static final String PROPERTY_TYPE_SYSTEM = "system";
    private Map<String, PropertyType> preferredPropertyTypeMap = new HashMap<String, PropertyType>();

    public OwCMISPreferredPropertyTypeCfg(OwXMLUtil configNode) {
        List properties = configNode.getSafeNodeList("PreferredPropertyType");
        for (Object object : properties) {
            Element propDefElem = (Element)object;
            String propType = OwXMLDOMUtil.getSafeStringAttributeValue((Node)propDefElem, (String)ATT_TYPE, null);
            String propName = OwXMLDOMUtil.getElementText((Element)propDefElem);
            if (propName == null || propType == null) continue;
            propType = propType.trim();
            propName = propName.trim();
            PropertyType propTypeValue = null;
            if (propType.equalsIgnoreCase(PROPERTY_TYPE_USER)) {
                propTypeValue = PropertyType.USER;
            } else if (propType.equalsIgnoreCase(PROPERTY_TYPE_SYSTEM)) {
                propTypeValue = PropertyType.SYSTEM;
            } else {
                LOG.error((Object)String.format("The value '%s' for the '%s' attribute is invalid.", propType, ATT_TYPE));
            }
            this.preferredPropertyTypeMap.put(propName, propTypeValue);
        }
    }

    public PropertyType getPreferredType(OwCMISPropertyClass propertyClass) throws OwException {
        PropertyType preferredType = this.getPreferredType(propertyClass.getNonQualifiedName(), propertyClass.getObjectClass());
        if (null == preferredType) {
            preferredType = PropertyType.UNSET;
        }
        this.preferredPropertyTypeMap.put(propertyClass.getFullQualifiedName(), preferredType);
        return preferredType;
    }

    private PropertyType getPreferredType(String shortName, OwCMISObjectClass inClass) throws OwException {
        OwCMISObjectClass parentClass;
        PropertyType prefferedType = null;
        OwCMISPropertyClass property = null;
        try {
            property = inClass.getPropertyClass(shortName);
        }
        catch (OwObjectNotFoundException nfe) {
            return PropertyType.UNSET;
        }
        String longName = property.getFullQualifiedName();
        prefferedType = this.getPropertyTypeFor(longName);
        if (null == prefferedType) {
            prefferedType = this.getPropertyTypeFor(shortName);
        }
        if (null == prefferedType && null != (parentClass = inClass.getParent())) {
            prefferedType = this.getPreferredType(shortName, parentClass);
        }
        return prefferedType;
    }

    protected PropertyType getPropertyTypeFor(String propName) {
        return this.preferredPropertyTypeMap.get(propName);
    }

    public static enum PropertyType {
        SYSTEM,
        USER,
        UNSET;

    }
}

