/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis;

import com.wewebu.ow.server.ecm.OwPrivilege;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISConnection;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISExtensionPoint;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISObjectModel;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISResourceObjectModel;
import com.wewebu.ow.server.ecmimpl.cmis.alfresco.OwCMISALExtensionLibrary;
import com.wewebu.ow.server.ecmimpl.cmis.extension.OwCMISExtensionLibrary;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClassFactory;
import com.wewebu.ow.server.ecmimpl.cmis.permissions.OwCMISPrivilege;
import com.wewebu.ow.server.exceptions.OwException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisACLCapabilityType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPermissionDefinition;
import org.oasis_open.docs.ns.cmis.core._200908.CmisRepositoryCapabilitiesType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisRepositoryInfoType;
import org.oasis_open.docs.ns.cmis.messaging._200908.CmisRepositoryEntryType;

public class OwCMISResource
implements OwResource {
    private static Logger LOG = OwLog.getLogger(OwCMISResource.class);
    private CmisRepositoryEntryType repositoryEntry;
    private CmisRepositoryInfoType repositoryInfo;
    private OwCMISObjectModel objectModel;
    private OwCMISConnection cmisConnection;
    private OwCMISObjectClassFactory objectClassFactory;
    private OwCMISExtensionLibrary extensionLibrary;

    public OwCMISResource(CmisRepositoryEntryType repositoryEntryType_p, CmisRepositoryInfoType repositoryInfo_p, OwCMISConnection cmisConnection_p, OwCMISObjectClassFactory objectClassFactory_p) throws OwException {
        this.repositoryEntry = repositoryEntryType_p;
        this.repositoryInfo = repositoryInfo_p;
        this.cmisConnection = cmisConnection_p;
        this.objectClassFactory = objectClassFactory_p;
        this.extensionLibrary = this.createExtensionLibrary(this.repositoryInfo);
    }

    public OwCMISConnection getConnection() {
        return this.cmisConnection;
    }

    public synchronized OwCMISObjectModel getObjectModel() throws OwException {
        if (this.objectModel == null) {
            this.objectModel = this.createResourceObjectModel();
        }
        return this.objectModel;
    }

    protected OwCMISObjectModel createResourceObjectModel() throws OwException {
        return new OwCMISResourceObjectModel(this, this.objectClassFactory);
    }

    public String getDescription(Locale locale_p) {
        try {
            return this.getRepositoryInfo().getRepositoryDescription();
        }
        catch (OwException owEx) {
            LOG.warn((Object)"Can not request the repository service port", (Throwable)owEx);
            return "";
        }
    }

    public String getDisplayName(Locale locale_p) {
        return this.repositoryEntry.getRepositoryName();
    }

    public String getID() throws OwException {
        return this.repositoryEntry.getRepositoryId();
    }

    public synchronized CmisRepositoryInfoType getRepositoryInfo() throws OwException {
        return this.repositoryInfo;
    }

    public String getSupportedCMISVersion() throws OwException {
        return this.getRepositoryInfo().getCmisVersionSupported();
    }

    public String getCMISVendor() throws OwException {
        return this.getRepositoryInfo().getVendorName();
    }

    public String getVendorProductVersion() throws OwException {
        return this.getRepositoryInfo().getProductVersion();
    }

    public CmisRepositoryCapabilitiesType getCMISCapabilities() throws OwException {
        return this.getRepositoryInfo().getCapabilities();
    }

    public String getRepsitoryRootFolderId() throws OwException {
        return this.getRepositoryInfo().getRootFolderId();
    }

    protected OwCMISExtensionLibrary createExtensionLibrary(CmisRepositoryInfoType info_p) {
        String[] versionSplit;
        String productName = info_p.getProductName();
        String productVersion = info_p.getProductVersion();
        LOG.debug((Object)("OwCMISResource.createExtensionLibrary : resource info " + productName + " " + productVersion));
        if (productName != null && productName.contains("Alfresco") && productVersion != null && (versionSplit = productVersion.split("\\.")).length > 1) {
            try {
                int major = Integer.parseInt(versionSplit[0]);
                int minor = Integer.parseInt(versionSplit[1]);
                if (major > 3 || major == 3 && minor >= 4) {
                    LOG.debug((Object)"OwCMISResource.createExtensionLibrary : detected extensible Alfresco repository");
                    return new OwCMISALExtensionLibrary();
                }
            }
            catch (NumberFormatException e) {
                LOG.debug((Object)("Unsupported Alfresco version string : " + productVersion), (Throwable)e);
            }
        }
        LOG.debug((Object)"OwCMISResource.createExtensionLibrary : unextensible repository - null extension library");
        return null;
    }

    public <E> E getExtension(String extensionId_p, Class<E> extensionInterface_p, Object nullExtensionResult_p) {
        Object extension = null;
        if (this.extensionLibrary != null) {
            extension = this.extensionLibrary.getExtension(extensionId_p, extensionInterface_p);
        }
        Object extensionPointProxy = Proxy.newProxyInstance(extensionInterface_p.getClassLoader(), new Class[]{extensionInterface_p}, (InvocationHandler)new OwCMISExtensionPoint(extensionId_p, extensionInterface_p, extension, nullExtensionResult_p));
        return (E)extensionPointProxy;
    }

    public Map<String, OwPrivilege> getAvailablePrivileges() {
        CmisACLCapabilityType aclCapability = this.repositoryInfo.getAclCapability();
        List permissionDefinitions = aclCapability.getPermissions();
        HashMap<String, OwPrivilege> privileges = new HashMap<String, OwPrivilege>();
        for (CmisPermissionDefinition permissionDefinition : permissionDefinitions) {
            OwCMISPrivilege privilege = new OwCMISPrivilege(permissionDefinition);
            privileges.put(privilege.getName(), privilege);
        }
        return privileges;
    }

    public Map<String, OwPrivilege> getAvailablePrivileges(OwUserInfo principal_p) {
        return this.getAvailablePrivileges();
    }
}

