/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis;

import com.wewebu.ow.server.ecmimpl.cmis.OwCMISACLModel;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISConnection;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISExceptionCatcher;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISObjectModel;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISResource;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClassFactory;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClass;
import com.wewebu.ow.server.ecmimpl.cmis.version.OwCMISStandardVersionModel;
import com.wewebu.ow.server.ecmimpl.cmis.version.OwCMISVersionModel;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwString1;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisRepositoryCapabilitiesType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisRepositoryInfoType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisTypeDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.EnumBaseObjectTypeIds;
import org.oasis_open.docs.ns.cmis.messaging._200908.CmisTypeContainer;
import org.oasis_open.docs.ns.cmis.messaging._200908.CmisTypeDefinitionListType;
import org.oasis_open.docs.ns.cmis.ws._200908.CmisException;
import org.oasis_open.docs.ns.cmis.ws._200908.RepositoryServicePort;

public class OwCMISResourceObjectModel
implements OwCMISObjectModel {
    private static Logger LOG = OwLog.getLogger(OwCMISResourceObjectModel.class);
    private OwCMISObjectClassFactory objectClassFactory;
    private OwCMISResource resource;
    private Map<String, OwCMISObjectClass> objectClasses = new HashMap<String, OwCMISObjectClass>();
    private OwCMISObjectClass baseClass = null;
    private final boolean createBaseClass = true;
    private int cachedHierarchyDepth = 0;
    protected static final OwCMISACLModel MANAGED = new OwCMISACLModel(){

        @Override
        public boolean canManageACL() {
            return true;
        }
    };
    protected static final OwCMISACLModel DISCOVERED = new OwCMISACLModel(){

        @Override
        public boolean canManageACL() {
            return false;
        }
    };

    public OwCMISResourceObjectModel(OwCMISResource resource_p, OwCMISObjectClassFactory objectClassFactory_p) throws OwException {
        this.objectClassFactory = objectClassFactory_p;
        this.resource = resource_p;
        this.createTypes();
    }

    @Override
    public OwCMISObjectClass getObjectClass(String strClassName_p) throws OwException {
        if (strClassName_p == null || strClassName_p.length() == 0) {
            return this.baseClass;
        }
        OwCMISObjectClass ret = this.objectClasses.get(strClassName_p);
        if (null == ret) {
            this.createType(strClassName_p);
            ret = this.objectClasses.get(strClassName_p);
            if (null == ret) {
                LOG.error((Object)("OwCMISResourceObjectModel.getObjectClass(): Object class not found " + strClassName_p));
                throw new OwObjectNotFoundException((OwString)new OwString1("ecmimpl.cmis.OwCMISResourceObjectModel.object.class.not.found.error", "Could not find object class %1!", strClassName_p));
            }
        }
        return ret;
    }

    @Override
    public Map<String, String> getObjectClassNames(int[] types_p, boolean excludeHiddenAndNonInstantiable_p, boolean rootOnly_p, Locale locale_p) throws OwException {
        HashMap<String, String> filteredTypes = new HashMap<String, String>();
        if (rootOnly_p) {
            if (types_p != null) {
                block4: for (int type : types_p) {
                    switch (type) {
                        case 4097: {
                            OwCMISObjectClass objClass = this.getObjectClass(EnumBaseObjectTypeIds.CMIS_DOCUMENT.value());
                            filteredTypes.put(objClass.getClassName(), objClass.getDisplayName(locale_p));
                            continue block4;
                        }
                        case 8193: {
                            OwCMISObjectClass objClass = this.getObjectClass(EnumBaseObjectTypeIds.CMIS_FOLDER.value());
                            filteredTypes.put(objClass.getClassName(), objClass.getDisplayName(locale_p));
                            continue block4;
                        }
                    }
                }
            } else {
                for (EnumBaseObjectTypeIds id : EnumBaseObjectTypeIds.values()) {
                    OwCMISObjectClass objClass = this.getObjectClass(id.value());
                    filteredTypes.put(objClass.getClassName(), objClass.getDisplayName(locale_p));
                }
            }
        } else {
            this.createDescendantTypes(-1, false);
            block6: for (OwCMISObjectClass clazz : this.objectClasses.values()) {
                if (types_p != null) {
                    for (int type : types_p) {
                        if (type != clazz.getType()) continue;
                        filteredTypes.put(clazz.getClassName(), clazz.getDisplayName(locale_p));
                        continue block6;
                    }
                    continue;
                }
                filteredTypes.put(clazz.getClassName(), clazz.getDisplayName(locale_p));
            }
        }
        return filteredTypes;
    }

    @Override
    public OwCMISPropertyClass getPropertyClass(String strFullQualifiedName_p) throws OwException {
        if (strFullQualifiedName_p == null) {
            LOG.error((Object)"OwCMISResourceObjectModel.getPropertyClass(): null property class name!");
            throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISResourceObjectModel.invalid.object.model.request.error", "Invalid object model request!"));
        }
        OwCMISPropertyClass propertyClass = null;
        if (strFullQualifiedName_p.contains(".")) {
            StringTokenizer tok = new StringTokenizer(strFullQualifiedName_p, ".");
            String classToken = tok.nextToken();
            try {
                OwCMISObjectClass objClass = this.getObjectClass(classToken);
                propertyClass = objClass.getPropertyClass(strFullQualifiedName_p);
            }
            catch (OwObjectNotFoundException e) {
                throw new OwObjectNotFoundException("Property '" + strFullQualifiedName_p + "' was not found in Object class '" + classToken + "'.", (Throwable)e);
            }
        } else if (this.baseClass != null) {
            propertyClass = this.baseClass.getPropertyClass(strFullQualifiedName_p);
        }
        if (propertyClass == null) {
            LOG.debug((Object)("OwCMISResourceObjectModel.getPropertyClass(): property class not found '" + strFullQualifiedName_p + "'."));
            throw new OwObjectNotFoundException((OwString)new OwString1("ecmimpl.cmis.OwCMISResourceObjectModel.property.class.not.found.error", "No such property class %1 !", strFullQualifiedName_p));
        }
        return propertyClass;
    }

    @Override
    public OwCMISVersionModel getVersionModel() throws OwException {
        return new OwCMISStandardVersionModel();
    }

    private void createType(String typeID_p) throws OwException {
        try {
            OwCMISConnection resourceConnection = this.resource.getConnection();
            RepositoryServicePort repositoryServicePort = resourceConnection.getRepositoryServicePort();
            CmisTypeDefinitionType type = repositoryServicePort.getTypeDefinition(this.resource.getID(), typeID_p, null);
            this.createType(type);
        }
        catch (CmisException ex) {
            OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(ex);
            LOG.debug((Object)("OwCMISResourceObjectModel.createType(): Could not initialize a class description! A CMIS error occurred :  " + catcher.getLogMessage()), (Throwable)ex);
            throw catcher.toOwException(new OwString("ecmimpl.cmis.OwCMISResourceObjectModel.createType.error", "An error occurred while initialising a class description!"));
        }
    }

    private void createType(CmisTypeDefinitionType type_p) throws OwException {
        OwCMISObjectClass objectClass = this.objectClassFactory.createClass(type_p, this);
        this.objectClasses.put(objectClass.getClassName(), objectClass);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("OwCMISResourceObjectModel.createType(): #> added type " + type_p.getId()));
        }
    }

    private void createTypes() throws OwException {
        this.getClass();
        this.baseClass = this.objectClassFactory.createVirtualBaseClass(this);
        this.objectClasses.put(this.baseClass.getClassName(), this.baseClass);
        this.createDescendantTypes(2, true);
    }

    private void createDescendantTypes(int depth_p, boolean includePropertyDefinitions_p) throws OwException {
        if (this.cachedHierarchyDepth != -1 && (depth_p == -1 || depth_p > 0 && this.cachedHierarchyDepth < depth_p)) {
            try {
                OwCMISConnection resourceConnection = this.resource.getConnection();
                RepositoryServicePort repositoryServicePort = resourceConnection.getRepositoryServicePort();
                CmisTypeDefinitionListType lstBase = repositoryServicePort.getTypeChildren(this.resource.getID(), null, Boolean.TRUE, BigInteger.TEN, BigInteger.ZERO, null);
                for (CmisTypeDefinitionType baseType : lstBase.getTypes()) {
                    int serviceDepth;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("OwResources.createDescendantTypes: Basetype : " + baseType.getId()));
                    }
                    Stack<CmisTypeContainer> typeStack = new Stack<CmisTypeContainer>();
                    int n = serviceDepth = depth_p == -1 ? depth_p : depth_p - 1;
                    if (serviceDepth > 0 || serviceDepth == -1) {
                        List descendats = repositoryServicePort.getTypeDescendants(this.resource.getID(), baseType.getId(), BigInteger.valueOf(serviceDepth), Boolean.valueOf(includePropertyDefinitions_p), null);
                        typeStack.addAll(descendats);
                    }
                    CmisTypeContainer baseContainer = new CmisTypeContainer();
                    baseContainer.setType(baseType);
                    typeStack.push(baseContainer);
                    while (!typeStack.isEmpty()) {
                        List typeChildren;
                        CmisTypeContainer type = (CmisTypeContainer)typeStack.pop();
                        if (!this.objectClasses.containsKey(type.getType().getId())) {
                            this.createType(type.getType());
                        }
                        if ((typeChildren = type.getChildren()) == null) continue;
                        typeStack.addAll(typeChildren);
                    }
                }
                this.cachedHierarchyDepth = depth_p;
            }
            catch (CmisException ex) {
                OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(ex);
                LOG.error((Object)("OwCMISResourceObjectModel.createDescendantTypes(): Error occurred while initialising class description!. A CMIS error occurred :  " + catcher.getLogMessage()), (Throwable)ex);
                throw catcher.toOwException(new OwString("ecmimpl.cmis.OwCMISResourceObjectModel.createType.error", "An error occurred while initialising a class description!"));
            }
        }
    }

    @Override
    public OwCMISACLModel getACLModel() throws OwException {
        CmisRepositoryInfoType repoInfo = this.resource.getRepositoryInfo();
        CmisRepositoryCapabilitiesType repoCapabilities = repoInfo.getCapabilities();
        switch (repoCapabilities.getCapabilityACL()) {
            case MANAGE: {
                return MANAGED;
            }
            case DISCOVER: {
                return DISCOVERED;
            }
        }
        LOG.error((Object)"OwCMISResourceObjectModel.getACLModel():ACL not supported!");
        throw new OwNotSupportedException(new OwString("ecmimpl.cmis.OwCMISResourceObjectModel.acl.error", "ACL not supported !"));
    }

    @Override
    public OwCMISResource getResource() {
        return this.resource;
    }
}

