/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis;

import com.wewebu.ow.csqlc.OwSQLEntitiesResolver;
import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISExceptionCatcher;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISExternalEntitiesResolver;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISResource;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISQueryContext;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISPropertyNames;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClass;
import com.wewebu.ow.server.ecmimpl.cmis.util.OwCMISPropertiesFilter;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisObjectType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertiesType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisRepositoryInfoType;
import org.oasis_open.docs.ns.cmis.core._200908.EnumIncludeRelationships;
import org.oasis_open.docs.ns.cmis.ws._200908.CmisException;

public class OwCMISSQLStandardEntitiesResolver
implements OwSQLEntitiesResolver {
    private static final Logger LOG = OwLog.getLogger(OwCMISSQLStandardEntitiesResolver.class);
    private OwCMISNetwork network;
    private OwCMISExternalEntitiesResolver externalResolver = null;

    public OwCMISSQLStandardEntitiesResolver(OwCMISNetwork network_p) {
        this(network_p, null);
    }

    public OwCMISSQLStandardEntitiesResolver(OwCMISNetwork network_p, OwCMISExternalEntitiesResolver externalResolver_p) {
        this.network = network_p;
        this.externalResolver = externalResolver_p;
    }

    public Set<String> resolveQueryableColumnNames(String tableName_p, String resourceID_p) throws OwException {
        OwCMISResource resource = this.network.getResource(resourceID_p);
        OwCMISObjectClass objectClass = this.network.getObjectClass(tableName_p, resource);
        Map<String, String> baseMap = this.network.getObjectClassNames(new int[]{objectClass.getType()}, true, Boolean.TRUE, resource);
        OwCMISObjectClass baseObjectClass = this.network.getObjectClass(baseMap.keySet().iterator().next(), resource);
        Set<OwCMISPropertyClass> queryableProperties = baseObjectClass.getQueryablePropertyClasses(OwCMISQueryContext.SQL);
        OwCMISPropertiesFilter propertiesFilter = new OwCMISPropertiesFilter();
        propertiesFilter.addAll(OwCMISQueryContext.SQL, queryableProperties);
        if (objectClass.getType() == 4097) {
            if (!propertiesFilter.getActualNamesMap().containsKey(OwCMISPropertyNames.IS_LATEST_VERSION.getId())) {
                propertiesFilter.add(OwCMISPropertyNames.IS_LATEST_VERSION.getId());
            }
            if (!propertiesFilter.getActualNamesMap().containsKey(OwCMISPropertyNames.IS_MAJOR_VERSION.getId())) {
                propertiesFilter.add(OwCMISPropertyNames.IS_MAJOR_VERSION.getId());
            }
            if (!propertiesFilter.getActualNamesMap().containsKey(OwCMISPropertyNames.IS_VERSION_SERIES_CHECKED_OUT.getId())) {
                propertiesFilter.add(OwCMISPropertyNames.IS_VERSION_SERIES_CHECKED_OUT.getId());
            }
            if (!propertiesFilter.getActualNamesMap().containsKey(OwCMISPropertyNames.VERSION_SERIES_ID.getId())) {
                propertiesFilter.add(OwCMISPropertyNames.VERSION_SERIES_ID.getId());
            }
            if (!propertiesFilter.getActualNamesMap().containsKey(OwCMISPropertyNames.VERSION_SERIES_CHECKED_OUT_BY.getId())) {
                propertiesFilter.add(OwCMISPropertyNames.VERSION_SERIES_CHECKED_OUT_BY.getId());
            }
            if (!propertiesFilter.getActualNamesMap().containsKey(OwCMISPropertyNames.VERSION_LABEL.getId())) {
                propertiesFilter.add(OwCMISPropertyNames.VERSION_LABEL.getId());
            }
            if (!propertiesFilter.getActualNamesMap().containsKey(OwCMISPropertyNames.CONTENT_STREAM_MIME_TYPE.getId())) {
                propertiesFilter.add(OwCMISPropertyNames.CONTENT_STREAM_MIME_TYPE.getId());
            }
            if (!propertiesFilter.getActualNamesMap().containsKey(OwCMISPropertyNames.CONTENT_STREAM_ID.getId())) {
                propertiesFilter.add(OwCMISPropertyNames.CONTENT_STREAM_ID.getId());
            }
        }
        if (!propertiesFilter.getActualNamesMap().containsKey(OwCMISPropertyNames.OBJECT_ID.getId())) {
            propertiesFilter.add(OwCMISPropertyNames.OBJECT_ID.getId());
        }
        if (!propertiesFilter.getActualNamesMap().containsKey(OwCMISPropertyNames.OBJECT_TYPE_ID.getId())) {
            propertiesFilter.add(OwCMISPropertyNames.OBJECT_TYPE_ID.getId());
        }
        return propertiesFilter.getQueryNames();
    }

    public String resolveQueryTableName(String tableName_p, String resourceID_p) throws OwException {
        OwCMISResource resource = this.network.getResource(resourceID_p);
        if (OwResource.m_ObjectNamePropertyClass.getClassName().equals(tableName_p)) {
            return null;
        }
        try {
            OwCMISObjectClass objectClass = this.network.getObjectClass(tableName_p, resource);
            if (objectClass != null && objectClass.isQueryable()) {
                return objectClass.getQueryName();
            }
            return null;
        }
        catch (OwException e) {
            LOG.debug((Object)("Could not solve object class for table name " + tableName_p), (Throwable)e);
            return null;
        }
    }

    public boolean canOrderBy(String tableName_p, String columnName_p, String repositoryID_p) throws OwException {
        OwCMISPropertyClass cmisPropertyClass = this.network.getPropertyClass(columnName_p, repositoryID_p);
        return cmisPropertyClass.isOrderable();
    }

    public String resolveDefaultRepositoryID() throws OwException {
        OwCMISResource defaultResource = this.network.getDefaultResource();
        return defaultResource.getID();
    }

    public String resolveQueryFolderId(String resourceID_p, String path_p) throws OwException {
        String path = path_p;
        try {
            CmisObjectType obj;
            CmisPropertiesType properties;
            List propertiesLiveList;
            if (path_p.startsWith("/" + resourceID_p)) {
                path = path_p.substring(resourceID_p.length() + 1);
            }
            if ((propertiesLiveList = (properties = (obj = this.network.getObjectServicePort().getObjectByPath(resourceID_p, path, OwCMISPropertyNames.OBJECT_ID.getId(), Boolean.TRUE, EnumIncludeRelationships.NONE, null, Boolean.FALSE, Boolean.FALSE, null)).getProperties()).getProperty()).size() > 0) {
                return OwCMISPropertyNames.OBJECT_ID.getIdValue(obj);
            }
            LOG.error((Object)("OwCMISSQLStandardEntitiesResolver.resolveQueryFolderId():Could not retrieve the folder id for path=" + path + " in resource=" + resourceID_p));
            throw new OwInvalidOperationException(this.network.getContext().localize2("ecmimpl.cmis.OwCMISSQLStandardEntitiesResolver.resolveQueryFolderId.cmis.error", "Could not find object by path %1 in resource %2", path_p, resourceID_p));
        }
        catch (CmisException e) {
            OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e);
            LOG.error((Object)("OwCMISSQLStandardEntitiesResolver.resolveQueryFolderId():Could not find object by path " + path + " in resource " + resourceID_p + ". A CMIS error occurred :  " + catcher.getLogMessage()), (Throwable)e);
            throw catcher.toOwException(this.network.getContext().localize2("ecmimpl.cmis.OwCMISSQLStandardEntitiesResolver.resolveQueryFolderId.cmis.error", "Could not find object by path %1 in resource %2", path_p, resourceID_p));
        }
    }

    public String resolveRepositoryID(String repositoryName_p) throws OwException {
        Iterator<String> resources = this.network.getResourceIDs();
        while (resources.hasNext()) {
            String id = resources.next();
            OwCMISResource resource = this.network.getResource(id);
            CmisRepositoryInfoType info = resource.getRepositoryInfo();
            String resourceRepositoryName = info.getRepositoryName();
            if (!resourceRepositoryName.equals(repositoryName_p)) continue;
            return id;
        }
        if (this.externalResolver != null) {
            return this.externalResolver.resolveRepositoryID(repositoryName_p);
        }
        String prefix = this.network.getDMSPrefix() + "/";
        if (repositoryName_p.startsWith(prefix)) {
            return this.resolveRepositoryID(repositoryName_p.substring(prefix.length()));
        }
        LOG.warn((Object)("OwCMISSQLStandardEntitiesResolver.resolveRepositoryID(): Unknown repository, name " + repositoryName_p));
        return null;
    }

    public boolean isInternalRepositoryID(String repositoryID_p) throws OwException {
        if (repositoryID_p == null) {
            return false;
        }
        Iterator<String> iResources = this.network.getResourceIDs();
        while (iResources.hasNext()) {
            String resource = iResources.next();
            if (!resource.equals(repositoryID_p)) continue;
            return true;
        }
        return false;
    }

    public boolean isSubtable(String parentTable_p, String childTable_p, String repositoryID_p) throws OwException {
        OwCMISObjectClass child = this.network.getObjectClass(childTable_p, this.network.getResource(repositoryID_p));
        OwCMISObjectClass parent = this.network.getObjectClass(parentTable_p, this.network.getResource(repositoryID_p));
        return parent.isAssignableFrom(child);
    }

    public boolean isVersionable(String tableName_p, String repositoryID_p) throws OwException {
        return false;
    }

    public OwNetworkContext getNetworkContext() {
        return this.network.getContext();
    }

    public String resovleQueryColumnName(String tableName_p, String columnName_p, String repositoryID_p) throws OwException {
        if (this.isInternalRepositoryID(repositoryID_p)) {
            OwCMISObjectClass objClass = this.network.getObjectClass(tableName_p, this.network.getResource(repositoryID_p));
            OwCMISPropertyClass cmisPropertyClass = objClass.getPropertyClass(columnName_p);
            if (cmisPropertyClass.isQueryable(OwCMISQueryContext.SQL)) {
                String qName = cmisPropertyClass.getQueryName(OwCMISQueryContext.SQL);
                if (qName == null) {
                    return cmisPropertyClass.getNonQualifiedName();
                }
                return qName;
            }
            return null;
        }
        return columnName_p;
    }
}

