/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis;

import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.wshandler.OwCMISSecurityHandlerInterface;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.log4j.Logger;

public class OwCMISSecurityHandler
implements OwCMISSecurityHandlerInterface {
    private static final Logger LOG = OwLog.getLogger(OwCMISSecurityHandler.class);
    protected static final QName SECURITY = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security", "wsse");
    protected static final Set<QName> HEADER_SUPPORT = new HashSet<QName>();
    private String password;
    private String username;
    private Locale locale;
    private String wsi18nTimeZone;
    private TimeZone wssecTimeZone;

    public OwCMISSecurityHandler(String username_p, String password_p, Locale locale_p, TimeZone wssi18nTimeZone_p, TimeZone wssecTimeZone_p) {
        this.password = password_p;
        this.username = username_p;
        this.locale = locale_p;
        this.setWsi18nTimeZone(wssi18nTimeZone_p);
        this.wssecTimeZone = wssecTimeZone_p == null ? TimeZone.getTimeZone("UTC") : wssecTimeZone_p;
    }

    public OwCMISSecurityHandler(String username_p, String password_p) {
        this(username_p, password_p, null, TimeZone.getTimeZone("UTC"), TimeZone.getTimeZone("UTC"));
    }

    public boolean handleMessage(SOAPMessageContext messageContext_p) {
        if (((Boolean)messageContext_p.get((Object)"javax.xml.ws.handler.message.outbound")).booleanValue()) {
            try {
                SOAPMessage msg = messageContext_p.getMessage();
                SOAPEnvelope envelope = msg.getSOAPPart().getEnvelope();
                SOAPHeader soapHeader = envelope.getHeader() != null ? envelope.getHeader() : envelope.addHeader();
                this.createWssecHeader(soapHeader);
                this.createWsi18nHeader(soapHeader);
            }
            catch (Exception ex) {
                LOG.error((Object)"OwCMISSecurityHandler.handleMessage(): SOAP message handling failed!", (Throwable)ex);
                return false;
            }
        }
        return true;
    }

    public Set<QName> getHeaders() {
        return HEADER_SUPPORT;
    }

    public boolean handleFault(SOAPMessageContext context_p) {
        return true;
    }

    public void close(MessageContext context_p) {
    }

    @Override
    public void setLocale(Locale locale_p) {
        this.locale = locale_p;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setWsi18nTimeZone(TimeZone timeZone_p) {
        this.wsi18nTimeZone = timeZone_p == null ? null : this.createTimezoneString(timeZone_p);
    }

    protected String createTimezoneString(TimeZone ctz) {
        StringBuffer tz = new StringBuffer("GMT");
        tz.append(ctz.getRawOffset() < 0 ? "-" : "+");
        int min = Math.abs(ctz.getRawOffset() / 60000);
        int hour = min / 60;
        tz.append(hour < 10 ? "0" : "");
        tz.append(Integer.toString(hour));
        tz.append((min %= 60) < 10 ? "0" : "");
        tz.append(Integer.toString(min));
        return tz.toString();
    }

    @Override
    public void init(Map<String, String> arr_p) {
        if (this.password == null) {
            this.password = arr_p.get("password");
        }
        if (this.username == null) {
            this.username = arr_p.get("username");
        }
    }

    protected void createWssecHeader(SOAPHeader soapHeader_p) throws SOAPException, DatatypeConfigurationException {
        DatatypeFactory factory = DatatypeFactory.newInstance();
        GregorianCalendar now = new GregorianCalendar(this.wssecTimeZone);
        GregorianCalendar fiveMinutesLater = new GregorianCalendar(this.wssecTimeZone);
        fiveMinutesLater.add(12, 5);
        XMLGregorianCalendar xmlNow = factory.newXMLGregorianCalendar(now);
        XMLGregorianCalendar xmlFiveMinutesLater = factory.newXMLGregorianCalendar(fiveMinutesLater);
        SOAPHeaderElement headerElement = soapHeader_p.addHeaderElement(SECURITY);
        headerElement.setMustUnderstand(false);
        SOAPElement timestamp = headerElement.addChildElement(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Timestamp", "wsu"));
        timestamp.addAttribute(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id", "wsu"), "Timestamp");
        SOAPElement created = timestamp.addChildElement(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Created", "wsu"));
        created.addTextNode(xmlNow.toXMLFormat());
        SOAPElement expired = timestamp.addChildElement(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Expires", "wsu"));
        expired.addTextNode(xmlFiveMinutesLater.toXMLFormat());
        SOAPElement usernameToken = headerElement.addChildElement(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UsernameToken"));
        SOAPElement username = usernameToken.addChildElement(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Username"));
        username.addTextNode(this.username);
        SOAPElement password = usernameToken.addChildElement(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Password"));
        password.addAttribute(new QName("Type"), "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
        password.addTextNode(this.password);
    }

    protected void createWsi18nHeader(SOAPHeader soapHeader_p) throws SOAPException {
        if (this.getLocale() != null) {
            SOAPHeaderElement headerElement = soapHeader_p.addHeaderElement(new QName("http://www.w3.org/2005/09/ws-i18n", "international", "i18n"));
            headerElement.setMustUnderstand(false);
            SOAPElement locElem = headerElement.addChildElement(new QName("http://www.w3.org/2005/09/ws-i18n", "locale", "i18n"));
            locElem.addTextNode(this.getLocale().toString());
            if (this.getWsi18nTimeZone() != null) {
                SOAPElement timeElem = headerElement.addChildElement(new QName("http://www.w3.org/2005/09/ws-i18n", "tz", "i18n"));
                timeElem.addTextNode(this.getWsi18nTimeZone());
            }
        }
    }

    @Override
    @Deprecated
    public void setTimezoneString(String timeZone_p) {
        this.wsi18nTimeZone = timeZone_p;
    }

    @Override
    @Deprecated
    public String getTimezoneString() {
        return this.getWsi18nTimeZone();
    }

    @Override
    public void setWsi18nTimeZone(String timeZone_p) {
        this.wsi18nTimeZone = timeZone_p;
    }

    @Override
    public String getWsi18nTimeZone() {
        return this.wsi18nTimeZone;
    }

    protected TimeZone getWsSecTimeZone() {
        return this.wssecTimeZone;
    }

    static {
        HEADER_SUPPORT.add(SECURITY);
    }
}

