/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis;

import com.wewebu.ow.server.ecmimpl.cmis.OwCMISDMSID;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISExceptionCatcher;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISResource;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObject;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.util.OwObjectIDCodeUtil;
import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisObjectType;
import org.oasis_open.docs.ns.cmis.core._200908.EnumIncludeRelationships;
import org.oasis_open.docs.ns.cmis.ws._200908.CmisException;
import org.oasis_open.docs.ns.cmis.ws._200908.ObjectServicePort;

public class OwCMISSimpleDMSID
implements OwCMISDMSID {
    private static final Logger LOG = OwLog.getLogger(OwCMISSimpleDMSID.class);
    private String dmsPrefix;
    private String cmisID;
    private String resourceID;

    public OwCMISSimpleDMSID(String dmsPrefix_p, String resourceID_p, String cmisID_p) {
        this.dmsPrefix = dmsPrefix_p;
        this.cmisID = cmisID_p;
        this.resourceID = resourceID_p;
    }

    @Override
    public String getCMISID() {
        return this.cmisID;
    }

    @Override
    public String getDMSIDString() {
        return OwCMISSimpleDMSID.createDMSID(this.dmsPrefix, this.resourceID, this.cmisID);
    }

    @Override
    public OwCMISObject getObject(OwCMISNetwork network_p) throws OwException {
        CmisObjectType obj;
        String decCmisID = OwObjectIDCodeUtil.decode((String)this.cmisID);
        try {
            ObjectServicePort objectServicePort = network_p.getObjectServicePort();
            obj = objectServicePort.getObject(this.resourceID, decCmisID, null, Boolean.TRUE, EnumIncludeRelationships.NONE, null, Boolean.FALSE, Boolean.FALSE, null);
        }
        catch (CmisException e) {
            OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e);
            LOG.error((Object)("OwCMISSimpleDMSID.getObject(): Could not retrieve object for DMSID (" + this.getDMSIDString() + ")! A CMIS error occurred :  " + catcher.getLogMessage()), (Throwable)e);
            throw catcher.toOwException(network_p.getContext().localize("ecmimpl.cmis.OwCMISSimpleDMSID.getObject.error", "Could not retrieve object!"));
        }
        OwCMISResource resource = network_p.getResource(this.resourceID);
        return network_p.createCMISObject(obj, resource);
    }

    @Override
    public String getResourceID() {
        return this.resourceID;
    }

    public static String createDMSID(String dmsPrefix_p, String resourceID_p, String cmisID_p) {
        StringBuilder builder = new StringBuilder(dmsPrefix_p);
        builder.append(",");
        builder.append(resourceID_p);
        builder.append(",");
        if (cmisID_p.indexOf(47) > 0) {
            builder.append(OwObjectIDCodeUtil.encode((String)cmisID_p));
        } else {
            builder.append(cmisID_p);
        }
        return builder.toString();
    }
}

