/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis;

import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISUserInfo;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.mandator.OwMandator;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class OwCMISSimpleUserInfo
extends OwCMISUserInfo {
    private static final Logger LOG = OwLog.getLogger(OwCMISSimpleUserInfo.class);
    private List<OwUserInfo> defaultGroups = Arrays.asList(new OwUserInfo[0]);
    private List<String> defaultRoleNames = null;
    private OwMandator mandator;

    public OwCMISSimpleUserInfo(String name_p, OwMandator mandator_p) {
        super(name_p);
        this.mandator = mandator_p;
    }

    protected synchronized List<OwUserInfo> getDefaulfGroups() throws OwException {
        return this.defaultGroups;
    }

    protected synchronized List<String> getDefaultRoleNames() throws OwException {
        if (this.defaultRoleNames == null) {
            this.defaultRoleNames = new LinkedList<String>();
            List<OwUserInfo> defaulGroups = this.getDefaulfGroups();
            for (OwUserInfo group : defaulGroups) {
                try {
                    String roleName = group.getUserName();
                    if (this.mandator != null) {
                        roleName = this.mandator.filterRoleName(roleName);
                    }
                    this.defaultRoleNames.add(roleName);
                }
                catch (Exception e) {
                    LOG.error((Object)"OwCMISSimpleUserInfo.getDefaultRoleNames(): could not create default role names ", (Throwable)e);
                    throw new OwInvalidOperationException("Could not create default role names !", (Throwable)e);
                }
            }
            String authenticatedRole = "OW_Authenticated";
            if (this.mandator != null) {
                authenticatedRole = this.mandator.filterRoleName(authenticatedRole);
            }
            this.defaultRoleNames.add(authenticatedRole);
        }
        return this.defaultRoleNames;
    }

    public Collection<OwUserInfo> getGroups() throws OwException {
        return this.getDefaulfGroups();
    }

    public Collection<String> getRoleNames() throws OwException {
        return this.getDefaultRoleNames();
    }

    public final boolean isGroup() {
        return false;
    }

    protected OwMandator getMandator() {
        return this.mandator;
    }
}

