/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis;

import com.wewebu.ow.server.ecmimpl.cmis.OwCMISDMSID;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISDMSIDDecoder;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISSimpleDMSID;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.util.OwObjectIDCodeUtil;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwString1;
import org.apache.log4j.Logger;

public class OwCMISStandardDMSIDDecoder
implements OwCMISDMSIDDecoder {
    private static final Logger LOG = OwLog.getLogger(OwCMISStandardDMSIDDecoder.class);
    public static final String DMS_PREFIX = "cmis";

    @Override
    public String getDMSIDPrefix() {
        return DMS_PREFIX;
    }

    @Override
    public OwCMISDMSID createDMSID(String dmsid_p) throws OwException {
        String[] split = dmsid_p.split(",");
        if (split.length != 3 || !this.getDMSIDPrefix().equals(split[0])) {
            LOG.error((Object)("OwCMISStandardDMSIDDecoder.createDMSID(): Invalid DMSID = " + dmsid_p));
            throw new OwInvalidOperationException((OwString)new OwString1("ecmimpl.cmis.OwCMISStandardDMSIDDecoder.invalid.dmsid.error", "Invalid DMSID %1 !", dmsid_p));
        }
        return new OwCMISSimpleDMSID(split[0], split[1], OwObjectIDCodeUtil.decode((String)split[2]));
    }
}

