/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis;

import com.wewebu.ow.server.ao.OwVirtualFolderFactory;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwRepository;
import com.wewebu.ow.server.ecm.OwVirtualFolderObjectFactory;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISDMSIDDecoder;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class OwCMISVirtualFolderFactory
implements OwVirtualFolderFactory {
    private static final Logger LOG = OwLog.getLogger(OwCMISVirtualFolderFactory.class);
    private OwNetwork network;
    private OwCMISDMSIDDecoder dmisdDecoder;

    public OwCMISVirtualFolderFactory(OwNetwork network, OwCMISDMSIDDecoder dmisdDecoder) {
        this.network = network;
        this.dmisdDecoder = dmisdDecoder;
    }

    public OwObject createVirtualFolder(Node xmlVirtualFolderDescriptionNode_p, String strName_p, String strDmsIDPart_p) throws OwException {
        try {
            OwStandardXMLUtil description = new OwStandardXMLUtil(xmlVirtualFolderDescriptionNode_p);
            String strVirtualFolderClassName = description.getSafeTextValue("ClassName", "com.wewebu.ow.server.ecmimpl.cmis.OwCMISVirtualFolderObjectFactory");
            Class<?> virtualFolderClass = Class.forName(strVirtualFolderClassName);
            OwVirtualFolderObjectFactory retObject = (OwVirtualFolderObjectFactory)virtualFolderClass.newInstance();
            Node rootNode = description.getSubNode("root");
            String dmisdPrefix = this.dmisdDecoder.getDMSIDPrefix();
            String virtualFolderPrefix = "vf";
            retObject.init(this.network.getContext(), (OwRepository)this.network, dmisdPrefix + "," + "vf" + "," + strName_p, strName_p, rootNode);
            return retObject.getInstance(strDmsIDPart_p);
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)("OwCMISNetwork.createVirtualFolder():Could not create virtual folder named " + strName_p + " and dmisd part " + strDmsIDPart_p));
            throw new OwInvalidOperationException(this.network.getContext().localize("ecmimpl.cmis.OwCMISNetwork.create.virtual.folder.error", "Could not create virtual folder!"), (Throwable)e);
        }
    }
}

