/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.alfresco;

import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.alfresco.OwCMISALAspectRetriever;
import com.wewebu.ow.server.ecmimpl.cmis.alfresco.OwCMISALMandatoryAspectCache;
import com.wewebu.ow.server.ecmimpl.cmis.alfresco.OwCMISALUtil;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisTypeDefinitionType;

public class OwCMISALAspectsService {
    private static final Logger LOG = OwLog.getLogger(OwCMISALAspectsService.class);

    public void retrieveManadatoryAspects(OwCMISNetwork network, OwCMISObjectClass objClass) throws OwException, IOException {
        CmisTypeDefinitionType nativeType = objClass.getNativeObject();
        if (nativeType != null) {
            OwCMISALAspectRetriever retriever = this.getAspectRetriever(network);
            List<String> lst = retriever.retrieveAspectIds(network, objClass);
            List nativeAny = nativeType.getAny();
            OwCMISALMandatoryAspectCache cache = OwCMISALUtil.findFirst(nativeAny, OwCMISALMandatoryAspectCache.class);
            if (cache == null) {
                cache = new OwCMISALMandatoryAspectCache(lst);
                nativeAny.add(cache);
            } else {
                cache.getMandatoryAspectIds().clear();
                cache.getMandatoryAspectIds().addAll(lst);
            }
        } else {
            LOG.debug((Object)"OwCMISALAspectsService.retrieveManadatoryAspects: Unknown OwCMISObjectClass could not retrieve native type representation");
        }
    }

    public void ensureMandatroyAspects(OwCMISNetwork network, OwCMISObjectClass objClass) throws OwException, IOException {
        CmisTypeDefinitionType nativeType = objClass.getNativeObject();
        if (nativeType != null) {
            if (!OwCMISALAspectsService.isCacheInitialised(objClass)) {
                this.retrieveManadatoryAspects(network, objClass);
            }
        } else {
            LOG.debug((Object)"OwCMISALAspectsService.ensureMandatroyAspects: Unknown OwCMISObjectClass could not retrieve native type representation");
        }
    }

    public static boolean isCacheInitialised(OwCMISObjectClass objClass) {
        CmisTypeDefinitionType nativeType = objClass.getNativeObject();
        if (nativeType != null) {
            List lst = nativeType.getAny();
            OwCMISALMandatoryAspectCache cache = OwCMISALUtil.findFirst(lst, OwCMISALMandatoryAspectCache.class);
            return cache != null;
        }
        LOG.debug((Object)"OwCMISALAspectsService.isCacheInitialised: Unknown OwCMISObjectClass could not retrieve native type representation");
        return false;
    }

    protected OwCMISALAspectRetriever getAspectRetriever(OwCMISNetwork network) throws OwException {
        OwCMISALAspectRetriever instance = null;
        String retClass = network.getNetworkConfiguration().getConfigNode().getSafeTextValue("AspectRetrieverClass", "com.wewebu.ow.server.ecmimpl.cmis.alfresco.OwCMISALBasicAspectRetriever");
        try {
            Class<?> clazz = Class.forName(retClass);
            instance = (OwCMISALAspectRetriever)clazz.newInstance();
        }
        catch (InstantiationException ex) {
            LOG.error((Object)("Could not instantiate OwCMISALAspectRetriever: " + retClass), (Throwable)ex);
            throw new OwConfigurationException("Instantiation failed for class = " + retClass, (Throwable)ex);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)("Class cannot be accessed, class = " + retClass), (Throwable)e);
            throw new OwConfigurationException("Instantiation failure (not accssible) for class = " + retClass, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            LOG.fatal((Object)"Could not find specified class for OwCMISALAspectRetriever", (Throwable)e);
            throw new OwConfigurationException("Could not find class = " + retClass, (Throwable)e);
        }
        return instance;
    }
}

