/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.alfresco;

import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.alfresco.OwCMISALAspectRetriever;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class OwCMISALBasicAspectRetriever
implements OwCMISALAspectRetriever {
    private static final Logger LOG = OwLog.getLogger(OwCMISALBasicAspectRetriever.class);

    @Override
    public List<String> retrieveAspectIds(OwCMISNetwork network, OwCMISObjectClass clazz) throws IOException, OwException {
        URL url = this.getURL(network, clazz.getClassName());
        URLConnection uc = url.openConnection();
        uc.setRequestProperty("Authorization", this.createAuthValue(network));
        return this.processInputStream(uc.getInputStream(), network);
    }

    protected URL getURL(OwCMISNetwork network, String classId) throws MalformedURLException, OwException {
        String strURL = network.getNetworkConfiguration().getConfigNode().getSafeTextValue("AspectRetrieveUrl", null);
        if (strURL == null) {
            URL repo = network.getNetworkConfiguration().getConfigNode().getURLFromNode("WSDLRepository");
            StringBuilder str = new StringBuilder(repo.getProtocol());
            str.append("://").append(repo.getAuthority());
            strURL = repo.getPath();
            strURL = strURL.substring(0, strURL.indexOf(47, 1));
            str.append(strURL);
            str.append("/service/api/classes/");
            strURL = str.toString();
        }
        return new URL(strURL + this.getRequestTypeId(network, classId));
    }

    protected String getRequestTypeId(OwCMISNetwork network, String classId) {
        String typeId;
        if (classId.startsWith("cmis:")) {
            switch (classId.charAt(5)) {
                case 'D': 
                case 'd': {
                    typeId = "cm:content";
                    break;
                }
                case 'F': 
                case 'f': {
                    typeId = "cm:folder";
                    break;
                }
                default: {
                    typeId = "cm:cmobject";
                    break;
                }
            }
        } else {
            typeId = classId.substring(classId.indexOf(58) + 1);
        }
        return typeId.replace(':', '_');
    }

    protected String createAuthValue(OwCMISNetwork network) throws OwException {
        StringBuilder authValue = new StringBuilder(network.getCredentials().getAuthInfo("USER"));
        authValue.append(':');
        authValue.append(network.getCredentials().getAuthInfo("Password"));
        return "Basic " + new String(Base64.encodeBase64((byte[])authValue.toString().getBytes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> processInputStream(InputStream stream, OwCMISNetwork network) throws IOException, OwException {
        LinkedList<String> lst = new LinkedList<String>();
        StringBuilder builder = new StringBuilder();
        InputStreamReader reader = null;
        try {
            int read;
            reader = new InputStreamReader(new BufferedInputStream(stream));
            char[] buffer = new char[256];
            while ((read = reader.read(buffer)) >= 0) {
                builder.append(buffer, 0, read);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        JSONParser parser = new JSONParser();
        Object obj = null;
        try {
            obj = parser.parse(builder.toString());
        }
        catch (ParseException e) {
            throw new OwInvalidOperationException(network.getContext().localize("OwCMISALBasicAspectRetriever.json.parse.ex", "Could not parse delivered JSON string"), (Throwable)e);
        }
        JSONObject jsonObj = (JSONObject)obj;
        jsonObj = (JSONObject)jsonObj.get((Object)"defaultAspects");
        Iterator it = jsonObj.keySet().iterator();
        while (it.hasNext()) {
            String name = it.next().toString();
            if (!name.startsWith("sys") && !name.startsWith("cm")) {
                lst.add("P:" + name);
                continue;
            }
            LOG.debug((Object)("OwCMISALBasicAspectRetriever.processInputStream : Aspect " + name + " filtered out."));
        }
        return lst;
    }
}

