/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.alfresco;

import com.wewebu.ow.csqlc.ast.OwColumnQualifier;
import com.wewebu.ow.csqlc.ast.OwQueryStatement;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISResource;
import com.wewebu.ow.server.ecmimpl.cmis.alfresco.OwCMISALAspectsService;
import com.wewebu.ow.server.ecmimpl.cmis.alfresco.OwCMISALCacheInfo;
import com.wewebu.ow.server.ecmimpl.cmis.alfresco.OwCMISALObjectClass;
import com.wewebu.ow.server.ecmimpl.cmis.extension.OwCMISNetworkExtension;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.exceptions.OwException;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.alfresco.Aspects;
import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisObjectType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertiesType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisProperty;

public class OwCMISALNetworkExtension
implements OwCMISNetworkExtension {
    private static final Logger LOG = OwLog.getLogger(OwCMISALNetworkExtension.class);

    @Override
    public CmisObjectType tweakSearchResult(CmisObjectType object_p, OwQueryStatement statement_p, OwCMISNetwork network_p) throws OwException {
        Map nQualifiers = statement_p.getNormalizedQualifiers();
        if (nQualifiers.size() > 1) {
            String mainType;
            OwCMISObjectClass mainClass;
            OwColumnQualifier mainTable = statement_p.getMainTableQualifier();
            String resourceID = statement_p.getTargetRepositoryID();
            OwCMISResource resource = network_p.getResource(resourceID);
            OwCMISObjectClass policyClass = network_p.getObjectClass("cmis:policy", resource);
            if (policyClass.isAssignableFrom(mainClass = network_p.getObjectClass(mainType = mainTable.getTargetObjectType(), resource))) {
                return object_p;
            }
            CmisPropertiesType properties = object_p.getProperties();
            List propertyList = properties.getProperty();
            LinkedList<CmisProperty> aspectProperties = new LinkedList<CmisProperty>();
            HashSet<String> queriedAspects = new HashSet<String>();
            for (CmisProperty property : propertyList) {
                String id = property.getPropertyDefinitionId();
                int dotIndex = id.indexOf(46);
                if (dotIndex <= -1 || dotIndex + 1 >= id.length()) continue;
                String qString = id.substring(0, dotIndex);
                String realPropertyId = id.substring(dotIndex + 1, id.length());
                property.setPropertyDefinitionId(realPropertyId);
                OwColumnQualifier qualifiers = (OwColumnQualifier)nQualifiers.get(qString);
                String qTypeString = qualifiers.getTargetObjectType();
                OwCMISObjectClass qType = network_p.getObjectClass(qTypeString, resource);
                if (!policyClass.isAssignableFrom(qType)) continue;
                aspectProperties.add(property);
                queriedAspects.add(qTypeString);
            }
            Aspects aspects = new Aspects();
            CmisPropertiesType aspectPropertiesType = new CmisPropertiesType();
            aspects.setProperties(aspectPropertiesType);
            aspectPropertiesType.getProperty().addAll(aspectProperties);
            aspects.getAppliedAspects().addAll(queriedAspects);
            List any = properties.getAny();
            any.add(aspects);
            any.add(new OwCMISALCacheInfo(false));
        }
        return object_p;
    }

    @Override
    public OwCMISObjectClass prepareObjectClass(OwCMISObjectClass class_p, OwCMISNetwork network_p) throws OwException {
        return this.prepareForCreation(new OwCMISALObjectClass(class_p, network_p), network_p);
    }

    @Override
    public OwCMISObjectClass prepareForCreation(OwCMISObjectClass objectClass_p, OwCMISNetwork network_p) throws OwException {
        if (!OwCMISALAspectsService.isCacheInitialised(objectClass_p)) {
            OwCMISALAspectsService service = new OwCMISALAspectsService();
            try {
                service.ensureMandatroyAspects(network_p, objectClass_p);
            }
            catch (IOException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Problem requesting Aspect definitions (OwCMISALNetworkExtension)", (Throwable)e);
                }
                LOG.warn((Object)("Problem requesting Aspect definitions (OwCMISALNetworkExtension), exception message = " + e.getMessage()));
            }
        }
        return objectClass_p;
    }
}

