/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.alfresco;

import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwPermissionCollection;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISObjectModel;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISResource;
import com.wewebu.ow.server.ecmimpl.cmis.alfresco.OwCMISALMandatoryAspectCache;
import com.wewebu.ow.server.ecmimpl.cmis.alfresco.OwCMISALUtil;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISQueryContext;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObject;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClass;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwString3;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisObjectType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisTypeDefinitionType;

public class OwCMISALObjectClass
implements OwCMISObjectClass {
    private static final Logger LOG = OwLog.getLogger(OwCMISALObjectClass.class);
    private OwCMISNetwork network;
    private OwCMISObjectClass primaryClass;
    private List<String> preferredPropertyOrder;

    public OwCMISALObjectClass(OwCMISObjectClass primaryClass, OwCMISNetwork network) {
        this.network = network;
        this.primaryClass = primaryClass;
    }

    public List<String> getAppliedAspectTypes() throws OwException {
        OwCMISALMandatoryAspectCache cache = OwCMISALUtil.findFirst(this.getNativeObject().getAny(), OwCMISALMandatoryAspectCache.class);
        return cache == null ? new LinkedList() : cache.getMandatoryAspectIds();
    }

    public boolean isAspectApplied(String aspectName_p) throws OwException {
        List<String> aspectTypes = this.getAppliedAspectTypes();
        return aspectTypes.contains(aspectName_p);
    }

    @Override
    public boolean canCreateNewObject() throws OwException {
        return this.getPrimaryClass().canCreateNewObject();
    }

    @Override
    public OwCMISObject createCMISObject(OwCMISNetwork network_p, CmisObjectType object_p, boolean preserveVersion_p) throws OwException {
        return this.getPrimaryClass().createCMISObject(network_p, object_p, preserveVersion_p);
    }

    @Override
    public String createNewObject(OwCMISNetwork network_p, boolean promote_p, Object mode_p, OwResource resource_p, OwPropertyCollection properties_p, OwPermissionCollection permissions_p, OwContentCollection content_p, OwObject parent_p, String strMimeType_p, String strMimeParameter_p, boolean keepCheckedOut_p) throws OwException {
        String id = this.getPrimaryClass().createNewObject(network_p, promote_p, mode_p, resource_p, properties_p, permissions_p, content_p, parent_p, strMimeType_p, strMimeParameter_p, keepCheckedOut_p);
        return id;
    }

    public Map getChildNames(OwNetwork network_p, boolean excludeHiddenAndNonInstantiable_p) throws Exception {
        return this.getPrimaryClass().getChildNames(network_p, excludeHiddenAndNonInstantiable_p);
    }

    public List getChilds(OwNetwork network_p, boolean excludeHiddenAndNonInstantiable_p) throws Exception {
        List base = this.getPrimaryClass().getChilds(network_p, excludeHiddenAndNonInstantiable_p);
        if (base == null || base.isEmpty()) {
            return base;
        }
        LinkedList<OwCMISALObjectClass> lst = new LinkedList<OwCMISALObjectClass>();
        for (OwCMISObjectClass toWrap : base) {
            lst.add(new OwCMISALObjectClass(toWrap, this.getNetwork()));
        }
        return lst;
    }

    public String getClassName() {
        return this.getPrimaryClass().getClassName();
    }

    public String getDescription(Locale locale_p) {
        return this.getPrimaryClass().getDescription(locale_p);
    }

    public String getDisplayName(Locale locale_p) {
        return this.getPrimaryClass().getDisplayName(locale_p);
    }

    @Override
    public String getMimetype() {
        return this.getPrimaryClass().getMimetype();
    }

    public List getModes(int operation_p) throws Exception {
        return this.getPrimaryClass().getModes(operation_p);
    }

    @Override
    public String getNamePropertyName() throws OwException {
        return this.getPrimaryClass().getNamePropertyName();
    }

    @Override
    public OwCMISObjectClass getParent() throws OwException {
        return this.getPrimaryClass().getParent();
    }

    @Override
    public OwCMISPropertyClass getPropertyClass(String propertyClassName_p) throws OwException {
        try {
            return this.getPrimaryClass().getPropertyClass(propertyClassName_p);
        }
        catch (OwObjectNotFoundException e1) {
            OwCMISResource resource = this.getResource();
            OwCMISObjectModel objectModel = resource.getObjectModel();
            List<String> appliedAspects = this.getAppliedAspectTypes();
            for (String aspect : appliedAspects) {
                OwCMISObjectClass aspectClass = objectModel.getObjectClass(aspect);
                try {
                    return aspectClass.getPropertyClass(propertyClassName_p);
                }
                catch (OwObjectNotFoundException e2) {
                }
            }
            LOG.debug((Object)("OwCMISALObjectClass.getPropertyClass : no such property " + propertyClassName_p + " in primary class " + this.getClassName() + " or applied aspects " + appliedAspects));
            throw new OwObjectNotFoundException((OwString)new OwString3("ecmimpl.cmis.OwCMISAlfrescoObjectClass.invalid.property.class.tree", "Property %1 is neither defined in object class %2 nor in the applied Alfresco aspects %3", propertyClassName_p, this.getClassName(), appliedAspects.toString()));
        }
    }

    @Override
    public Map<String, OwCMISPropertyClass> getPropertyClasses() throws OwException {
        HashMap<String, OwCMISPropertyClass> propertyClasses = new HashMap<String, OwCMISPropertyClass>(this.getPrimaryClass().getPropertyClasses());
        Map<String, OwCMISPropertyClass> aspectProps = this.getAllAspectProperties();
        if (!aspectProps.isEmpty()) {
            aspectProps.remove("cmis:policy.cmis:name");
            propertyClasses.putAll(aspectProps);
        }
        return propertyClasses;
    }

    @Override
    public Collection<String> getPropertyClassNames() throws OwException {
        OwCMISObjectClass myPrimaryClass = this.getPrimaryClass();
        Collection<String> propertyClassNames = myPrimaryClass.getPropertyClassNames();
        LinkedList<String> propertyClasses = new LinkedList<String>(propertyClassNames);
        Map<String, OwCMISPropertyClass> aspectProps = this.getAllAspectProperties();
        if (!aspectProps.isEmpty()) {
            aspectProps.remove("cmis:policy.cmis:name");
            propertyClasses.addAll(aspectProps.keySet());
        }
        return this.reorderProperties(propertyClasses);
    }

    @Override
    public Set<OwCMISPropertyClass> getQueryablePropertyClasses(OwCMISQueryContext context_p) throws OwException {
        return this.getPrimaryClass().getQueryablePropertyClasses(context_p);
    }

    @Override
    public String getQueryName() {
        return this.getPrimaryClass().getQueryName();
    }

    @Override
    public OwCMISResource getResource() {
        return this.getPrimaryClass().getResource();
    }

    public int getType() {
        return this.getPrimaryClass().getType();
    }

    public boolean hasChilds(OwNetwork network_p, boolean excludeHiddenAndNonInstantiable_p, int context_p) throws Exception {
        return this.getPrimaryClass().hasChilds(network_p, excludeHiddenAndNonInstantiable_p, context_p);
    }

    public boolean hasVersionSeries() throws Exception {
        return this.getPrimaryClass().hasVersionSeries();
    }

    @Override
    public boolean isContentRequired() throws OwException {
        return this.getPrimaryClass().isContentRequired();
    }

    public boolean isHidden() throws Exception {
        return this.getPrimaryClass().isHidden();
    }

    @Override
    public boolean isQueryable() {
        return this.getPrimaryClass().isQueryable();
    }

    @Override
    public void subclassedBy(OwCMISObjectClass subclass_p) throws OwInvalidOperationException {
        this.getPrimaryClass().subclassedBy(subclass_p);
    }

    @Override
    public boolean isAssignableFrom(OwCMISObjectClass class_p) throws OwException {
        return this.getPrimaryClass().isAssignableFrom(class_p);
    }

    @Override
    public CmisTypeDefinitionType getNativeObject() {
        return this.getPrimaryClass().getNativeObject();
    }

    protected OwCMISObjectClass getPrimaryClass() {
        return this.primaryClass;
    }

    protected OwCMISNetwork getNetwork() {
        return this.network;
    }

    protected Map<String, OwCMISPropertyClass> getAllAspectProperties() throws OwException {
        List<String> appliedAspects = this.getAppliedAspectTypes();
        Map<String, OwCMISPropertyClass> aspectProps = null;
        for (String appliedAspect : appliedAspects) {
            if (aspectProps == null) {
                aspectProps = this.getAspectProperties(appliedAspect);
                continue;
            }
            aspectProps.putAll(this.getAspectProperties(appliedAspect));
        }
        return aspectProps == null ? new LinkedHashMap<String, OwCMISPropertyClass>() : aspectProps;
    }

    protected Map<String, OwCMISPropertyClass> getAspectProperties(String aspectClassId_p) throws OwException {
        OwCMISResource resource = this.getResource();
        OwCMISObjectModel objectModel = resource.getObjectModel();
        OwCMISObjectClass aspDef = objectModel.getObjectClass(aspectClassId_p);
        LinkedHashMap<String, OwCMISPropertyClass> props = new LinkedHashMap<String, OwCMISPropertyClass>();
        for (Map.Entry<String, OwCMISPropertyClass> entry : aspDef.getPropertyClasses().entrySet()) {
            try {
                if (entry.getValue().isSystemProperty()) continue;
                props.put(entry.getKey(), entry.getValue());
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("PropertyClass " + entry.getKey() + " skiped caused by error"), (Throwable)e);
            }
        }
        return props;
    }

    public List<String> getPreferredPropertyOrder() {
        if (this.preferredPropertyOrder == null) {
            this.preferredPropertyOrder = new LinkedList<String>();
            try {
                this.preferredPropertyOrder = this.network.getNetworkConfiguration().getPreferedPropertyOrder();
            }
            catch (OwException e) {
                LOG.warn((Object)"OwCMISNetworkConfig.getPerferedPropertyOrder: Configuration \"PreferedPropertyOrder\" could not be read.");
            }
        }
        return this.preferredPropertyOrder;
    }

    protected Collection<String> reorderProperties(Collection<String> allProperties_p) throws OwException {
        LinkedList<String> orderedProperties = new LinkedList<String>();
        for (String temp : this.getPreferredPropertyOrder()) {
            if (!allProperties_p.contains(temp)) continue;
            orderedProperties.add(temp);
        }
        orderedProperties.addAll(allProperties_p);
        return orderedProperties;
    }
}

