/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.alfresco;

import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISExceptionCatcher;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.alfresco.OwCMISALCacheInfo;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISPropertyNames;
import com.wewebu.ow.server.exceptions.OwException;
import java.util.List;
import org.alfresco.Aspects;
import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisObjectType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertiesType;
import org.oasis_open.docs.ns.cmis.ws._200908.CmisException;
import org.oasis_open.docs.ns.cmis.ws._200908.ObjectServicePort;

public class OwCMISALUtil {
    private static final Logger LOG = OwLog.getLogger(OwCMISALUtil.class);

    public static <T> T findFirst(List<Object> objectList_p, Class<T> class_p) {
        for (Object object : objectList_p) {
            if (object == null || !class_p.isAssignableFrom(object.getClass())) continue;
            return (T)object;
        }
        return null;
    }

    public static synchronized void cacheAspects(CmisObjectType object_p, OwCMISNetwork network_p, String resourceID_p) throws OwException {
        try {
            OwCMISALCacheInfo cacheInfo;
            String objectId = OwCMISPropertyNames.OBJECT_ID.getIdValue(object_p);
            ObjectServicePort osp = network_p.getObjectServicePort();
            CmisPropertiesType properties = osp.getProperties(resourceID_p, objectId, "none", null);
            Aspects aspects = OwCMISALUtil.findFirst(properties.getAny(), Aspects.class);
            if (aspects != null) {
                CmisPropertiesType aspectsProperties = aspects.getProperties();
                List aspectsPropertiesAny = aspectsProperties.getAny();
                aspectsPropertiesAny.add(new OwCMISALCacheInfo(true));
            }
            CmisPropertiesType objectProperties = object_p.getProperties();
            List objectAny = objectProperties.getAny();
            if (aspects != null) {
                Aspects cachedAspects = OwCMISALUtil.findFirst(objectAny, Aspects.class);
                if (cachedAspects == null) {
                    objectAny.add(aspects);
                } else {
                    List cachedAList = cachedAspects.getAppliedAspects();
                    cachedAList.clear();
                    List aList = aspects.getAppliedAspects();
                    cachedAList.addAll(aList);
                }
            }
            if ((cacheInfo = OwCMISALUtil.findFirst(objectAny, OwCMISALCacheInfo.class)) == null) {
                cacheInfo = new OwCMISALCacheInfo(true);
                objectAny.add(cacheInfo);
            } else {
                cacheInfo.setAppliedAspectsCached(true);
            }
        }
        catch (CmisException e) {
            OwNetworkContext context = network_p.getContext();
            OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e, context.getLocale());
            LOG.error((Object)("OwCMISALUtil.cacheAspects(): Error while caching aspects! A CMIS error occurred : " + catcher.getLogMessage()), (Throwable)e);
            throw catcher.toOwException(context.localize("ecmimpl.cmis.OwCMISObjectBase.setProperties.error", "Error while updating properties!"), true);
        }
    }

    public static synchronized Aspects resolveAspects(CmisObjectType object_p, OwCMISNetwork network_p, String resourceID_p) throws OwException {
        CmisPropertiesType properties = object_p.getProperties();
        List any = properties.getAny();
        Aspects aspects = null;
        OwCMISALCacheInfo cacheInfo = null;
        aspects = OwCMISALUtil.findFirst(any, Aspects.class);
        if (aspects == null) {
            OwCMISALUtil.cacheAspects(object_p, network_p, resourceID_p);
            aspects = OwCMISALUtil.findFirst(any, Aspects.class);
        }
        if ((cacheInfo = OwCMISALUtil.findFirst(any, OwCMISALCacheInfo.class)) == null || !cacheInfo.areAppliedAspectsCached()) {
            OwCMISALUtil.cacheAspects(object_p, network_p, resourceID_p);
            aspects = OwCMISALUtil.findFirst(any, Aspects.class);
        }
        return aspects;
    }
}

