/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.alfresco;

import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISResource;
import com.wewebu.ow.server.ecmimpl.cmis.alfresco.OwCMISALObjectClass;
import com.wewebu.ow.server.ecmimpl.cmis.alfresco.OwCMISALUtil;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.exceptions.OwException;
import java.util.LinkedList;
import java.util.List;
import org.alfresco.Aspects;
import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisObjectType;

public class OwCMISAlfrescoObjectClass
extends OwCMISALObjectClass {
    private static final Logger LOG = OwLog.getLogger(OwCMISAlfrescoObjectClass.class);
    private CmisObjectType object;

    public OwCMISAlfrescoObjectClass(OwCMISObjectClass primaryClass_p, CmisObjectType object_p, OwCMISNetwork network_p) throws OwException {
        super(primaryClass_p, network_p);
        this.object = object_p;
    }

    @Override
    public List<String> getAppliedAspectTypes() throws OwException {
        OwCMISResource resource = this.getResource();
        Aspects aspects = OwCMISALUtil.resolveAspects(this.object, this.getNetwork(), resource.getID());
        LinkedList<String> ret = new LinkedList<String>();
        if (aspects != null) {
            for (String asp : aspects.getAppliedAspects()) {
                if (!asp.startsWith("P:sys") && !asp.startsWith("P:cm")) {
                    ret.add(asp);
                    continue;
                }
                LOG.debug((Object)("OwCMISAlfrescoObjectClass.getAppliedAspectTypes : Aspect " + asp + " filtered out."));
            }
        }
        return ret;
    }

    @Override
    public boolean isAssignableFrom(OwCMISObjectClass class_p) throws OwException {
        return false;
    }
}

