/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.alfresco.search;

import com.wewebu.ow.csqlc.OwCSQLCProcessor;
import com.wewebu.ow.csqlc.OwSQLEntitiesResolver;
import com.wewebu.ow.server.ecmimpl.cmis.search.OwCMISCSQLCProcessor;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwSearchCriteria;
import com.wewebu.ow.server.util.OwString;

public class OwCMISAlfrescoCSQLCProcessor
extends OwCMISCSQLCProcessor {
    private static final String ALL = "ALL:";
    private static final char TILDE = '~';
    private static final char COLON = ':';

    public OwCMISAlfrescoCSQLCProcessor(OwSQLEntitiesResolver entitiesResolver_p) {
        super(entitiesResolver_p);
    }

    private String textSearchValue(Object value_p) {
        String value = "'" + (value_p == null ? "" : value_p.toString()) + "'";
        return this.escape(value);
    }

    private String escape(String string_p) {
        StringBuilder builder = new StringBuilder(string_p);
        OwString.replaceAll((StringBuilder)builder, (String)"\\", (String)"\\\\");
        OwString.replaceAll((StringBuilder)builder, (String)"'", (String)"\\'");
        return builder.toString();
    }

    protected String createCBRAllExpression(OwSearchCriteria criteria_p, OwCSQLCProcessor.OwProcessContext context_p) throws OwException {
        Object criteriaValue = criteria_p.getValue();
        if (criteriaValue == null || criteriaValue.toString().length() == 0) {
            return null;
        }
        String value = this.textSearchValue(criteriaValue);
        return ALL + value.toString();
    }

    protected String createCBRInExpression(OwSearchCriteria criteria_p, OwCSQLCProcessor.OwProcessContext context_p) throws OwException {
        Object criteriaValue = criteria_p.getValue();
        if (criteriaValue == null || criteriaValue.toString().length() == 0) {
            return null;
        }
        OwFieldDefinition fieldDefinition = this.retrieveDefinition(criteria_p);
        String fieldName = this.createQueryFieldName(fieldDefinition, context_p);
        String value = this.textSearchValue(criteriaValue);
        return '~' + fieldName + ':' + value;
    }
}

