/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.auth;

import com.wewebu.ow.server.app.OwConfiguration;
import com.wewebu.ow.server.auth.OwAuthentication;
import com.wewebu.ow.server.auth.OwAuthenticator;
import com.wewebu.ow.server.auth.OwCredentialsAuthentication;
import com.wewebu.ow.server.conf.OwBaseInitializer;
import com.wewebu.ow.server.ecm.OwCredentials;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISCredentials;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISLDAPCredentials;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISSecurityHandler;
import com.wewebu.ow.server.ecmimpl.cmis.wshandler.OwCMISSecurityHandlerInterface;
import com.wewebu.ow.server.exceptions.OwAuthenticationException;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.mandator.OwMandator;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwString1;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import com.wewebu.ow.server.util.ldap.OwLdapConnector;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.ws._200908.CmisException;
import org.oasis_open.docs.ns.cmis.ws._200908.RepositoryServicePort;
import org.w3c.dom.Node;

public class OwCMISCredentialsAuthenticator
implements OwAuthenticator {
    private static final String ECM_ADAPTER = "EcmAdapter";
    private static final String AUTHENTICATION = "Authentication";
    private static final Logger LOG = OwLogCore.getLogger(OwCMISCredentialsAuthenticator.class);
    public static final String CONF_NODE_SECURITY_HANDLER = "SecurityHandler";
    private OwBaseInitializer baseInitializer;
    private OwXMLUtil configNode;

    public OwCMISCredentialsAuthenticator(OwBaseInitializer baseInitializer_p) {
        this.baseInitializer = baseInitializer_p;
    }

    public OwCMISCredentialsAuthenticator(OwXMLUtil configNode) {
        this.configNode = configNode;
    }

    public OwAuthentication authenticate(OwAuthentication authentication_p) throws OwAuthenticationException, OwConfigurationException, OwServerException {
        String userName = authentication_p.getUserName();
        String password = authentication_p.getPassword();
        if (userName != null && password != null) {
            OwCMISCredentials credentials = null;
            try {
                credentials = this.createCredentials(userName, password, this.getNetworkConfiguration(), TimeZone.getDefault(), Locale.getDefault(), null);
                RepositoryServicePort repositoryServicePort = credentials.getRepositoryServicePort();
                repositoryServicePort.getRepositories(null);
            }
            catch (SOAPFaultException ex) {
                LOG.debug((Object)"Login failed: Wrong username or password", (Throwable)ex);
                throw new OwAuthenticationException(new OwString("ecmimpl.cmis.OwCMISNetwork.login.failed", "Login failed: Wrong username or password"), (Throwable)ex);
            }
            catch (WebServiceException serviceEx) {
                LOG.fatal((Object)"Can not create communication to the Webservices", (Throwable)serviceEx);
                throw new OwServerException(new OwString("ecmimpl.cmis.OwCMISNetwork.login.communication.error", "Cannot create communication to the Webservices"), (Throwable)serviceEx);
            }
            catch (OwConfigurationException owcfg) {
                throw owcfg;
            }
            catch (OwAuthenticationException owa) {
                LOG.debug((Object)"Authentication Exception", (Throwable)owa);
                throw new OwAuthenticationException(new OwString("ecmimpl.cmis.OwCMISNetwork.login.failed", "Login failed: Wrong username or password"), (Throwable)owa);
            }
            catch (OwServerException ows) {
                throw ows;
            }
            catch (CmisException e) {
                throw new OwServerException(e.getMessage(), (Throwable)e);
            }
            catch (OwException owe) {
                throw new OwServerException(owe.getMessage(), (Throwable)owe);
            }
            OwCredentialsAuthentication credentialsAuthentication = new OwCredentialsAuthentication((OwCredentials)credentials, userName, password);
            return credentialsAuthentication;
        }
        LOG.debug((Object)"OwCMISCredentialsAuthenticator.authenticate(): Login failed: Wrong username or password");
        throw new OwAuthenticationException(new OwString("ecmimpl.cmis.OwCMISNetwork.login.failed", "Login failed: Wrong username or password"));
    }

    protected OwXMLUtil getNetworkConfiguration() throws OwConfigurationException {
        if (this.configNode != null) {
            return this.configNode;
        }
        OwXMLUtil bootstrapx = OwConfiguration.getBootstrap((OwBaseInitializer)this.baseInitializer);
        if (bootstrapx == null) {
            String msg = "No bootstrap.";
            LOG.error((Object)("OwCMISCredentialsAuthenticator.getNetworkConfiguration: " + msg));
            throw new OwConfigurationException(msg);
        }
        try {
            return bootstrapx.getSubUtil(ECM_ADAPTER);
        }
        catch (Exception e) {
            String msg = "Invalid bootstrap.";
            LOG.error((Object)("OwCMISRepositoryAuthenticator.getNetworkConfiguration: " + msg));
            throw new OwConfigurationException(msg, (Throwable)e);
        }
    }

    protected OwCMISCredentials createCredentials(String strUser_p, String strPassword_p, OwXMLUtil configuration_p, TimeZone wsiTimeZone_p, Locale locale_p, OwMandator mandator_p) throws OwException {
        try {
            OwCMISSecurityHandlerInterface handler = this.createSecurityHandler(this.getLoginMap(strUser_p, strPassword_p), locale_p, configuration_p);
            handler.setWsi18nTimeZone(wsiTimeZone_p);
            Node authenticationNode = configuration_p.getSubNode(AUTHENTICATION);
            String authenticationMode = OwXMLDOMUtil.getSafeStringAttributeValue((Node)authenticationNode, (String)"mode", (String)"");
            if ("LDAP".equals(authenticationMode)) {
                return this.createLDAPCredentials(configuration_p, authenticationNode, strUser_p, strPassword_p, handler, mandator_p);
            }
            if ("NONE".equals(authenticationMode)) {
                return new OwCMISCredentials(configuration_p, strUser_p, strPassword_p, handler, mandator_p);
            }
            String msg = "Invalid CMIS authentication configuration! Invalid <Athentication> @mode : " + authenticationMode;
            LOG.error((Object)("OwCMISCredentialsAuthenticator.createCredentials(): " + msg));
            throw new OwServerException(new OwString("ecmimpl.cmis.OwCMISNetwork.invalid.authentication.configuration.error", "Invalid CMIS authentication configuration!"));
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)"Invalid Credentials - maybe there are problems on reading the network config node/subnode \"(Authentication)\"...", (Throwable)e);
            throw new OwServerException(new OwString("ecmimpl.cmis.OwCMISNetwork.invalid.authentication.configuration.error", "Invalid CMIS authentication configuration!"), (Throwable)e);
        }
    }

    protected OwCMISSecurityHandlerInterface createSecurityHandler(Map<String, String> initValues_p, Locale locale_p, OwXMLUtil configuration_p) throws OwException {
        OwCMISSecurityHandlerInterface retHandler = null;
        String strClass = configuration_p.getSafeTextValue(CONF_NODE_SECURITY_HANDLER, null);
        if (strClass != null && !"".equals(strClass)) {
            try {
                Class<?> clazz = Class.forName(strClass);
                retHandler = (OwCMISSecurityHandlerInterface)clazz.newInstance();
            }
            catch (SecurityException e) {
                LOG.error((Object)("SecurityManager restrict the instantiation of type " + strClass + "!"), (Throwable)e);
                throw new OwServerException((OwString)new OwString1("ecmimpl.cmis.OwCMISNetwork.createSecHandler.securityEx", "Instantiation of type %1 is restricted by security.", strClass), (Throwable)e);
            }
            catch (InstantiationException e) {
                LOG.error((Object)("Cannot Instantiate the defined class " + strClass), (Throwable)e);
                throw new OwConfigurationException((OwString)new OwString1("ecmimpl.cmis.OwCMISNetwork.createSecHandler.instanceEx", "The defined class %1 is not allowed to be instantiated.", strClass), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.fatal((Object)("Cannot Instantiate defined class " + strClass + " because it is not accessible."), (Throwable)e);
                throw new OwServerException((OwString)new OwString1("ecmimpl.cmis.OwCMISNetwork.createSecHandler.illegalAccessEx", "The default constructor of class %1 is not accessible or does not exist.", strClass), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)("The class " + strClass + " could not be found by current ClassLoader."), (Throwable)e);
                throw new OwConfigurationException((OwString)new OwString1("ecmimpl.cmis.OwCMISNetwork.createSecHandler.classNotFoundEx", "The defined class %1 could not be found.", strClass), (Throwable)e);
            }
        } else {
            retHandler = new OwCMISSecurityHandler(initValues_p.get("username"), initValues_p.get("password"));
        }
        retHandler.init(initValues_p);
        retHandler.setLocale(locale_p);
        return retHandler;
    }

    protected OwCMISLDAPCredentials createLDAPCredentials(OwXMLUtil configuration_p, Node authenticationNode_p, String username_p, String password_p, OwCMISSecurityHandlerInterface handler_p, OwMandator mandator_p) throws OwException {
        OwLdapConnector ldapconnector = this.createLDAPConnector(authenticationNode_p);
        ldapconnector.authenticate(username_p, password_p);
        return new OwCMISLDAPCredentials(configuration_p, ldapconnector, username_p, password_p, handler_p, mandator_p);
    }

    protected OwLdapConnector createLDAPConnector(Node authenticationNode_p) {
        return new OwLdapConnector(authenticationNode_p);
    }

    protected Map<String, String> getLoginMap(String user_p, String pwd_p) {
        HashMap<String, String> initLoginMap_p = new HashMap<String, String>();
        initLoginMap_p.put("password", pwd_p);
        initLoginMap_p.put("username", user_p);
        return initLoginMap_p;
    }
}

