/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.broker;

import com.wewebu.ow.server.ecmimpl.cmis.broker.OwCMISEventDispatch;
import com.wewebu.ow.server.ecmimpl.cmis.broker.OwCMISListenerHandler;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwException;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class OwCMISListBroker<L> {
    private static final Logger LOG = OwLog.getLogger(OwCMISListBroker.class);
    private List<SoftReference<OwCMISListenerHandler<L>>> listeners = new LinkedList<SoftReference<OwCMISListenerHandler<L>>>();

    public void register(OwCMISListenerHandler<L> listenerHandler_p) {
        this.listeners.add(new SoftReference<OwCMISListenerHandler<L>>(listenerHandler_p));
        listenerHandler_p.createBrokerPhantom(this);
    }

    public synchronized void fire(OwCMISEventDispatch<L> handler_p) throws OwException {
        Iterator<SoftReference<OwCMISListenerHandler<L>>> i = this.listeners.iterator();
        while (i.hasNext()) {
            SoftReference<OwCMISListenerHandler<L>> listenerReference = i.next();
            OwCMISListenerHandler<L> listener = listenerReference.get();
            if (listener != null) {
                listener.fire(handler_p);
                continue;
            }
            i.remove();
        }
    }

    public void logLoad() {
        if (LOG.isDebugEnabled()) {
            int refereceCount = this.listeners.size();
            int disposableReferenceCount = 0;
            for (SoftReference<OwCMISListenerHandler<L>> reference : this.listeners) {
                if (reference.get() != null) continue;
                ++disposableReferenceCount;
            }
            LOG.debug((Object)("OwCMISListBroker.logLoad : references=" + refereceCount + " disposable=" + disposableReferenceCount));
        } else {
            LOG.warn((Object)"OwCMISListBroker.logLoad : load logging is obly enabled in debug mode!");
        }
    }
}

