/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.content;

import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwContentElement;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISExceptionCatcher;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.content.OwCMISContentElement;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISObjectBase;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.messaging._200908.CmisContentStreamType;
import org.oasis_open.docs.ns.cmis.ws._200908.CmisException;
import org.oasis_open.docs.ns.cmis.ws._200908.ObjectServicePort;

public class OwCMISContentCollection
implements OwContentCollection {
    private static Logger LOG = OwLog.getLogger(OwCMISContentCollection.class);
    private LinkedList<OwCMISContentElement> collection = new LinkedList();
    private OwCMISObjectBase object;
    private OwCMISNetwork network;

    public OwCMISContentCollection(OwCMISObjectBase object_p, OwCMISNetwork network_p) throws OwException {
        this.network = network_p;
        this.object = object_p;
        try {
            ObjectServicePort objsectServicePort = this.network.getObjectServicePort();
            CmisContentStreamType streams = objsectServicePort.getContentStream(this.object.getResourceID(), this.object.getDecodedID(), null, null, null, null);
            OwCMISContentElement elem = new OwCMISContentElement(network_p, streams, this.collection.size() + 1);
            this.collection.add(elem);
        }
        catch (CmisException e) {
            OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e);
            LOG.error((Object)("OwCMISContentCollection.OwCMISContentCollection(): Could not initialize a content collection! A CMIS error occurred :  " + catcher.getLogMessage()), (Throwable)e);
            throw catcher.toOwException(this.network.getContext().localize("ecmimpl.cmis.OwCMISContentCollection.init.error", "An error occurred while initializing a content collection!"));
        }
    }

    public OwContentElement getContentElement(int contentType_p, int page_p) throws OwException {
        if (contentType_p != 1) {
            LOG.error((Object)"OwCMISContentCollection.getContentElement():Invalid content type request!Content request is not from type OwContentCollection.CONTENT_TYPE_DOCUMENT!");
            throw new OwInvalidOperationException(this.network.getContext().localize("ecmimpl.cmis.OwCMISContentCollection.invalid.content.type.request.error", "Invalid content type request!"));
        }
        try {
            return this.collection.get(page_p - 1);
        }
        catch (IndexOutOfBoundsException ex) {
            LOG.fatal((Object)("OwCMISContentCollection.getContentElement():Content page index " + page_p + " out of bounds " + this.collection.size() + "!"), (Throwable)ex);
            throw new OwInvalidOperationException(this.network.getContext().localize1("ecmimpl.cmis.OwCMISContentCollection.content.page.index.error", "Invalid content page index %1!", "" + page_p), (Throwable)ex);
        }
    }

    public Collection<Integer> getContentTypes() throws OwException {
        LinkedList<Integer> ret = new LinkedList<Integer>();
        ret.add(1);
        return ret;
    }

    public int getPageCount() throws OwException {
        return this.collection.size();
    }
}

