/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.content;

import com.wewebu.ow.server.ecm.OwContentElement;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.util.OwStreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.messaging._200908.CmisContentStreamType;

public class OwCMISContentElement
implements OwContentElement {
    private static Logger LOG = OwLog.getLogger(OwCMISContentElement.class);
    private CmisContentStreamType m_stream;
    private int m_page;
    private OwCMISNetwork network;

    public OwCMISContentElement(OwCMISNetwork network_p, CmisContentStreamType nativObject_p, int pageNumber_p) {
        this.m_stream = nativObject_p;
        this.m_page = pageNumber_p;
        this.network = network_p;
    }

    public String getContentFilePath() throws OwException {
        return this.m_stream.getFilename();
    }

    public Object getContentObject() throws OwException {
        return this.m_stream;
    }

    public int getContentRepresentation() throws OwException {
        return 2;
    }

    public InputStream getContentStream(OutputStream out_p) throws OwException {
        InputStream stream;
        try {
            stream = this.m_stream.getStream().getInputStream();
        }
        catch (IOException e) {
            LOG.fatal((Object)"Error accessing content stream!", (Throwable)e);
            throw new OwServerException(this.network.getContext().localize("ecmimpl.cmis.OwCMISContentElement.getContentStream.error", "Error accessing content stream!"), (Throwable)e);
        }
        try {
            if (out_p == null) {
                return stream;
            }
            OwStreamUtil.upload((InputStream)stream, (OutputStream)out_p, (boolean)false);
            out_p.flush();
            stream.close();
            stream = null;
            return null;
        }
        catch (Exception e) {
            LOG.error((Object)"Could not redirect stream to given output stream", (Throwable)e);
            throw new OwServerException(this.network.getContext().localize("ecmimpl.cmis.OwCMISContentElement.getContentStream.redirect.error", "Could not redirect stream to given output stream."), (Throwable)e);
        }
    }

    public String getContentURL() throws OwException {
        return "";
    }

    public String getMIMEParameter() throws OwException {
        return this.m_stream.getFilename();
    }

    public String getMIMEType() throws OwException {
        return this.m_stream.getMimeType();
    }

    public int getPageNumber(int pageIndex_p) throws OwException {
        return this.m_page;
    }

    public boolean isInputStreamNative() {
        return true;
    }

    public void releaseResources() {
    }

    protected CmisContentStreamType getNativeType() {
        return this.m_stream;
    }
}

