/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.content;

import com.wewebu.ow.server.ecm.OwContentElement;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.util.OwString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import org.apache.log4j.Logger;

public class OwCMISContentElementDataSource
implements DataSource {
    private static Logger LOG = OwLog.getLogger(OwCMISContentElementDataSource.class);
    public static final String DATASOURCE_CONTENT_KEY = "CMIS_CONTENT_TRANSFER";
    private String mimeType;
    private OwContentElement content;
    private String name;

    public OwCMISContentElementDataSource(OwContentElement elem_p, String name_p) throws OwException {
        this(elem_p, name_p, null);
    }

    public OwCMISContentElementDataSource(OwContentElement elem_p, String name_p, String mimeType_p) throws OwException {
        this.content = elem_p;
        this.name = name_p;
        if (mimeType_p == null) {
            try {
                this.mimeType = elem_p.getMIMEType();
            }
            catch (OwException e) {
                throw e;
            }
            catch (Exception ex) {
                LOG.fatal((Object)"OwCMISContentElementDataSource.<init>:Invalid content element! Could not retrieve MIME type from content element!", (Throwable)ex);
                throw new OwServerException(new OwString("ecmimpl.cmis.OwCMISContentElementDataSource.invalid.element.error", "Invalid content element!"), (Throwable)ex);
            }
        } else {
            this.mimeType = mimeType_p;
        }
    }

    public String getContentType() {
        String contentType = this.mimeType == null ? "application/octet-stream" : this.mimeType;
        return contentType;
    }

    public InputStream getInputStream() throws IOException {
        try {
            return this.content.getContentStream(null);
        }
        catch (Exception e) {
            LOG.fatal((Object)"OwCMISContentElementDataSource.getInputStream: Could not access content stream!", (Throwable)e);
            throw new IOException("Could not access content stream!");
        }
    }

    public String getName() {
        return this.name;
    }

    public OutputStream getOutputStream() throws IOException {
        LOG.fatal((Object)"OwCMISContentElementDataSource.getOutputStream: Unsupported  content element data source operation!");
        throw new IOException("OwContentElementDataSource.getOutputStream: is not supported");
    }
}

