/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.content;

import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwContentElement;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISContentConveter;
import com.wewebu.ow.server.ecmimpl.cmis.content.OwCMISContentElementDataSource;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.util.OwString;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.messaging._200908.CmisContentStreamType;

public class OwCMISStandardContentConverter
implements OwCMISContentConveter {
    private static final Logger LOG = OwLog.getLogger(OwCMISStandardContentConverter.class);

    @Override
    public CmisContentStreamType createCmisContentStream(OwContentCollection contentCollection_p) throws OwException {
        try {
            if (contentCollection_p == null || contentCollection_p.getPageCount() == 0) {
                return null;
            }
        }
        catch (OwException owEx) {
            throw owEx;
        }
        catch (Exception e) {
            LOG.fatal((Object)"OwCMISStandardContentConverter.createCmisContentStream(): Invalid content collection! Could not retrieve content page count!", (Throwable)e);
            throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISStandardContentConverter.invalid.content.collection.error", "Invalid content collection! "), (Throwable)e);
        }
        OwContentElement elem = null;
        try {
            elem = contentCollection_p.getContentElement(1, 1);
        }
        catch (OwException owEx) {
            throw owEx;
        }
        catch (Exception e) {
            LOG.fatal((Object)"OwCMISStandardContentConverter.createCmisContentStream(): Invalid content collection! Could not retrieve content element!", (Throwable)e);
            throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISStandardContentConverter.invalid.content.collection.error", "Invalid content collection! "), (Throwable)e);
        }
        OwCMISContentElementDataSource ds = null;
        ds = new OwCMISContentElementDataSource(elem, this.getElementName(elem));
        CmisContentStreamType stream = new CmisContentStreamType();
        stream.setFilename(ds.getName());
        stream.setMimeType(ds.getContentType());
        stream.setStream(new DataHandler((DataSource)ds));
        return stream;
    }

    private String getElementName(OwContentElement contentElement_p) throws OwException {
        try {
            String name = null;
            name = contentElement_p.getMIMEParameter();
            if (name != null) {
                name = name.replace('\\', '/');
                name = name.substring(name.indexOf(61) + 1);
            }
            return name;
        }
        catch (OwException owEx) {
            throw owEx;
        }
        catch (Exception ex) {
            LOG.fatal((Object)"OwCMISStandardContentConverter.getElementName(): Could not create content element name !", (Throwable)ex);
            throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISStandardContentConverter.content.name.error", "Could not create content element name !"), (Throwable)ex);
        }
    }
}

