/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.cross;

import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwCrossMappings;
import com.wewebu.ow.server.ecm.OwExtendedCrossMappings;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwPermissionCollection;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecm.OwStandardProperty;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISCrossNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSort;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class OwCMISCrossInvocationHandler
implements InvocationHandler {
    private static final Logger LOG = OwLog.getLogger(OwCMISCrossInvocationHandler.class);
    private static Method GETPROPETYCLASS;
    private static Method GETPROPETY;
    private static Method GETPROPETIES;
    private static Method CLASS_GETCLASSNAME;
    private static Method OBJECT_GETCLASSNAME;
    private static Method NETWORK_CREATEOBJECTCOPY;
    private static Method CLASS_GETCHILDS;
    private static Method OBJECT_GETCHILDS;
    private static Method CLASS_GETPROPERTYCLASSNAMES;
    private static Method PROPERTYCLASS_GETCLASSNAME;
    private static Method NETWORK_CREATENEWOBJECT_1;
    private static Method NETWORK_CREATENEWOBJECT_2;
    private static final Map<Class<?>, Class<?>[]> interfaces;
    private OwCMISCrossNetwork crossNetwork;
    private OwCrossMappings mappings;
    private Object object;
    private static ThreadLocal<String> clientResourceID;
    private String serverResourceID;

    private static synchronized Class[] allInterfacesOf(Class<?> class_p) {
        Class[] classInterfaces = interfaces.get(class_p);
        if (classInterfaces == null) {
            HashSet interfacesList = new HashSet();
            for (Class<?> current = class_p; current != null; current = current.getSuperclass()) {
                Class<?>[] currentInterfaces = current.getInterfaces();
                for (int i = 0; i < currentInterfaces.length; ++i) {
                    interfacesList.add(currentInterfaces[i]);
                }
            }
            classInterfaces = interfacesList.toArray(new Class[interfacesList.size()]);
            interfaces.put(class_p, classInterfaces);
        }
        return classInterfaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object call(CrossCall call, String callClientResourceID) throws Exception {
        String stackedResource = clientResourceID.get();
        try {
            clientResourceID.set(callClientResourceID);
            Object object = call.call();
            return object;
        }
        finally {
            clientResourceID.set(stackedResource);
        }
    }

    public static <O> O createCrossNetworkObject(OwCMISCrossNetwork network_p, OwCrossMappings mappings_p, O object_p, String serverResourceID_p) {
        Class<?> clazz = object_p.getClass();
        Class[] interfaces = OwCMISCrossInvocationHandler.allInterfacesOf(clazz);
        return (O)Proxy.newProxyInstance(clazz.getClassLoader(), interfaces, (InvocationHandler)new OwCMISCrossInvocationHandler(network_p, mappings_p, object_p, serverResourceID_p));
    }

    public OwCMISCrossInvocationHandler(OwCMISCrossNetwork crossNetwork_p, OwCrossMappings mappings_p, Object object_p, String serverResourceID_p) {
        this.crossNetwork = crossNetwork_p;
        this.mappings = mappings_p;
        this.object = object_p;
        this.serverResourceID = serverResourceID_p;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object[] crossArgs = this.toCrossArguments(method, args);
        if (crossArgs != null) {
            for (int i = 0; i < crossArgs.length; ++i) {
                if (crossArgs[i] instanceof OwNetwork) {
                    crossArgs[i] = this.crossNetwork.getNetwork(this.serverResourceID);
                }
                if (!(crossArgs[i] instanceof OwObject)) continue;
                OwObject objectArgument = (OwObject)crossArgs[i];
                crossArgs[i] = this.mirrorObject(objectArgument);
            }
        }
        String stackedResource = clientResourceID.get();
        try {
            clientResourceID.set(this.serverResourceID);
            Object returnValue = null;
            returnValue = method.getName().equals("equals") && 1 == crossArgs.length ? Boolean.valueOf(this.callEquals(crossArgs[0])) : method.invoke(this.object, crossArgs);
            clientResourceID.set(stackedResource);
            if (this.crossConversionRequired()) {
                if (this.overrides(CLASS_GETCLASSNAME, method) || this.overrides(OBJECT_GETCLASSNAME, method)) {
                    if (this.isExternal(clientResourceID.get())) {
                        String string = ((OwExtendedCrossMappings)this.mappings).getXClass((String)returnValue);
                        return string;
                    }
                    String string = ((OwExtendedCrossMappings)this.mappings).getIClass((String)returnValue);
                    return string;
                }
                Object object = this.toCrossReturnValue(returnValue);
                return object;
            }
            if (this.overrides(CLASS_GETCHILDS, method)) {
                Object object = this.crossConvertReturnValue(returnValue);
                return object;
            }
            Object object = returnValue;
            return object;
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        finally {
            clientResourceID.set(stackedResource);
        }
    }

    private boolean overrides(Method overriden_p, Method method_p) throws OwException {
        if (overriden_p == null || method_p == null) {
            throw new OwInvalidOperationException("null method comparison " + (overriden_p == null ? "null" : overriden_p.toString()) + " vs. " + (method_p == null ? "null" : method_p.toString()));
        }
        return overriden_p.getDeclaringClass().isAssignableFrom(method_p.getDeclaringClass()) && overriden_p.getName().equals(method_p.getName()) && Arrays.equals(overriden_p.getParameterTypes(), method_p.getParameterTypes());
    }

    private OwObject mirrorObject(OwObject object_p) throws OwInvalidOperationException {
        String resourceID = null;
        try {
            if (object_p.getResource() != null) {
                resourceID = object_p.getResourceID();
            }
        }
        catch (Exception e) {
            throw new OwInvalidOperationException("Invalidobject argument", (Throwable)e);
        }
        if (resourceID == null && this.serverResourceID != null || !resourceID.equals(this.serverResourceID)) {
            return OwCMISCrossInvocationHandler.createCrossNetworkObject(this.crossNetwork, this.mappings, object_p, resourceID);
        }
        return object_p;
    }

    private boolean crossConversionRequired() throws Exception {
        if (clientResourceID.get() == null) {
            return this.serverResourceID != null && !this.crossNetwork.getResource(clientResourceID.get()).getID().equals(this.serverResourceID);
        }
        return !clientResourceID.get().equals(this.serverResourceID);
    }

    private boolean isExternal(String repositoryID_p) throws OwException {
        return this.crossNetwork.getNetwork(repositoryID_p) == this.crossNetwork.getExternalNetwork();
    }

    private Object[] toCrossArguments(Method method_p, Object[] args_p) throws Exception {
        if (this.crossConversionRequired()) {
            return this.crossConvertMehtodArguments(method_p, args_p);
        }
        return args_p;
    }

    private String toCrossPropertyName(String propertyName_p, String fromRepositoryID_p) throws OwException {
        if (this.isExternal(fromRepositoryID_p)) {
            return ((OwExtendedCrossMappings)this.mappings).getIProperty(propertyName_p);
        }
        return ((OwExtendedCrossMappings)this.mappings).getXProperty(propertyName_p);
    }

    private Collection<String> toCrossPropertyNames(Collection propertyNames_p, String fromResourceID_p) throws OwException {
        return this.toCrossPropertyNames(propertyNames_p, fromResourceID_p, new LinkedList<String>());
    }

    private Collection<String> toCrossPropertyNames(Collection propertyNames_p, String fromResourceID_p, Collection<String> crosssNames_p) throws OwException {
        if (propertyNames_p != null) {
            for (String name : propertyNames_p) {
                crosssNames_p.add(this.toCrossPropertyName(name, fromResourceID_p));
            }
            return crosssNames_p;
        }
        return null;
    }

    private Object[] crossConvertMehtodArguments(Method method_p, Object[] args_p) throws Exception {
        Object[] crossArgs = null;
        if (args_p != null) {
            crossArgs = new Object[args_p.length];
            System.arraycopy(args_p, 0, crossArgs, 0, args_p.length);
            if (this.overrides(GETPROPETYCLASS, method_p) || this.overrides(GETPROPETY, method_p)) {
                crossArgs[0] = this.toCrossPropertyName((String)crossArgs[0], clientResourceID.get());
            } else if (this.overrides(GETPROPETIES, method_p)) {
                crossArgs[0] = this.toCrossPropertyNames((Collection)crossArgs[0], clientResourceID.get());
            } else if (this.overrides(OBJECT_GETCHILDS, method_p)) {
                crossArgs[1] = this.toCrossPropertyNames((Collection)crossArgs[1], clientResourceID.get());
            } else if (this.overrides(NETWORK_CREATEOBJECTCOPY, method_p)) {
                crossArgs[1] = this.toCrossProperties((OwPropertyCollection)crossArgs[1], clientResourceID.get(), this.serverResourceID);
            } else if (this.overrides(NETWORK_CREATENEWOBJECT_1, method_p)) {
                crossArgs[3] = this.toCrossClassName((String)crossArgs[3], clientResourceID.get());
            } else if (this.overrides(NETWORK_CREATENEWOBJECT_2, method_p)) {
                crossArgs[1] = this.toCrossClassName((String)crossArgs[1], clientResourceID.get());
            }
        }
        return crossArgs;
    }

    private Object toCrossReturnValue(Object object_p) throws Exception {
        if (this.crossConversionRequired()) {
            return this.crossConvertReturnValue(object_p);
        }
        return object_p;
    }

    private Object crossConvertReturnValue(Object object_p) throws Exception {
        if (object_p == null) {
            return null;
        }
        if (object_p instanceof OwObject || object_p instanceof OwFieldDefinition || object_p instanceof OwObjectClass || object_p instanceof OwPropertyClass || object_p instanceof OwProperty) {
            return OwCMISCrossInvocationHandler.createCrossNetworkObject(this.crossNetwork, this.mappings, object_p, this.serverResourceID);
        }
        if (object_p instanceof List) {
            List list = (List)object_p;
            int listSize = list.size();
            for (int i = 0; i < listSize; ++i) {
                Object object;
                Object iObject = list.get(i);
                if (iObject == (object = this.crossConvertReturnValue(iObject))) continue;
                list.remove(i);
                list.add(i, object);
            }
            return list;
        }
        if (object_p instanceof Collection) {
            Collection collection = (Collection)object_p;
            Iterator i = collection.iterator();
            ArrayList<Object> toBeCrossed = new ArrayList<Object>();
            while (i.hasNext()) {
                Object object;
                Object iObject = i.next();
                if (iObject == (object = this.crossConvertReturnValue(iObject))) continue;
                i.remove();
                toBeCrossed.add(object);
            }
            for (Object e : toBeCrossed) {
                collection.add(e);
            }
            return collection;
        }
        if (object_p instanceof OwPropertyCollection) {
            OwPropertyCollection propertyCollection = (OwPropertyCollection)object_p;
            OwStandardPropertyCollection interceptedCollection = new OwStandardPropertyCollection();
            Set propertyEntries = propertyCollection.entrySet();
            for (Map.Entry entry : propertyEntries) {
                OwProperty property = (OwProperty)entry.getValue();
                try {
                    OwProperty crossProperty = this.toCrossProperty(property, this.serverResourceID, clientResourceID.get());
                    interceptedCollection.put((Object)crossProperty.getPropertyClass().getClassName(), (Object)crossProperty);
                }
                catch (OwObjectNotFoundException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Invalid property cross-conversion for " + (String)entry.getKey() + ". "), (Throwable)e);
                        continue;
                    }
                    LOG.warn((Object)("Invalid property cross-conversion for " + (String)entry.getKey() + ". " + e.getMessage()));
                }
            }
            return interceptedCollection;
        }
        return object_p;
    }

    private OwPropertyCollection toCrossProperties(OwPropertyCollection properties, String fromRepositoryID, String toResourceID) throws Exception {
        if (properties != null) {
            Set propertyEntries = properties.entrySet();
            OwStandardPropertyCollection crossPropertyCollection = new OwStandardPropertyCollection();
            for (Map.Entry entry : propertyEntries) {
                OwProperty crossProperty = this.toCrossProperty((OwProperty)entry.getValue(), fromRepositoryID, toResourceID);
                crossPropertyCollection.put((Object)crossProperty.getPropertyClass().getClassName(), (Object)crossProperty);
            }
            return crossPropertyCollection;
        }
        return null;
    }

    private OwProperty toCrossProperty(OwProperty property, String fromRepositoryID, String toResourceID) throws Exception {
        OwPropertyClass propertyClass = property.getPropertyClass();
        String propertyClassName = propertyClass.getClassName();
        String crossPropertyClassName = this.toCrossPropertyName(propertyClassName, fromRepositoryID);
        OwNetwork clientNetwrok = this.crossNetwork.getNetwork(toResourceID);
        OwResource clientResource = this.crossNetwork.getResource(toResourceID);
        OwPropertyClass crossPropertyClass = (OwPropertyClass)clientNetwrok.getFieldDefinition(crossPropertyClassName, clientResource.getID());
        return this.convert(property, crossPropertyClass);
    }

    private String toCrossClassName(String className, String fromRepositoryID) throws OwException {
        if (this.isExternal(fromRepositoryID)) {
            return ((OwExtendedCrossMappings)this.mappings).getIClass(className);
        }
        return ((OwExtendedCrossMappings)this.mappings).getXClass(className);
    }

    private OwProperty convert(OwProperty property, OwPropertyClass toClass) throws Exception {
        Object convertedValue = this.mappings.convert(property.getValue(), (OwFieldDefinition)property.getPropertyClass(), (OwFieldDefinition)toClass);
        return new OwStandardProperty(convertedValue, toClass);
    }

    private boolean callEquals(Object other) {
        Object naked = other;
        while (Proxy.isProxyClass(naked.getClass()) && Proxy.getInvocationHandler(naked).getClass() == OwCMISCrossInvocationHandler.class) {
            naked = ((OwCMISCrossInvocationHandler)Proxy.getInvocationHandler((Object)naked)).object;
        }
        return this.object.equals(naked);
    }

    static {
        try {
            GETPROPETYCLASS = OwObjectClass.class.getMethod("getPropertyClass", String.class);
            CLASS_GETCLASSNAME = OwObjectClass.class.getMethod("getClassName", new Class[0]);
            OBJECT_GETCLASSNAME = OwObject.class.getMethod("getClassName", new Class[0]);
            GETPROPETY = OwObject.class.getMethod("getProperty", String.class);
            GETPROPETIES = OwObject.class.getMethod("getProperties", Collection.class);
            CLASS_GETCHILDS = OwObjectClass.class.getMethod("getChilds", OwNetwork.class, Boolean.TYPE);
            CLASS_GETPROPERTYCLASSNAMES = OwObjectClass.class.getMethod("getPropertyClassNames", new Class[0]);
            PROPERTYCLASS_GETCLASSNAME = OwPropertyClass.class.getMethod("getClassName", new Class[0]);
            OBJECT_GETCHILDS = OwObject.class.getMethod("getChilds", int[].class, Collection.class, OwSort.class, Integer.TYPE, Integer.TYPE, OwSearchNode.class);
            NETWORK_CREATEOBJECTCOPY = OwNetwork.class.getMethod("createObjectCopy", OwObject.class, OwPropertyCollection.class, OwPermissionCollection.class, OwObject.class, int[].class);
            NETWORK_CREATENEWOBJECT_1 = OwNetwork.class.getMethod("createNewObject", Boolean.TYPE, Object.class, OwResource.class, String.class, OwPropertyCollection.class, OwPermissionCollection.class, OwContentCollection.class, OwObject.class, String.class, String.class);
            NETWORK_CREATENEWOBJECT_2 = OwNetwork.class.getMethod("createNewObject", OwResource.class, String.class, OwPropertyCollection.class, OwPermissionCollection.class, OwContentCollection.class, OwObject.class, String.class, String.class);
        }
        catch (Exception e) {
            LOG.error((Object)"Inavlid java code base.", (Throwable)e);
        }
        interfaces = new HashMap();
        clientResourceID = new ThreadLocal();
    }

    public static interface CrossCall {
        public Object call() throws Exception;
    }
}

