/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.generic;

import com.wewebu.ow.server.ecmimpl.cmis.generic.OwCMISValueConverter;
import com.wewebu.ow.server.ecmimpl.cmis.generic.OwCMISValueConverterClass;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.util.OwString;
import java.util.List;
import org.apache.log4j.Logger;

public class OwCMISLiveListHandler<L, O> {
    private static final Logger LOG = OwLog.getLogger(OwCMISLiveListHandler.class);
    private OwCMISValueConverter<L, O> liveValueConverter;
    private OwCMISValueConverterClass<L, O> liveValueConverterClass;

    public OwCMISLiveListHandler(OwCMISValueConverter<L, O> liveValueConverter_p) {
        this.liveValueConverter = liveValueConverter_p;
        this.liveValueConverterClass = this.liveValueConverter.getConverterClass();
    }

    public Object extractValue(List<L> liveList_p, boolean isArray_p) throws OwInvalidOperationException {
        if (!liveList_p.isEmpty()) {
            if (isArray_p) {
                return this.liveValueConverter.toArrayValue(liveList_p);
            }
            return this.liveValueConverter.toValue(liveList_p);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void replaceListValues(List<L> liveList_p, Object value_p, boolean isArray_p) throws OwInvalidOperationException {
        if (value_p == null) {
            liveList_p.clear();
            return;
        }
        Class<?> valueClass = value_p.getClass();
        if (isArray_p) {
            if (!valueClass.isArray()) {
                String msg = "Invalid non array value! Array value expected !" + valueClass + " found instead!";
                LOG.error((Object)("OwCMISLiveListHandler.setValue():" + msg));
                throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISLiveListHandler.array.expected.error", "Array value expected!"));
            }
            Class<?> arrayComponentClass = valueClass.getComponentType();
            if (this.liveValueConverterClass.getOClass().isAssignableFrom(arrayComponentClass)) {
                Object[] oValue = (Object[])value_p;
                List<L> lValue = this.liveValueConverter.fromArrayValue(oValue);
                liveList_p.clear();
                liveList_p.addAll(lValue);
                return;
            }
            if (!(value_p instanceof Object[])) {
                String msg = "Invalid array component type ! " + this.liveValueConverterClass.getOClass().getName() + "[] expected ! " + valueClass.getComponentType().getName() + "[] found istead!";
                LOG.error((Object)("OwCMISLiveListHandler.setValue():" + msg));
                throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISLiveListHandler.invalid.array.component.error", "Invalid array component type! "));
            }
        } else {
            if (this.liveValueConverterClass.getOClass().isAssignableFrom(valueClass)) {
                Object oValue = value_p;
                List<L> lValue = this.liveValueConverter.fromValue(oValue);
                liveList_p.clear();
                liveList_p.addAll(lValue);
                return;
            }
            String msg = "Invalid value type ! " + this.liveValueConverterClass.getOClass().getName() + " expected ! " + valueClass.getName() + " found instead!";
            LOG.error((Object)("OwCMISLiveListHandler.setValue():" + msg));
            throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISLiveListHandler.invalid.value.type.error", "Invalid value!"));
        }
        Object[] objArr = (Object[])value_p;
        liveList_p.clear();
        int i = 0;
        while (i < objArr.length) {
            if (objArr[i] != null) {
                liveList_p.addAll(this.liveValueConverter.fromValue(objArr[i]));
            } else {
                liveList_p.add(null);
            }
            ++i;
        }
    }
}

