/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.generic;

import com.wewebu.ow.server.ecmimpl.cmis.generic.OwCMISNativePropertyBinding;
import com.wewebu.ow.server.ecmimpl.cmis.generic.OwCMISPropertyDefinition;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.util.OwString;
import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisProperty;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDefinitionType;

public abstract class OwCMISPropertyDefinitionBase<L, P extends CmisProperty>
implements OwCMISPropertyDefinition<L> {
    private static Logger LOG = OwLog.getLogger(OwCMISPropertyDefinitionBase.class);
    private Class<P> propertyClass;

    public OwCMISPropertyDefinitionBase(Class<P> propertyClass_p) {
        this.propertyClass = propertyClass_p;
    }

    protected abstract P createNativeProperty();

    protected abstract OwCMISNativePropertyBinding<L> createTypedBoundProperty(P var1);

    @Override
    public final OwCMISNativePropertyBinding<L> createBoundProperty(CmisProperty cmisProperty_p) throws OwInvalidOperationException {
        CmisProperty property = null;
        if (cmisProperty_p == null) {
            property = (CmisProperty)this.createNativeProperty();
        } else if (this.propertyClass.isAssignableFrom(cmisProperty_p.getClass())) {
            property = cmisProperty_p;
        } else {
            String msg = "Invalid native property " + cmisProperty_p.getPropertyDefinitionId() + " type " + cmisProperty_p.getClass().getName() + " for " + this.propertyClass.getName() + " was expected";
            LOG.error((Object)("OwCMISPropertyDefinitionBase.createBoundProperty():" + msg));
            throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISPropertyDefinitionBase.invalid.native.property.error", "Invalid property!"));
        }
        CmisPropertyDefinitionType definition = this.getNativeDefinition();
        property.setPropertyDefinitionId(definition.getId());
        return this.createTypedBoundProperty(property);
    }
}

