/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.object;

import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwStandardObjectCollection;
import com.wewebu.ow.server.ecm.OwVersion;
import com.wewebu.ow.server.ecm.OwVersionSeries;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISExceptionCatcher;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISObjectModel;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISResource;
import com.wewebu.ow.server.ecmimpl.cmis.broker.OwCMISListenerHandler;
import com.wewebu.ow.server.ecmimpl.cmis.broker.OwCMISObjectBroker;
import com.wewebu.ow.server.ecmimpl.cmis.broker.OwCMISVersionEventListener;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISObjectBase;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObject;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISProperty;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISPropertyNames;
import com.wewebu.ow.server.ecmimpl.cmis.version.OwCMISVersionModel;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.exceptions.OwServerException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.ws.Holder;
import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisAllowableActionsType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisObjectType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisRepositoryCapabilitiesType;
import org.oasis_open.docs.ns.cmis.core._200908.EnumIncludeRelationships;
import org.oasis_open.docs.ns.cmis.messaging._200908.CmisObjectParentsType;
import org.oasis_open.docs.ns.cmis.ws._200908.CmisException;
import org.oasis_open.docs.ns.cmis.ws._200908.NavigationServicePort;

public class OwCMISDocumentObject
extends OwCMISObjectBase
implements OwCMISVersionEventListener {
    private static final Logger LOG = OwLog.getLogger(OwCMISDocumentObject.class);
    private OwCMISListenerHandler<OwCMISVersionEventListener> versionListenerHandler;
    private OwVersion version;

    public OwCMISDocumentObject(OwCMISNetwork network_p, OwCMISObjectModel objectModel_p, CmisObjectType type_p) throws OwException {
        super(network_p, objectModel_p, type_p);
        if (this.hasVersionSeries()) {
            OwCMISObjectBroker objectBroker = network_p.getObjectBroker();
            this.versionListenerHandler = new OwCMISListenerHandler<OwCMISDocumentObject>(this);
            objectBroker.register(this.getResourceID(), this.getVersionSeriesId(), this.versionListenerHandler);
        }
    }

    public boolean canGetContent(int contentType_p, int context_p) throws OwException {
        return this.m_cmisObjType.getAllowableActions().isCanGetContentStream();
    }

    @Override
    public boolean canSetProperties(int contextStatus_p) throws OwException {
        boolean basicCanSet = super.canSetProperties(contextStatus_p);
        if (basicCanSet) {
            if (!this.isImmutable()) {
                OwVersion myVersion = this.getVersion();
                OwVersionSeries versionSeries = this.getVersionSeries();
                OwCMISResource resource = this.getResource();
                CmisRepositoryCapabilitiesType resourceCapabilities = resource.getCMISCapabilities();
                try {
                    OwVersion pwc = versionSeries.getReservation();
                    if (pwc != null && pwc.equals(myVersion)) {
                        return resourceCapabilities.isCapabilityPWCUpdatable();
                    }
                    return true;
                }
                catch (OwException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.fatal((Object)"OwCMISDocumentObject.canSetProperties(): Error while checking the set properties capability!", (Throwable)e);
                    throw new OwInvalidOperationException(this.getNetwork().getContext().localize("ecmimpl.cmis.OwCMISDocumentObject.canSetProperties.error", "Error while checking the set properties capability!"), (Throwable)e);
                }
            }
            return false;
        }
        return false;
    }

    public boolean isImmutable() throws OwException {
        OwCMISProperty immutableProperty = this.getProperty(OwCMISPropertyNames.IS_IMMUTABLE.getId());
        Object immutableValue = immutableProperty.getValue();
        if (immutableValue instanceof Boolean) {
            Boolean immutableBoolValue = (Boolean)immutableValue;
            return immutableBoolValue;
        }
        String errClass = immutableValue == null ? "<null>" : immutableValue.getClass().toString();
        String msg = "Invalid immutable value " + immutableValue + " of java-class " + errClass;
        LOG.fatal((Object)("OwCMISDocumentObject.isImmutable():" + msg));
        throw new OwInvalidOperationException(msg);
    }

    @Override
    public OwObjectCollection getParents() throws OwException {
        try {
            OwStandardObjectCollection parentsCollection = new OwStandardObjectCollection();
            NavigationServicePort ns = this.getNetwork().getNavigationServicePort();
            List lst = ns.getObjectParents(this.getResourceID(), this.getVersionSeriesId(), null, Boolean.TRUE, EnumIncludeRelationships.NONE, null, Boolean.TRUE, null);
            for (CmisObjectParentsType parent : lst) {
                OwCMISObject parentObject = this.getNetwork().createCMISObject(parent.getObject(), this.getResource());
                parentsCollection.add((Object)parentObject);
            }
            return parentsCollection.isEmpty() ? null : parentsCollection;
        }
        catch (CmisException e) {
            OwCMISNetwork network = this.getNetwork();
            OwNetworkContext context = network.getContext();
            OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e, context.getLocale());
            LOG.error((Object)("OwCMISDocumentObject.getParents(): Could not retrieve parents of document!A CMIS error occurred : " + catcher.getLogMessage()), (Throwable)e);
            throw catcher.toOwException(context.localize("ecmimpl.cmis.OwCMISDocumentObject.getParents.error", "Can not retrieve parents of document!"), true);
        }
    }

    @Override
    public String getMIMEType() throws OwException {
        try {
            OwCMISProperty contentMimeType = this.getProperty(OwCMISPropertyNames.CONTENT_STREAM_MIME_TYPE.getId());
            Object mimeTypeValue = contentMimeType.getValue();
            return mimeTypeValue == null ? "" : mimeTypeValue.toString();
        }
        catch (OwException ex) {
            throw ex;
        }
        catch (Exception e) {
            LOG.fatal((Object)"OwCMISDocumentObject.getMIMEType():Can not retrieve ContentStreamMimeType property of Document!", (Throwable)e);
            throw new OwObjectNotFoundException(this.getNetwork().getContext().localize("ecmimpl.cmis.OwCMISDocumentObject.getMIMEType.error", "Can not retrieve the content stream MIME-type of document!"), (Throwable)e);
        }
    }

    @Override
    public String getMIMEParameter() throws OwException {
        try {
            StringBuffer buf = new StringBuffer("name=\"");
            buf.append(this.getProperty(OwCMISPropertyNames.CONTENT_STREAM_FILENAME.getId()).getValue().toString());
            buf.append('\"');
            return buf.toString();
        }
        catch (Exception ex) {
            LOG.debug((Object)"OwCMISDocumentObject.getMIMEParameter(): Problem retrieving contentstream filename!", (Throwable)ex);
            return "";
        }
    }

    @Override
    public boolean hasContent(int context_p) throws OwException {
        try {
            OwCMISProperty contentMimeType = this.getProperty(OwCMISPropertyNames.CONTENT_STREAM_ID.getId());
            return contentMimeType.getValue() != null;
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.fatal((Object)"OwCMISDocumentObject.hasContent():Can not retrieve ContentStreamLentgh property of Document!", (Throwable)e);
            throw new OwObjectNotFoundException(this.getNetwork().getContext().localize("ecmimpl.cmis.OwCMISDocumentObject.hasContent.error", "Can not retrieve the document content information!"), (Throwable)e);
        }
    }

    @Override
    public void delete() throws OwException {
        Holder holder = new Holder();
        try {
            this.getNetwork().getObjectServicePort().deleteObject(this.getResourceID(), this.getDecodedID(), Boolean.TRUE, holder);
        }
        catch (CmisException e) {
            OwCMISNetwork network = this.getNetwork();
            OwNetworkContext context = network.getContext();
            OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e, context.getLocale());
            LOG.error((Object)("OwCMISDocumentObject.delete(): Could not delete object!A CMIS error occurred : " + catcher.getLogMessage()), (Throwable)e);
            throw catcher.toOwException(context.localize("ecmimpl.cmis.OwCMISDocumentObject.delete.error", "Can not delete document!"), true);
        }
    }

    public OwVersion getVersion() throws OwException {
        if (this.version == null) {
            OwCMISVersionModel versionModel = this.getObjectModel().getVersionModel();
            this.version = versionModel.createVersion(this.getNetwork(), this);
        }
        return this.version;
    }

    public String getVersionSeriesId() throws OwException {
        OwCMISProperty versionSeriesId = this.getProperty(OwCMISPropertyNames.VERSION_SERIES_ID.getId());
        Object versionSeriesIdValue = versionSeriesId.getValue();
        return versionSeriesIdValue.toString();
    }

    public CmisAllowableActionsType getAllowableActions() {
        return this.m_cmisObjType.getAllowableActions();
    }

    public OwVersionSeries getVersionSeries() throws OwException {
        OwCMISVersionModel versionModel = this.getObjectModel().getVersionModel();
        return versionModel.createVersionSeries(this, this.getNetwork());
    }

    public boolean hasVersionSeries() throws OwException {
        try {
            return this.getObjectClass().hasVersionSeries();
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)"Error checking version series!", (Throwable)e);
            OwCMISNetwork network = this.getNetwork();
            OwNetworkContext context = network.getContext();
            throw new OwInvalidOperationException(context.localize("ecmimpl.cmis.OwCMISDocumentObject.version.series.error", "Version series error!"), (Throwable)e);
        }
    }

    public boolean canSetContent(int contentType_p, int context_p) throws Exception {
        return this.getVersion().canSave(2);
    }

    public void setContentCollection(OwContentCollection content_p) throws Exception {
        this.getVersion().save(content_p, null, null);
    }

    @Override
    public void versionCheckedOut(String resourceId_p, String versionSeriesId_p, CmisObjectType pwcObject_p, String oldVersionId_p) throws OwException {
        if (this.getDecodedID().equals(oldVersionId_p)) {
            this.resetNativeObject(pwcObject_p);
        }
    }

    @Override
    public void versionCanceledChenckedOut(String resourceId_p, String versionSeriesId_p, CmisObjectType currentObject_p, String pwcVersionId_p) throws OwException {
        if (this.getDecodedID().equals(pwcVersionId_p)) {
            this.resetNativeObject(currentObject_p);
        }
    }

    @Override
    public void versionCheckedIn(String resourceId_p, String versionSeriesId_p, CmisObjectType currentObject_p, String pwcVersionId_p) throws OwException {
        if (this.getDecodedID().equals(pwcVersionId_p)) {
            this.resetNativeObject(currentObject_p);
        }
    }

    @Override
    public void versionSaved(String resourceId_p, String versionSeriesId_p, CmisObjectType currentObject_p, String oldVersionId_p) throws OwException {
        if (this.getDecodedID().equals(oldVersionId_p)) {
            this.resetNativeObject(currentObject_p);
        }
    }

    public boolean hasChilds(int[] objectTypes_p, int context_p) throws Exception {
        return false;
    }

    @Override
    protected void resetNativeObject(CmisObjectType object_p) throws OwException {
        super.resetNativeObject(object_p);
        this.version = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getPath() throws OwException {
        StringBuilder path;
        block15: {
            path = null;
            OwObjectCollection col = this.getParents();
            if (col != null) {
                OwCMISObject parent = (OwCMISObject)col.get(0);
                try {
                    path = new StringBuilder(parent.getPath());
                }
                catch (OwException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new OwServerException(this.getNetwork().getContext().localize("OwCMISDocumentObject.getPath.error.parent", "Could not retrieve path information."), (Throwable)e);
                }
                if (path.charAt(path.length() - 1) != '/') {
                    path.append("/");
                }
                try {
                    if (this.getVersion().isCheckedOut(1)) {
                        OwVersionSeries series = this.getVersionSeries();
                        if (this.getVersion().isMajor(1)) {
                            OwObject obj = series.getObject(series.getReleased());
                            path.append(obj.getName());
                            break block15;
                        } else {
                            Collection versionCol = series.getVersions(null, null, 5);
                            Iterator it = versionCol.iterator();
                            OwObject previous = null;
                            while (it.hasNext()) {
                                OwVersion now = (OwVersion)it.next();
                                if (!now.isLatest(1) || previous != null) continue;
                                if (it.hasNext()) {
                                    now = (OwVersion)it.next();
                                    previous = series.getObject(now);
                                    break;
                                }
                                previous = series.getObject(now);
                                break;
                            }
                            if (previous == null) {
                                LOG.error((Object)"OwCMISDocumentObject.getPath: Could not retrieve last available version.");
                                throw new OwServerException(this.getNetwork().getContext().localize("OwCMISDocumentObject.getPath.error.version", "Could not retrieve last available version."));
                            }
                            path.append(previous.getName());
                        }
                        break block15;
                    }
                    path.append(this.getName());
                }
                catch (OwException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new OwServerException(this.getNetwork().getContext().localize("OwCMISDocumentObject.getPath.error.name", "Could not retrieve cmis:name information."), (Throwable)e);
                }
            }
        }
        if (path == null) {
            return null;
        }
        String string = path.toString();
        return string;
    }
}

