/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.object;

import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwPermissionCollection;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwStandardObjectCollection;
import com.wewebu.ow.server.ecm.OwStatusContextException;
import com.wewebu.ow.server.ecm.OwVersion;
import com.wewebu.ow.server.ecm.OwVersionSeries;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISExceptionCatcher;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISObjectModel;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISObjectBase;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISQueryContext;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObject;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISProperty;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISPropertyNames;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClass;
import com.wewebu.ow.server.ecmimpl.cmis.util.OwCMISPropertiesFilter;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSort;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.ws.Holder;
import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisObjectType;
import org.oasis_open.docs.ns.cmis.core._200908.EnumBaseObjectTypeIds;
import org.oasis_open.docs.ns.cmis.core._200908.EnumIncludeRelationships;
import org.oasis_open.docs.ns.cmis.core._200908.EnumUnfileObject;
import org.oasis_open.docs.ns.cmis.messaging._200908.CmisObjectInFolderContainerType;
import org.oasis_open.docs.ns.cmis.messaging._200908.CmisObjectInFolderListType;
import org.oasis_open.docs.ns.cmis.messaging._200908.CmisObjectInFolderType;
import org.oasis_open.docs.ns.cmis.messaging._200908.DeleteTreeResponse;
import org.oasis_open.docs.ns.cmis.messaging._200908.EnumServiceException;
import org.oasis_open.docs.ns.cmis.ws._200908.CmisException;
import org.oasis_open.docs.ns.cmis.ws._200908.NavigationServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.ObjectServicePort;
import org.perf4j.log4j.Log4JStopWatch;

public class OwCMISFolderObject
extends OwCMISObjectBase {
    private static final Logger LOG = OwLog.getLogger(OwCMISFolderObject.class);
    private static final int DEFAUL_MAX_SORT_CRITERIA = 1;
    private OwSort clientSortCollection;

    public OwCMISFolderObject(OwCMISNetwork network_p, OwCMISObjectModel objectModel_p, CmisObjectType cmistype_p) throws OwException {
        super(network_p, objectModel_p, cmistype_p);
    }

    @Override
    public int getChildCount(int[] objectTypes_p, int context_p) throws OwException {
        throw new OwStatusContextException("");
    }

    @Override
    public OwObjectCollection getChilds(int[] objectTypes_p, Collection propertyNames_p, OwSort sort_p, int maxSize_p, int versionSelection_p, OwSearchNode filterCriteria_p) throws OwException {
        OwStandardObjectCollection ret = this.createObjectCollection();
        this.clientSortCollection = null;
        NavigationServicePort np = this.getNetwork().getNavigationServicePort();
        BigInteger depth = BigInteger.ONE;
        BigInteger skip = BigInteger.ZERO;
        BigInteger max = new BigInteger(Integer.toString(maxSize_p));
        Log4JStopWatch stopWatchGetChilds = new Log4JStopWatch("getChilds", "OwCMISFolder.getChildren()");
        if (objectTypes_p == null) {
            objectTypes_p = new int[]{};
        }
        block8: for (int iType = 0; iType < objectTypes_p.length; ++iType) {
            switch (objectTypes_p[iType]) {
                case 8192: 
                case 8193: {
                    OwCMISExceptionCatcher catcher;
                    OwNetworkContext context;
                    OwCMISNetwork network;
                    OwCMISObject cmisObject;
                    CmisObjectType object;
                    OwCMISObjectClass classDesc;
                    String objectTypeID;
                    CmisObjectType cmisChild;
                    try {
                        OwCMISObjectClass clazz = this.getNetwork().getObjectClass(EnumBaseObjectTypeIds.CMIS_FOLDER.value(), this.getResource());
                        if (this.getResource().getCMISCapabilities().isCapabilityGetFolderTree() && (sort_p == null || sort_p.getCriteriaCollection().isEmpty())) {
                            Log4JStopWatch stopWatch = new Log4JStopWatch("getFolderTree(folder)", "OwCMISFolderObject.getChilds: service getFolderTree(folder)");
                            List lst = np.getFolderTree(this.getResourceID(), this.getDecodedID(), depth, this.getChildrenPropertiesAsString(propertyNames_p, clazz), Boolean.TRUE, EnumIncludeRelationships.NONE, OwCMISPropertyNames.NONE.getId(), Boolean.FALSE, null);
                            stopWatch.stop();
                            for (CmisObjectInFolderContainerType conType : lst) {
                                CmisObjectInFolderType objectInFolder = conType.getObjectInFolder();
                                CmisObjectType theObject = objectInFolder.getObject();
                                OwCMISObject child = this.getNetwork().createCMISObject(theObject, this.getResource());
                                ret.add((Object)child);
                            }
                            continue block8;
                        }
                        Log4JStopWatch stopWatch = new Log4JStopWatch("getChildren(folder)", "OwCMISFolderObject.getChilds: service getChildren(folder)");
                        CmisObjectInFolderListType lst = np.getChildren(this.getResourceID(), this.getDecodedID(), this.getChildrenPropertiesAsString(propertyNames_p, clazz), this.getSortString(sort_p, 1), Boolean.TRUE, EnumIncludeRelationships.NONE, OwCMISPropertyNames.NONE.getId(), Boolean.TRUE, max, skip, null);
                        stopWatch.stop();
                        for (CmisObjectInFolderType objInFolder : lst.getObjects()) {
                            cmisChild = objInFolder.getObject();
                            objectTypeID = OwCMISPropertyNames.OBJECT_TYPE_ID.getIdValue(cmisChild);
                            classDesc = this.getNetwork().getObjectClass(objectTypeID, this.getResource());
                            if (classDesc.getType() != 8193) continue;
                            objInFolder.getObject();
                            object = objInFolder.getObject();
                            cmisObject = this.getNetwork().createCMISObject(object, this.getResource());
                            ret.add((Object)cmisObject);
                        }
                        continue block8;
                    }
                    catch (CmisException e) {
                        network = this.getNetwork();
                        context = network.getContext();
                        catcher = new OwCMISExceptionCatcher(e, context.getLocale());
                        LOG.error((Object)("OwCMISFolderObject.getChilds(): Could retrieve folder children! A CMIS error occurred : " + catcher.getLogMessage()), (Throwable)e);
                        throw catcher.toOwException(context.localize("ecmimpl.cmis.OwCMISFolderObject.getChilds.error", "Could retrieve folder children!"), true);
                    }
                }
                case 4096: 
                case 4097: {
                    OwCMISExceptionCatcher catcher;
                    OwNetworkContext context;
                    OwCMISNetwork network;
                    OwCMISObject cmisObject;
                    CmisObjectType object;
                    OwCMISObjectClass classDesc;
                    String objectTypeID;
                    CmisObjectType cmisChild;
                    try {
                        Log4JStopWatch stopWatch = new Log4JStopWatch("getChildren(document)", "OwCMISFolderObject.getChilds: service getChildren(document)");
                        OwCMISObjectClass clazz = this.getNetwork().getObjectClass(EnumBaseObjectTypeIds.CMIS_DOCUMENT.value(), this.getResource());
                        CmisObjectInFolderListType lstType = np.getChildren(this.getResourceID(), this.getDecodedID(), this.getChildrenPropertiesAsString(propertyNames_p, clazz), this.getSortString(sort_p, 1), Boolean.TRUE, EnumIncludeRelationships.NONE, OwCMISPropertyNames.NONE.getId(), Boolean.TRUE, max, skip, null);
                        stopWatch.stop();
                        for (CmisObjectInFolderType objectInFolder : lstType.getObjects()) {
                            cmisChild = objectInFolder.getObject();
                            objectTypeID = OwCMISPropertyNames.OBJECT_TYPE_ID.getIdValue(cmisChild);
                            classDesc = this.getNetwork().getObjectClass(objectTypeID, this.getResource());
                            if (classDesc.getType() != 4097) continue;
                            object = objectInFolder.getObject();
                            cmisObject = this.getNetwork().createCMISObject(object, this.getResource());
                            ret.add((Object)cmisObject);
                        }
                        continue block8;
                    }
                    catch (CmisException e) {
                        network = this.getNetwork();
                        context = network.getContext();
                        catcher = new OwCMISExceptionCatcher(e, context.getLocale());
                        LOG.error((Object)("OwCMISFolderObject.getChilds(): Could retrieve folder children! A CMIS error occurred : " + catcher.getLogMessage()), (Throwable)e);
                        throw catcher.toOwException(context.localize("ecmimpl.cmis.OwCMISFolderObject.getChilds.error", "Could retrieve folder children!"), true);
                    }
                }
            }
        }
        stopWatchGetChilds.stop();
        if (this.getClientSortCollection() == null || this.getClientSortCollection().getCriteriaCollection().isEmpty()) {
            return ret;
        }
        Log4JStopWatch stopWatchSort = new Log4JStopWatch("sort", "OwCMISFolder.getChildren(): client sorting");
        this.doClientsideSorting((OwObjectCollection)ret);
        stopWatchSort.stop();
        this.setClientSortCollection(null);
        return ret;
    }

    @Override
    public OwObjectCollection getParents() throws OwException {
        OwStandardObjectCollection col = new OwStandardObjectCollection();
        try {
            if (!this.getNetwork().getResource(this.getResourceID()).getRepsitoryRootFolderId().equals(this.getDecodedID())) {
                CmisObjectType parent = this.getNetwork().getNavigationServicePort().getFolderParent(this.getResourceID(), this.getDecodedID(), null, null);
                if (parent.getAllowableActions() == null) {
                    parent = this.getNetwork().getObjectServicePort().getObject(this.getResourceID(), OwCMISPropertyNames.OBJECT_ID.getIdValue(parent), null, Boolean.TRUE, EnumIncludeRelationships.NONE, OwCMISPropertyNames.NONE.getId(), Boolean.FALSE, Boolean.FALSE, null);
                }
                OwCMISObject cmisObject = this.getNetwork().createCMISObject(parent, this.getResource());
                col.add((Object)cmisObject);
            }
        }
        catch (CmisException e) {
            OwCMISNetwork network = this.getNetwork();
            OwNetworkContext context = network.getContext();
            OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e, context.getLocale());
            LOG.error((Object)("OwCMISFolderObject.getParents(): Could retrieve folder parents! A CMIS error occurred : " + catcher.getLogMessage()), (Throwable)e);
            throw catcher.toOwException(context.localize("ecmimpl.cmis.OwCMISFolderObject.getParents.error", "Could retrieve folder parents!"), true);
        }
        return col.isEmpty() ? null : col;
    }

    @Override
    public boolean canAdd(OwObject object_p, int context_p) throws OwException {
        try {
            if (context_p == 2) {
                String objID = object_p.getClassName();
                OwCMISProperty prop = this.getProperty(OwCMISPropertyNames.ALLOWED_CHILD_OBJECTTYPE_IDS.getId());
                String[] childIDs = (String[])prop.getValue();
                if (childIDs != null && childIDs.length > 0) {
                    try {
                        for (String id : childIDs) {
                            if (id == null || !this.isSubtypeOf(objID, id)) continue;
                            return Boolean.TRUE;
                        }
                    }
                    catch (OwObjectNotFoundException e) {
                        // empty catch block
                    }
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            return Boolean.TRUE;
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.fatal((Object)"OwCMISFolderObject.canAdd(): Error while checking the add object capability!", (Throwable)e);
            throw new OwServerException(this.getNetwork().getContext().localize("ecmimpl.cmis.OwCMISFolderObject.canAdd.error", "Error while checking the add object capability!"), (Throwable)e);
        }
    }

    public boolean canGetContent(int contentType_p, int context_p) throws OwException {
        return false;
    }

    protected String getChildrenPropertiesAsString(Collection<String> propertyNames_p, OwCMISObjectClass defaultObjClass_p) throws OwException {
        String properties;
        if (propertyNames_p == null || propertyNames_p.isEmpty()) {
            properties = "*";
        } else {
            OwCMISPropertiesFilter propertiesFilter = new OwCMISPropertiesFilter();
            propertiesFilter.addAll(OwCMISQueryContext.GET_PROPERTY, propertyNames_p, defaultObjClass_p, this.getResource());
            propertiesFilter.add(OwCMISPropertyNames.OBJECT_TYPE_ID.getId());
            propertiesFilter.add(OwCMISPropertyNames.OBJECT_ID.getId());
            propertiesFilter.add(OwCMISPropertyNames.IS_IMMUTABLE.getId());
            propertiesFilter.add(OwCMISPropertyNames.CHANGE_TOKEN.getId());
            if (defaultObjClass_p != null && defaultObjClass_p.getType() == 4097) {
                propertiesFilter.add(OwCMISPropertyNames.IS_VERSION_SERIES_CHECKED_OUT.getId());
                propertiesFilter.add(OwCMISPropertyNames.VERSION_SERIES_ID.getId());
                propertiesFilter.add(OwCMISPropertyNames.VERSION_SERIES_CHECKED_OUT_BY.getId());
                propertiesFilter.add(OwCMISPropertyNames.VERSION_LABEL.getId());
                propertiesFilter.add(OwCMISPropertyNames.CONTENT_STREAM_ID.getId());
                propertiesFilter.add(OwCMISPropertyNames.IS_MAJOR_VERSION.getId());
                propertiesFilter.add(OwCMISPropertyNames.CONTENT_STREAM_MIME_TYPE.getId());
            }
            properties = propertiesFilter.getFilterString();
        }
        return properties;
    }

    protected String getSortString(OwSort sortingOrder_p, int maxSortCriteria_p) throws OwException {
        if (sortingOrder_p != null && !sortingOrder_p.getCriteriaCollection().isEmpty()) {
            StringBuilder sortStatements = new StringBuilder();
            boolean notOrderableCriteria = false;
            if (maxSortCriteria_p > 0 && maxSortCriteria_p < sortingOrder_p.getCriteriaCollection().size()) {
                notOrderableCriteria = true;
            } else {
                Iterator itSortCrit = sortingOrder_p.getCriteriaCollection().iterator();
                while (itSortCrit.hasNext()) {
                    OwSort.OwSortCriteria crit = (OwSort.OwSortCriteria)itSortCrit.next();
                    StringBuilder sortOrder = new StringBuilder();
                    boolean orderAble = false;
                    try {
                        OwCMISPropertyClass propClazz;
                        OwFieldDefinition def = this.getNetwork().getFieldDefinition(crit.getPropertyName(), this.getResourceID());
                        if (def instanceof OwCMISPropertyClass && (propClazz = (OwCMISPropertyClass)def).isOrderable()) {
                            sortOrder.append(propClazz.getQueryName(OwCMISQueryContext.SQL));
                            orderAble = true;
                        }
                        if (!orderAble) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("OwCMISFolderObject.getSortString(OwSort): The property " + crit.getPropertyName() + " cannot be used for sorting."));
                            }
                            notOrderableCriteria = Boolean.TRUE;
                        }
                    }
                    catch (OwObjectNotFoundException ex) {
                        LOG.warn((Object)("Could not retrieve the field definition, we will use the name as defined = " + crit.getPropertyName()), (Throwable)ex);
                        throw new OwInvalidOperationException(this.getNetwork().getContext().localize1("ecmimpl.cmis.OwCMISFolderObject.invalidSearchCriteria", "The property %1 could not be found!", crit.getPropertyName()), (Throwable)ex);
                    }
                    if (orderAble) {
                        sortOrder.append(" ");
                        sortOrder.append(crit.getAscFlag() ? "ASC" : "DESC");
                        if (itSortCrit.hasNext()) {
                            sortOrder.insert(0, ",");
                        }
                    }
                    sortStatements.insert(0, sortOrder);
                }
            }
            if (notOrderableCriteria) {
                this.setClientSortCollection(sortingOrder_p);
            }
            LOG.info((Object)("OwCMISFolderObject.getSortString: Sorting will be: " + sortStatements.toString()));
            String sortString = sortStatements.length() > 0 ? sortStatements.toString() : null;
            return sortString;
        }
        return null;
    }

    @Override
    public void delete() throws OwException {
        try {
            DeleteTreeResponse.FailedToDelete failedToDelete = this.getNetwork().getObjectServicePort().deleteTree(this.getResourceID(), this.getDecodedID(), Boolean.TRUE, EnumUnfileObject.DELETE, Boolean.TRUE, null);
            List objectIds = failedToDelete.getObjectIds();
            if (objectIds != null && !objectIds.isEmpty()) {
                StringBuilder errorBuilder = new StringBuilder();
                for (String objectId : objectIds) {
                    errorBuilder.append("\n\t[");
                    errorBuilder.append(objectId);
                    errorBuilder.append("]");
                }
                LOG.error((Object)("OwCMISFolderObject.delete(): could not delete the folder tree objects with the following IDs : " + errorBuilder.toString()));
                OwCMISNetwork network = this.getNetwork();
                OwNetworkContext context = network.getContext();
                throw new OwServerException(context.localize("ecmimpl.cmis.OwCMISFolderObject.delete.tree.error", "Could not delete all of the folder tree elements!"));
            }
        }
        catch (CmisException e) {
            OwCMISNetwork network = this.getNetwork();
            OwNetworkContext context = network.getContext();
            OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e, context.getLocale());
            LOG.error((Object)("OwCMISFolderObject.delete(): Could not delete folder!A CMIS error occurred : " + catcher.getLogMessage()), (Throwable)e);
            throw catcher.toOwException(context.localize("ecmimpl.cmis.OwCMISFolderObject.delete.error", "Can not delete folder!"), true);
        }
    }

    @Override
    public void removeReference(OwObject object_p) throws OwException {
        try {
            boolean multi = this.getResource().getCMISCapabilities().isCapabilityMultifiling();
            if (object_p.getType() == 4097 && multi) {
                this.getNetwork().getMultiFilingServicePort().removeObjectFromFolder(this.getResourceID(), this.decodeID(object_p.getID()), this.getDecodedID(), null);
            } else {
                this.getNetwork().getObjectServicePort().deleteTree(this.getResourceID(), this.decodeID(object_p.getID()), Boolean.FALSE, EnumUnfileObject.UNFILE, Boolean.TRUE, null);
            }
        }
        catch (CmisException e) {
            OwCMISNetwork network = this.getNetwork();
            OwNetworkContext context = network.getContext();
            OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e, context.getLocale());
            LOG.error((Object)("OwCMISFolderObject.removeReference(): Could not remove reference !A CMIS error occurred : " + catcher.getLogMessage()), (Throwable)e);
            throw catcher.toOwException(context.localize("ecmimpl.cmis.OwCMISFolderObject.removeReference.error", "Can not remove reference !"), true);
        }
    }

    @Override
    public boolean canRemoveReference(OwObject object_p, int context_p) throws OwException {
        if (object_p.getType() == 4097) {
            return this.getResource().getCMISCapabilities().isCapabilityMultifiling();
        }
        return super.canRemoveReference(object_p, context_p);
    }

    @Override
    public void add(OwObject object_p) throws OwException {
        OwCMISNetwork network = this.getNetwork();
        OwNetworkContext context = network.getContext();
        OwObjectClass objectClass = object_p.getObjectClass();
        int objectType = objectClass.getType();
        if (objectType == 8193) {
            LOG.error((Object)"OwCMISFolderObject.add(): Folder multifilling (INSERT_MODE_REFERENCE) is not supported by CMIS! ");
            throw new OwNotSupportedException(context.localize("ecmimpl.cmis.OwCMISFolderObject.add.folders.not.supported", "Folder multifiling is not supported!"));
        }
        if (this.getResource().getCMISCapabilities().isCapabilityMultifiling()) {
            try {
                Holder holder = new Holder();
                network.getMultiFilingServicePort().addObjectToFolder(this.getResourceID(), this.decodeID(object_p.getID()), this.getDecodedID(), null, holder);
            }
            catch (CmisException e) {
                OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e, context.getLocale());
                LOG.error((Object)("OwCMISFolderObject.add(): Could not add object!A CMIS error occurred : " + catcher.getLogMessage()), (Throwable)e);
                if (e.getFaultInfo().getType().equals((Object)EnumServiceException.CONSTRAINT)) {
                    throw new OwInvalidOperationException(context.localize("ecmimpl.cmis.OwCMISFolderObject.add.cmis.error.constraint", "It is not allowed to add an object of this type!"), (Throwable)e);
                }
                throw catcher.toOwException(context.localize("ecmimpl.cmis.OwCMISFolderObject.add.cmis.error", "Cannot add the object!"), true);
            }
        } else {
            LOG.error((Object)"OwCMISFolderObject.add(): Repository does not support multifiling");
            throw new OwNotSupportedException(context.localize("ecmimpl.cmis.OwCMISFolderObject.add.multifiling.not.supported", "Multifiling is not supported by this system!"));
        }
    }

    protected static void addPropertyName(StringBuilder existingProp_p, String newPropName_p) {
        if (existingProp_p.length() != 0 && existingProp_p.lastIndexOf(",") != existingProp_p.length()) {
            existingProp_p.append(',');
        }
        existingProp_p.append(newPropName_p);
    }

    public OwVersion getVersion() throws OwException {
        return null;
    }

    public OwVersionSeries getVersionSeries() throws OwException {
        return null;
    }

    public boolean hasVersionSeries() throws OwException {
        return false;
    }

    public boolean canSetContent(int contentType_p, int context_p) throws OwException {
        return false;
    }

    public void setContentCollection(OwContentCollection content_p) throws OwException {
    }

    public boolean hasChilds(int[] objectTypes_p, int context_p) throws OwException {
        return true;
    }

    @Override
    public OwCMISObject createCopy(OwCMISObject copyParent_p, OwPropertyCollection properties_p, OwPermissionCollection permissions_p, int[] childTypes_p) throws OwException {
        OwCMISObject myCopy = super.createCopy(copyParent_p, properties_p, permissions_p, childTypes_p);
        if (childTypes_p == null || childTypes_p.length == 0) {
            childTypes_p = new int[]{4097, 8193, 12289};
        }
        OwObjectCollection children = this.getChilds(childTypes_p, null, null, 0, 0, null);
        for (OwCMISObject cmisChild : children) {
            cmisChild.createCopy(myCopy, properties_p, permissions_p, childTypes_p);
        }
        return myCopy;
    }

    protected void setClientSortCollection(OwSort sort_p) {
        this.clientSortCollection = sort_p;
    }

    protected OwSort getClientSortCollection() {
        return this.clientSortCollection;
    }

    protected OwStandardObjectCollection createObjectCollection() {
        return new OwStandardObjectCollection();
    }

    protected void doClientsideSorting(OwObjectCollection col_p) throws OwException {
        try {
            col_p.sort(this.getClientSortCollection());
        }
        catch (Exception e) {
            throw new OwInvalidOperationException("Could not sort object collection.", (Throwable)e);
        }
    }

    @Override
    public String getPath() throws OwException {
        StringBuilder path = new StringBuilder("/");
        path.append(this.getResourceID());
        path.append(this.getProperty(OwCMISPropertyNames.PATH.getId()).getValue());
        return path.toString();
    }

    @Override
    public boolean canMove(OwObject object_p, OwObject oldParent_p, int context_p) throws OwException {
        if (object_p != null) {
            return this.canAdd(object_p, 2);
        }
        return super.canMove(object_p, oldParent_p, context_p);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void move(OwObject object_p, OwObject oldParent_p) throws OwException {
        if (object_p == null) {
            LOG.warn((Object)"OwCMISFodlerObject.move: Called with null for moving object");
            throw new OwInvalidOperationException(this.getNetwork().getContext().localize("ecmimpl.cmis.OwCMISFolderObject.move.nullObj", "No object defined for move operation"));
        }
        if (!this.canAdd(object_p, 2)) {
            LOG.warn((Object)"OwCMISFolderObject.move: Moving defined type is not allowed into target folder.");
            throw new OwInvalidOperationException(this.getNetwork().getContext().localize("ecmimpl.cmis.OwCMISFolderObject.move.typeRestriction", "Move operation is not allowed for provided object type."));
        }
        ObjectServicePort osp = this.getNetwork().getObjectServicePort();
        Holder objId = new Holder();
        objId.value = this.decodeID(this.getCurrentObjectId(object_p));
        String target = this.getDecodedID();
        String src = oldParent_p == null ? null : this.decodeID(oldParent_p.getID());
        try {
            osp.moveObject(this.getResourceID(), objId, target, src, null);
            return;
        }
        catch (CmisException e) {
            LOG.error((Object)("Could not move object, srcFolder = " + src + " target = " + target + " moveObj = " + (String)objId.value), (Throwable)e);
            OwCMISExceptionCatcher transformer = new OwCMISExceptionCatcher(e);
            OwNetworkContext ctx = this.getNetwork().getContext();
            String msg = ctx.localize("ecmimpl.cmis.OwCMISFolderObject.move", "Moving operation failed.");
            throw transformer.toOwException(msg, false);
        }
    }

    protected boolean isSubtypeOf(String typeId, String isParentId) throws OwException {
        if (typeId.equals(isParentId)) {
            return Boolean.TRUE;
        }
        OwCMISObjectClass clazz = this.getObjectModel().getObjectClass(typeId);
        OwCMISObjectClass pClass = clazz.getParent();
        if (pClass == null) {
            return Boolean.FALSE;
        }
        return this.isSubtypeOf(pClass.getClassName(), isParentId);
    }

    protected String getCurrentObjectId(OwObject object_p) throws OwException {
        return object_p.getID();
    }
}

