/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.object;

import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwPermissionCollection;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwStandardPropertyClass;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISACLModel;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISExceptionCatcher;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISObjectModel;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISResource;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISSimpleDMSID;
import com.wewebu.ow.server.ecmimpl.cmis.content.OwCMISContentCollection;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISObjectExtension;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISQueryContext;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObject;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.cmis.permissions.OwCMISPermissionCollection;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISInternalProperty;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISNativeProperty;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISProperty;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISPropertyNames;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISStandardPropertyCollectionConverter;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISInternalPropertyClass;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISNativePropertyClass;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClass;
import com.wewebu.ow.server.ecmimpl.cmis.util.OwCMISPropertiesFilter;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSearchTemplate;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.util.OwObjectIDCodeUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.ws.Holder;
import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisAccessControlEntryType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisAccessControlListType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisObjectType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertiesType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisProperty;
import org.oasis_open.docs.ns.cmis.core._200908.EnumACLPropagation;
import org.oasis_open.docs.ns.cmis.core._200908.EnumIncludeRelationships;
import org.oasis_open.docs.ns.cmis.messaging._200908.CmisACLType;
import org.oasis_open.docs.ns.cmis.ws._200908.ACLServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.CmisException;
import org.oasis_open.docs.ns.cmis.ws._200908.ObjectServicePort;

public abstract class OwCMISObjectBase
implements OwCMISObject {
    private static final Logger LOG = OwLog.getLogger(OwCMISObjectBase.class);
    private OwCMISObjectClass m_objectclass;
    protected CmisObjectType m_cmisObjType;
    protected OwCMISNetwork m_network;
    private OwCMISObjectModel objectModel;
    private OwStandardPropertyCollection internalCache;
    private String m_id;
    private String m_decodedID;
    public static final String CUSTOMIZE_CLASS_EP = "cmis.object.reset.customize.class";
    public static final String PROCESS_NATIVE_PROPERITIES_EP = "cmis.object.process.native.properties";
    public static final String REQUEST_CACHED_PROPERITIES_EP = "cmis.object.request.cached.properties";
    public static final String FILTER_PROPERTY_EXTENSIONS_EP = "cmis.object.filter.property.extensions";
    public static final String ADD_PROPERTY_EXTENSIONS_EP = "cmis.object.add.property.extensions";

    public OwCMISObjectBase(OwCMISNetwork network_p, OwCMISObjectModel objectModel_p, CmisObjectType object_p) throws OwException {
        this.m_network = network_p;
        this.objectModel = objectModel_p;
        this.resetNativeObject(object_p);
    }

    protected void resetNativeObject(CmisObjectType object_p) throws OwException {
        this.m_cmisObjType = object_p;
        this.m_decodedID = OwCMISPropertyNames.OBJECT_ID.getIdValue(this.m_cmisObjType);
        this.m_id = this.encodeID(this.m_decodedID);
        if (this.m_id == null) {
            LOG.error((Object)"OwCMISObjectBase.reset(): Could not initialize CMIS object - the object ID property is missing!");
            throw new OwInvalidOperationException(this.getNetwork().getContext().localize("ecmimpl.cmis.OwCMISObjectBase.resetNativeObject.error", "Error while reseting the CMIS object state!"));
        }
        String objTypeId = OwCMISPropertyNames.OBJECT_TYPE_ID.getIdValue(this.m_cmisObjType);
        if (objTypeId == null) {
            LOG.error((Object)"OwCMISObjectBase.reset(): Could not initialize CMIS object - the object type ID property is missing!");
            throw new OwInvalidOperationException(this.getNetwork().getContext().localize("ecmimpl.cmis.OwCMISObjectBase.resetNativeObject.error", "Error while reseting the CMIS object state!"));
        }
        this.m_objectclass = this.objectModel.getObjectClass(objTypeId);
        OwCMISResource resource = this.getResource();
        OwCMISObjectExtension objectExtension = resource.getExtension(CUSTOMIZE_CLASS_EP, OwCMISObjectExtension.class, this.m_objectclass);
        this.m_objectclass = objectExtension.customizeClass(this.m_cmisObjType, this.m_objectclass, this.m_network);
        this.initCache();
        if (this.m_cmisObjType.getAllowableActions() == null) {
            LOG.error((Object)"OwCMISObjectBase.reset(): Could not initialize CMIS object - the allowableActions were not retrieved (getAllowableActions()==null)!");
            throw new OwInvalidOperationException(this.getNetwork().getContext().localize("ecmimpl.cmis.OwCMISObjectBase.resetNativeObject.error", "Error while reseting the CMIS object state!"));
        }
    }

    @Override
    public OwCMISObjectClass getObjectClass() {
        return this.m_objectclass;
    }

    public String getMIMEType() throws OwException {
        return this.m_objectclass.getMimetype();
    }

    public String getDMSID() throws OwException {
        return OwCMISSimpleDMSID.createDMSID(this.getNetwork().getDMSPrefix(), this.getResourceID(), this.getID());
    }

    public int getType() {
        return this.m_objectclass.getType();
    }

    public void add(OwObject object_p) throws OwException {
        LOG.fatal((Object)("OwCMISObjectBase.add():CMIS child count is not supported for object java class " + this.getClass().getName()));
        throw new OwNotSupportedException(this.getNetwork().getContext().localize("ecmimpl.cmis.unsupported.object.operation", "Unsupported CMIS adapter object operation!"));
    }

    public boolean canAdd(OwObject object_p, int context_p) throws OwException {
        return false;
    }

    public boolean canChangeClass() throws OwException {
        return false;
    }

    public boolean canDelete(int context_p) throws OwException {
        return this.m_cmisObjType.getAllowableActions().isCanDeleteObject();
    }

    public boolean canFilterChilds() throws OwException {
        return false;
    }

    public boolean canGetPermissions() throws OwException {
        try {
            this.objectModel.getACLModel();
            return true;
        }
        catch (OwNotSupportedException e) {
            LOG.warn((Object)"ACL not supported!");
            return false;
        }
    }

    public boolean canGetProperties(int context_p) throws OwException {
        return true;
    }

    public boolean canLock() throws OwException {
        return false;
    }

    public boolean canMove(OwObject object_p, OwObject oldParent_p, int context_p) throws OwException {
        return false;
    }

    public boolean canRemoveReference(OwObject object_p, int context_p) throws OwException {
        return false;
    }

    public boolean canSetPermissions() throws OwException {
        try {
            OwCMISACLModel aclModel = this.objectModel.getACLModel();
            return aclModel.canManageACL();
        }
        catch (OwNotSupportedException e) {
            LOG.warn((Object)"ACL not supported!");
            return false;
        }
    }

    public void changeClass(String strNewClassName_p, OwPropertyCollection properties_p, OwPermissionCollection permissions_p) throws OwException {
    }

    public void delete() throws OwException {
    }

    public int getChildCount(int[] objectTypes_p, int context_p) throws OwException {
        LOG.fatal((Object)("OwCMISObjectBase.getChildCount():CMIS child count is not supported for object java class " + this.getClass().getName()));
        throw new OwNotSupportedException(this.getNetwork().getContext().localize("ecmimpl.cmis.unsupported.object.operation", "Unsupported CMIS adapter object operation!"));
    }

    @Override
    public OwCMISObject createCopy(OwCMISObject copyParent_p, OwPropertyCollection properties_p, OwPermissionCollection permissions_p, int[] childTypes_p) throws OwException {
        try {
            OwCMISNetwork network = this.getNetwork();
            OwPropertyCollection properties = this.getProperties(null);
            OwStandardPropertyCollection propertiesToSet = new OwStandardPropertyCollection();
            Set propertiesEntries = properties.entrySet();
            for (Map.Entry propertyEntry : propertiesEntries) {
                Object propertyKey = propertyEntry.getKey();
                OwProperty property = (OwProperty)propertyEntry.getValue();
                if (property.isReadOnly(2) || property.getPropertyClass().isSystemProperty()) continue;
                if (property.getValue() != null) {
                    propertiesToSet.put(propertyKey, (Object)property);
                }
                if (properties_p == null || !properties_p.containsKey(propertyKey)) continue;
                propertiesToSet.put(propertyKey, properties_p.get(propertyKey));
            }
            OwContentCollection contentCollection = null;
            if (this.hasContent(2)) {
                contentCollection = this.getContentCollection();
            }
            OwCMISPermissionCollection permissions = null;
            if (this.canGetPermissions()) {
                permissions = this.getPermissions();
            }
            String copyDMSID = network.createNewObject(copyParent_p.getResource(), this.getClassName(), (OwPropertyCollection)propertiesToSet, permissions, contentCollection, copyParent_p, this.getMIMEType(), this.getMIMEParameter());
            return network.getObjectFromDMSID(copyDMSID, true);
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)"OwCMISObjectBase.createCopy():Could not create basic object copy!", (Throwable)e);
            throw new OwServerException(this.getNetwork().getContext().localize("ecmimpl.cmis.OwCMISObjectBase.copy.error", "Copy error!"), (Throwable)e);
        }
    }

    public String getClassName() {
        return this.getObjectClass().getClassName();
    }

    public OwCMISPermissionCollection getClonedPermissions() throws OwException {
        throw new OwNotSupportedException("OwCMISObjectBase.getClonedPermissions: Not implemented.");
    }

    public OwPropertyCollection getClonedProperties(Collection propertyNames_p) throws OwException {
        try {
            return OwStandardPropertyClass.getClonedProperties((OwObject)this, (Collection)propertyNames_p);
        }
        catch (OwException owException) {
            throw owException;
        }
        catch (Exception e) {
            LOG.fatal((Object)"OwCMISObjectBase.getClonedProperties():Properties handling error! Error cloning object properties!", (Throwable)e);
            throw new OwInvalidOperationException(this.getNetwork().getContext().localize("ecmimpl.cmis.OwCMISObjectBase.properties.handling.error", "Properties handling error!"), (Throwable)e);
        }
    }

    public Collection getColumnInfoList() throws OwException {
        return null;
    }

    public OwContentCollection getContentCollection() throws OwException {
        if (this.m_objectclass.getType() == 4097) {
            return new OwCMISContentCollection(this, this.m_network);
        }
        return null;
    }

    public Collection getFilterProperties(Collection propertyNames_p) throws OwException {
        Collection<String> col = null;
        try {
            col = propertyNames_p == null ? this.m_objectclass.getPropertyClassNames() : propertyNames_p;
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception ex) {
            LOG.error((Object)"OwCMISObject.getFilterProperties: An error occurred while retrieving the list of properties names!", (Throwable)ex);
            throw new OwServerException(this.getNetwork().getContext().localize("ecmimpl.cmis.OwCMISObjectBase.properties.handling.error", "Properties handling error!"), (Throwable)ex);
        }
        LinkedList<OwCMISPropertyClass> retLst = new LinkedList<OwCMISPropertyClass>();
        for (String name : col) {
            try {
                OwCMISPropertyClass prop = this.m_objectclass.getPropertyClass(name.toString());
                if (!prop.isQueryable(OwCMISQueryContext.GET_PROPERTY)) continue;
                retLst.add(prop);
            }
            catch (OwObjectNotFoundException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Could not retrieve the property definition of \"" + name + "\" from class \"" + this.getClassName() + "\" (Exception: " + e.getMessage() + ")"));
            }
            catch (OwException e) {
                throw e;
            }
        }
        return retLst;
    }

    public boolean getLock(int context_p) throws OwException {
        return false;
    }

    public String getLockUserID(int context_p) throws OwException {
        return null;
    }

    public boolean getMyLock(int context_p) throws OwException {
        return false;
    }

    @Override
    public CmisObjectType getNativeObject() {
        return this.m_cmisObjType;
    }

    public OwObjectCollection getParents() throws OwException {
        return null;
    }

    public String getPath() throws OwException {
        return null;
    }

    @Override
    public OwCMISPermissionCollection getPermissions() throws OwException {
        CmisAccessControlListType acl = this.fetchACL();
        return new OwCMISPermissionCollection(acl, this.getResource());
    }

    private CmisAccessControlListType fetchACL() throws OwException {
        OwCMISNetwork network = this.getNetwork();
        ACLServicePort aclService = network.getACLServicePort();
        try {
            CmisACLType serviceAcl = aclService.getACL(this.getResourceID(), this.m_decodedID, Boolean.FALSE, null);
            CmisAccessControlListType acl = serviceAcl.getACL();
            return acl;
        }
        catch (CmisException e) {
            OwNetworkContext context = network.getContext();
            OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e, context.getLocale());
            LOG.error((Object)("OwCMISObjectBase.getPermissions: could not retrieve permissions " + catcher.getLogMessage()), (Throwable)e);
            throw catcher.toOwException(context.localize("ecmimpl.cmis.Permissions.error", "An error occured during permissions handling."), false);
        }
    }

    private boolean validACLOperation(CmisAccessControlListType acl_p) {
        return acl_p != null && acl_p.getPermission() != null && !acl_p.getPermission().isEmpty();
    }

    public void setPermissions(OwPermissionCollection permissions_p) throws OwException {
        if (permissions_p instanceof OwCMISPermissionCollection) {
            OwCMISPermissionCollection cmisPermissions = (OwCMISPermissionCollection)permissions_p;
            CmisAccessControlListType currentACL = this.fetchACL();
            CmisAccessControlListType[] aclOperations = cmisPermissions.diff(currentACL);
            CmisAccessControlListType removedACL = aclOperations[0];
            CmisAccessControlListType addedACL = aclOperations[1];
            OwCMISNetwork network = this.getNetwork();
            ACLServicePort aclService = network.getACLServicePort();
            try {
                if (LOG.isDebugEnabled()) {
                    StringBuilder removedPermissions = new StringBuilder();
                    StringBuilder addedPermissions = new StringBuilder();
                    if (removedACL != null) {
                        List removedACEs = removedACL.getPermission();
                        for (CmisAccessControlEntryType ace : removedACEs) {
                            removedPermissions.append(ace.getPermission());
                            removedPermissions.append("@");
                            removedPermissions.append(ace.getPrincipal().getPrincipalId());
                        }
                    }
                    if (addedACL != null) {
                        List addedACEs = addedACL.getPermission();
                        for (CmisAccessControlEntryType ace : addedACEs) {
                            addedPermissions.append(ace.getPermission());
                            addedPermissions.append("@");
                            addedPermissions.append(ace.getPrincipal().getPrincipalId());
                        }
                    }
                    LOG.debug((Object)("Removing ACEs for OID " + this.m_decodedID + " : " + removedPermissions.toString()));
                    LOG.debug((Object)("Adding ACEs for OID " + this.m_decodedID + " : " + addedPermissions.toString()));
                }
                if (this.validACLOperation(addedACL) || this.validACLOperation(removedACL)) {
                    aclService.applyACL(this.getResourceID(), this.m_decodedID, addedACL, removedACL, EnumACLPropagation.REPOSITORYDETERMINED, null);
                }
                LOG.debug((Object)"OwCMISObjectBase.setPermissions : No ACL to set. ACLService.applyACL call skipped!");
            }
            catch (CmisException e) {
                OwNetworkContext context = network.getContext();
                OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e, context.getLocale());
                LOG.error((Object)("OwCMISObjectBase.setPermissions: could not set permissions " + catcher.getLogMessage()), (Throwable)e);
                throw catcher.toOwException(context.localize("ecmimpl.cmis.Permissions.error", "An error occured during permissions handling."), false);
            }
        } else {
            LOG.error((Object)("OwCMISObjectBase.setPermissions: Invalid permissions class " + permissions_p.getClass()));
            throw new OwServerException(this.m_network.getContext().localize("ecmimpl.cmis.Permissions.error", "An error occured during permissions handling."));
        }
    }

    public OwPropertyCollection getProperties(Collection propertyNames_p) throws OwException {
        OwCMISObjectClass objectClass = this.getObjectClass();
        LinkedList<String> nativePropertiesNames = new LinkedList<String>();
        OwStandardPropertyCollection properties = new OwStandardPropertyCollection();
        if (propertyNames_p == null) {
            propertyNames_p = objectClass.getPropertyClassNames();
        }
        for (String propertyClassName : propertyNames_p) {
            OwCMISPropertyClass propertyClass = objectClass.getPropertyClass(propertyClassName);
            if (propertyClass instanceof OwCMISNativePropertyClass) {
                OwCMISProperty prop = this.requestInternalCacheEx((OwCMISNativePropertyClass)propertyClass);
                if (prop == null) {
                    nativePropertiesNames.add(propertyClassName);
                    properties.put((Object)propertyClassName, null);
                    continue;
                }
                properties.put((Object)propertyClassName, (Object)prop);
                continue;
            }
            if (propertyClass instanceof OwCMISInternalPropertyClass) {
                OwCMISInternalPropertyClass internalClass = (OwCMISInternalPropertyClass)propertyClass;
                OwCMISInternalProperty internalProperty = internalClass.createProperty(this);
                properties.put((Object)propertyClass.getClassName(), (Object)internalProperty);
                continue;
            }
            LOG.error((Object)("OwCMISObjectBase.getProperties(): Properties handling error! Unknown property java-class " + propertyClass.getClass()));
            throw new OwInvalidOperationException(this.getNetwork().getContext().localize("ecmimpl.cmis.OwCMISObjectBase.properties.handling.error", "Properties handling error!"));
        }
        if (nativePropertiesNames.size() > 0) {
            OwPropertyCollection nativeProperties = this.retrieveCmisProperties(nativePropertiesNames, true);
            properties.putAll((Map)nativeProperties);
        }
        return properties;
    }

    @Override
    public OwCMISProperty getProperty(String propertyName_p) throws OwException {
        OwPropertyCollection properties = this.getProperties(Arrays.asList(propertyName_p));
        if (properties == null || properties.isEmpty()) {
            LOG.error((Object)("OwCMISObjectBase.getProperty(): Could not retrieve property " + propertyName_p));
            throw new OwObjectNotFoundException(this.getNetwork().getContext().localize2("ecmimpl.cmis.OwCMISObjectBase.undefined.property.error", "Undefined property error!Property %1 is not defined for object class %2!", propertyName_p, " unknown "));
        }
        Set entries = properties.entrySet();
        Map.Entry thePropertyEntry = (Map.Entry)entries.iterator().next();
        return (OwCMISProperty)thePropertyEntry.getValue();
    }

    public OwCMISResource getResource() throws OwException {
        return this.objectModel.getResource();
    }

    public OwCMISObjectModel getObjectModel() {
        return this.objectModel;
    }

    public OwSearchTemplate getSearchTemplate() throws OwException {
        return null;
    }

    public void move(OwObject object_p, OwObject oldParent_p) throws OwException {
    }

    public void refreshProperties() throws OwException {
    }

    public void refreshProperties(Collection propertyClassNames_p) throws OwException {
    }

    public void removeReference(OwObject object_p) throws OwException {
    }

    public boolean setLock(boolean lock_p) throws OwException {
        return false;
    }

    public boolean canSetProperties(int contextStatus_p) throws OwException {
        return this.m_cmisObjType.getAllowableActions().isCanUpdateProperties();
    }

    public void setProperties(OwPropertyCollection properties_p) throws OwException {
        this.setProperties(properties_p, null);
    }

    public void setProperties(OwPropertyCollection properties_p, Object mode_p) throws OwException {
        OwCMISNetwork network = this.getNetwork();
        OwCMISResource resource = this.getResource();
        OwCMISObjectExtension objectExtension = resource.getExtension(FILTER_PROPERTY_EXTENSIONS_EP, OwCMISObjectExtension.class, null);
        OwPropertyCollection propertyExtensions = objectExtension.filterPropertyExtensions(this.getResource(), this.getClassName(), properties_p);
        OwStandardPropertyCollection properties = new OwStandardPropertyCollection();
        properties.putAll((Map)properties_p);
        if (propertyExtensions != null) {
            Set extensionKeys = propertyExtensions.keySet();
            for (Object object : extensionKeys) {
                properties.remove(object);
            }
        }
        OwCMISStandardPropertyCollectionConverter converter = new OwCMISStandardPropertyCollectionConverter();
        CmisPropertiesType nativeProperties = converter.createCmisProperties((OwPropertyCollection)properties, this, this.getResourceID(), this.getNetwork());
        objectExtension = resource.getExtension(ADD_PROPERTY_EXTENSIONS_EP, OwCMISObjectExtension.class, nativeProperties);
        nativeProperties = objectExtension.addPropertyExtensions(nativeProperties, propertyExtensions, this, resource.getID(), this.getNetwork());
        ObjectServicePort objectService = network.getObjectServicePort();
        Holder idHodler = new Holder((Object)this.getDecodedID());
        Holder changeToken = new Holder((Object)this.getChangeToken());
        try {
            objectService.updateProperties(this.getResourceID(), idHodler, changeToken, nativeProperties, null);
            OwCMISPropertiesFilter filter = new OwCMISPropertiesFilter();
            filter.add(OwCMISPropertyNames.OBJECT_ID.getId());
            filter.add(OwCMISPropertyNames.OBJECT_TYPE_ID.getId());
            CmisObjectType newObject = objectService.getObject(this.getResourceID(), (String)idHodler.value, null, Boolean.TRUE, EnumIncludeRelationships.NONE, filter.getFilterString(), Boolean.FALSE, Boolean.FALSE, null);
            this.resetNativeObject(newObject);
        }
        catch (CmisException e) {
            OwNetworkContext context = network.getContext();
            OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e, context.getLocale());
            LOG.error((Object)("OwCMISObjectBase.setProperties(): Error while updating properties! A CMIS error occurred : " + catcher.getLogMessage()), (Throwable)e);
            throw catcher.toOwException(context.localize("ecmimpl.cmis.OwCMISObjectBase.setProperties.error", "Error while updating properties!"), true);
        }
    }

    public String getID() {
        return this.m_id;
    }

    public String getDecodedID() {
        return this.m_decodedID;
    }

    public OwObject getInstance() throws OwException {
        return this;
    }

    public OwObjectCollection getChilds(int[] objectTypes_p, Collection propertyNames_p, OwSort sort_p, int maxSize_p, int versionSelection_p, OwSearchNode filterCriteria_p) throws OwException {
        LOG.fatal((Object)("OwCMISDocumentObject.getChilds():Retrieval of CMIS childs is not supported for object java class " + this.getClass().getName()));
        throw new OwNotSupportedException(this.getNetwork().getContext().localize("ecmimpl.cmis.unsupported.object.operation", "Unsupported CMIS adapter object operation!"));
    }

    public String getMIMEParameter() throws OwException {
        return null;
    }

    public String getName() {
        try {
            OwCMISProperty nameProperty = this.getProperty(OwCMISPropertyNames.NAME.getId());
            Object name = nameProperty.getValue();
            if (name != null) {
                return name.toString();
            }
        }
        catch (OwException e) {
            LOG.debug((Object)"Could not retrieve the name property!", (Throwable)e);
        }
        return "";
    }

    public int getPageCount() throws OwException {
        return 0;
    }

    @Override
    public String getResourceID() throws OwException {
        return this.getResource().getID();
    }

    public boolean hasContent(int context_p) throws OwException {
        return false;
    }

    public OwField getField(String strFieldClassName_p) throws OwException {
        return this.getProperty(strFieldClassName_p);
    }

    public String getFieldProviderName() {
        return null;
    }

    public Object getFieldProviderSource() {
        return null;
    }

    public int getFieldProviderType() {
        return 1;
    }

    public Collection getFields() throws OwException {
        return this.getProperties(null).values();
    }

    public Object getSafeFieldValue(String name_p, Object defaultValue_p) {
        try {
            return this.getProperty(name_p).getValue();
        }
        catch (Exception e) {
            LOG.debug((Object)"OwCMISObject.getSafeFieldValue: error retrieving native value", (Throwable)e);
            return defaultValue_p;
        }
    }

    public void setField(String name_p, Object value_p) throws OwException {
    }

    protected OwCMISNetwork getNetwork() {
        return this.m_network;
    }

    protected OwCMISProperty retrieveCmisProperty(String cmisPropertyClassName_p) throws OwException {
        LinkedList<String> lst = new LinkedList<String>();
        lst.add(cmisPropertyClassName_p);
        OwPropertyCollection propCol = this.retrieveCmisProperties(lst, true);
        return (OwCMISProperty)propCol.get((Object)cmisPropertyClassName_p);
    }

    protected OwPropertyCollection retrieveCmisProperties(List<String> lstCmisPropertyClassNames_p, boolean strict_p) throws OwException {
        try {
            OwCMISPropertyClass propertyClass;
            OwCMISPropertiesFilter propertiesFilter = new OwCMISPropertiesFilter();
            propertiesFilter.addAll(OwCMISQueryContext.GET_PROPERTY, lstCmisPropertyClassNames_p, this.getObjectClass(), this.getResource());
            String propertiesQueryString = propertiesFilter.getFilterString();
            CmisPropertiesType lst = this.getNetwork().getObjectServicePort().getProperties(this.getResourceID(), this.getDecodedID(), "".equals(propertiesQueryString) ? null : propertiesQueryString, null);
            List properties = lst.getProperty();
            OwStandardPropertyCollection propertyCollection = new OwStandardPropertyCollection();
            for (CmisProperty prop : properties) {
                propertyClass = this.getObjectClass().getPropertyClass(prop.getPropertyDefinitionId());
                if (propertyClass instanceof OwCMISNativePropertyClass) {
                    this.m_cmisObjType.getProperties().getProperty().add(prop);
                    OwCMISNativePropertyClass nativePropertyClass = (OwCMISNativePropertyClass)propertyClass;
                    OwCMISNativeProperty property = nativePropertyClass.createProperty(prop, this.getNetwork());
                    String propertyCollectionName = propertyClass.getClassName();
                    if (strict_p) {
                        Map<String, String> namesMap = propertiesFilter.getActualNamesMap();
                        propertyCollectionName = namesMap.get(propertyClass.getQueryName(OwCMISQueryContext.GET_PROPERTY));
                    }
                    propertyCollection.put((Object)propertyCollectionName, (Object)property);
                    propertiesFilter.getActualNamesMap().remove(propertyClass.getQueryName(OwCMISQueryContext.GET_PROPERTY));
                    continue;
                }
                LOG.error((Object)("OwCMISObjectBase.init() : native property class-miss-match  id=" + prop.getPropertyDefinitionId() + " java-property-class=" + propertyClass.getClass()));
            }
            if (propertiesFilter.getActualNamesMap().size() > 0) {
                for (Map.Entry<String, String> mis : propertiesFilter.getActualNamesMap().entrySet()) {
                    propertyClass = this.getObjectClass().getPropertyClass(mis.getValue());
                    if (!(propertyClass instanceof OwCMISNativePropertyClass)) continue;
                    OwCMISNativeProperty nullProp = ((OwCMISNativePropertyClass)propertyClass).createProperty(null, this.getNetwork());
                    if (strict_p) {
                        propertyCollection.put((Object)mis.getValue(), (Object)nullProp);
                        continue;
                    }
                    propertyCollection.put((Object)propertyClass.getClassName(), (Object)nullProp);
                }
            }
            if (LOG.isDebugEnabled() && properties.size() != lstCmisPropertyClassNames_p.size()) {
                LOG.debug((Object)("OwCMISObjectBase.retrieveCmisProperties(): incomplete list retrieval with properties query String " + propertiesQueryString));
                OwCMISObjectClass objectClass = this.getObjectClass();
                Set retrievedProperties = propertyCollection.keySet();
                OwStandardPropertyCollection nullProperties = new OwStandardPropertyCollection();
                for (String propertyName : lstCmisPropertyClassNames_p) {
                    if (retrievedProperties.contains(propertyName)) continue;
                    OwCMISPropertyClass propertyClass2 = objectClass.getPropertyClass(propertyName);
                    OwCMISProperty nullProperty = propertyClass2.newProperty(this, null, this.getNetwork());
                    String propertyCollectionName = propertyClass2.getClassName();
                    if (strict_p) {
                        Map<String, String> namesMap = propertiesFilter.getActualNamesMap();
                        propertyCollectionName = namesMap.get(propertyClass2.getQueryName(OwCMISQueryContext.GET_PROPERTY));
                    }
                    nullProperties.put((Object)propertyCollectionName, (Object)nullProperty);
                    LOG.debug((Object)("OwCMISObjectBase.retrieveCmisProperties():\t - " + propertyName));
                }
                propertyCollection.putAll((Map)nullProperties);
            }
            OwCMISResource resource = this.getResource();
            OwCMISObjectExtension objectExtension = resource.getExtension(PROCESS_NATIVE_PROPERITIES_EP, OwCMISObjectExtension.class, propertyCollection);
            OwPropertyCollection exProperties = objectExtension.processNativeProperties(this, (OwPropertyCollection)propertyCollection, lst, this.getNetwork());
            return exProperties;
        }
        catch (OwException e) {
            throw e;
        }
        catch (CmisException e) {
            OwNetworkContext context = this.getNetwork().getContext();
            OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e, context.getLocale());
            LOG.error((Object)("OwCMISObjectBase.retrieveCmisProperties(): Error while retrieving properties! A CMIS error occurred : " + catcher.getLogMessage()));
            throw catcher.toOwException(context.localize("ecmimpl.cmis.OwCMISObjectBase.retrieveCmisProperties.cmis.error", "Error while retrieving properties!"), true);
        }
    }

    public boolean equals(Object obj_p) {
        if (obj_p == null || !(obj_p instanceof OwCMISObjectBase)) {
            return Boolean.FALSE;
        }
        try {
            return this.getDMSID().equals(((OwCMISObjectBase)obj_p).getDMSID());
        }
        catch (OwException ex) {
            LOG.warn((Object)"OwCMISObject.equals: Could not retrieve DMSID of object!", (Throwable)ex);
            return super.equals(obj_p);
        }
    }

    public int hashCode() {
        try {
            return this.getDMSID().hashCode();
        }
        catch (OwException e) {
            LOG.warn((Object)"OwCMISObject.hashCode: failed to retrieve DMSID", (Throwable)e);
            return super.hashCode();
        }
    }

    private OwCMISProperty requestInternalCacheEx(OwCMISNativePropertyClass propertyClass_p) throws OwException {
        OwCMISResource resource = this.getResource();
        OwCMISObjectExtension objectExtension = resource.getExtension(REQUEST_CACHED_PROPERITIES_EP, OwCMISObjectExtension.class, null);
        OwCMISNativeProperty property = objectExtension.requestCachedProperty(this, propertyClass_p, this.getNetwork());
        if (property != null) {
            return property;
        }
        return this.requestInternalCache(propertyClass_p);
    }

    private OwCMISProperty requestInternalCache(OwCMISNativePropertyClass propertyClass_p) throws OwException {
        OwCMISProperty retProp = (OwCMISProperty)this.internalCache.get((Object)propertyClass_p.getNonQualifiedName());
        if (retProp == null) {
            retProp = null;
            for (CmisProperty cachedProp : this.m_cmisObjType.getProperties().getProperty()) {
                if (!cachedProp.getPropertyDefinitionId().equals(propertyClass_p.getNonQualifiedName())) continue;
                retProp = propertyClass_p.createProperty(cachedProp, this.getNetwork());
                this.internalCache.put((Object)propertyClass_p.getNonQualifiedName(), (Object)retProp);
                break;
            }
        }
        return retProp;
    }

    private void initCache() throws OwException {
        if (this.internalCache != null) {
            this.internalCache.clear();
            this.internalCache = null;
        }
        this.internalCache = new OwStandardPropertyCollection();
    }

    protected String encodeID(String id_p) {
        return OwObjectIDCodeUtil.encode((String)id_p);
    }

    protected String decodeID(String id_p) {
        return OwObjectIDCodeUtil.decode((String)id_p);
    }

    protected String getChangeToken() throws OwException {
        OwCMISPropertyClass propClass = this.getObjectClass().getPropertyClass(OwCMISPropertyNames.CHANGE_TOKEN.getId());
        OwCMISProperty changeToken = this.getProperty(propClass.getClassName());
        return (String)changeToken.getValue();
    }
}

