/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.object;

import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISExceptionCatcher;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISObjectModel;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISResource;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISFolderObject;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISPropertyNames;
import com.wewebu.ow.server.exceptions.OwException;
import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisObjectType;
import org.oasis_open.docs.ns.cmis.core._200908.EnumIncludeRelationships;
import org.oasis_open.docs.ns.cmis.ws._200908.CmisException;
import org.oasis_open.docs.ns.cmis.ws._200908.ObjectServicePort;

public class OwCMISRepositoryFolder
extends OwCMISFolderObject {
    private static final Logger LOG = OwLog.getLogger(OwCMISRepositoryFolder.class);

    private static CmisObjectType getNativeRepositoryObject(OwCMISNetwork network_p, OwCMISResource resource_p) throws OwException {
        try {
            String filter = OwCMISPropertyNames.NONE.getId();
            ObjectServicePort objectService = network_p.getObjectServicePort();
            return objectService.getObject(resource_p.getID(), resource_p.getRepsitoryRootFolderId(), "*", Boolean.TRUE, EnumIncludeRelationships.NONE, filter, Boolean.FALSE, Boolean.FALSE, null);
        }
        catch (CmisException e) {
            OwNetworkContext context = network_p.getContext();
            OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e, context.getLocale());
            LOG.error((Object)("OwCMISRepositoryFolder.getNativeRepositoryObject(): Error while retrieving the native repository folder! A CMIS error occurred : " + catcher.getLogMessage()));
            throw catcher.toOwException(context.localize("ecmimpl.cmis.OwCMISRepositoryFolder.getNativeRepositoryObject.error", "Error while retrieving the native repository folder!"), true);
        }
    }

    public OwCMISRepositoryFolder(OwCMISNetwork network_p, OwCMISObjectModel objectModel_p) throws OwException {
        super(network_p, objectModel_p, OwCMISRepositoryFolder.getNativeRepositoryObject(network_p, objectModel_p.getResource()));
    }

    @Override
    public boolean canDelete(int context_p) throws OwException {
        return Boolean.FALSE;
    }

    @Override
    public int getType() {
        return 8194;
    }

    @Override
    public OwObjectCollection getParents() throws OwException {
        return null;
    }
}

